/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.io.File;
import java.lang.reflect.Method;

public final class Lwjgl3NativesLoader {
    public static boolean load = true;

    public static void load() {
        GdxNativesLoader.load();
        if (GdxNativesLoader.disableNativesLoading) {
            return;
        }
        if (!load) {
            return;
        }
        SharedLibraryLoader loader = new SharedLibraryLoader();
        File nativesDir = null;
        try {
            if (SharedLibraryLoader.isWindows) {
                nativesDir = loader.extractFile(SharedLibraryLoader.is64Bit ? "lwjgl.dll" : "lwjgl32.dll", null).getParentFile();
                loader.extractFile(SharedLibraryLoader.is64Bit ? "glfw.dll" : "glfw32.dll", nativesDir.getName());
                loader.extractFile(SharedLibraryLoader.is64Bit ? "jemalloc.dll" : "jemalloc32.dll", nativesDir.getName());
                loader.extractFile(SharedLibraryLoader.is64Bit ? "OpenAL.dll" : "OpenAL32.dll", nativesDir.getName());
            } else if (SharedLibraryLoader.isMac) {
                nativesDir = loader.extractFile("liblwjgl.dylib", null).getParentFile();
                loader.extractFile("libglfw.dylib", nativesDir.getName());
                loader.extractFile("libjemalloc.dylib", nativesDir.getName());
                loader.extractFile("libopenal.dylib", nativesDir.getName());
            } else if (SharedLibraryLoader.isLinux) {
                nativesDir = loader.extractFile(SharedLibraryLoader.is64Bit ? "liblwjgl.so" : "liblwjgl32.so", null).getParentFile();
                loader.extractFile(SharedLibraryLoader.is64Bit ? "libglfw.so" : "libglfw32.so", nativesDir.getName());
                loader.extractFile(SharedLibraryLoader.is64Bit ? "libjemalloc.so" : "libjemalloc32.so", nativesDir.getName());
                loader.extractFile(SharedLibraryLoader.is64Bit ? "libopenal.so" : "libopenal32.so", nativesDir.getName());
            }
        }
        catch (Throwable ex) {
            throw new GdxRuntimeException("Unable to extract LWJGL natives.", ex);
        }
        System.setProperty("org.lwjgl.librarypath", nativesDir.getAbsolutePath());
        load = false;
    }

    static {
        System.setProperty("org.lwjgl.input.Mouse.allowNegativeMouseCoords", "true");
        try {
            Method method = Class.forName("javax.jnlp.ServiceManager").getDeclaredMethod("lookup", String.class);
            method.invoke(null, "javax.jnlp.PersistenceService");
            load = false;
        }
        catch (Throwable ex) {
            load = true;
        }
    }
}

