/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Cursor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;

public class Lwjgl3Window
implements Disposable {
    private long windowHandle;
    private final ApplicationListener listener;
    private boolean listenerInitialized = false;
    private Lwjgl3WindowListener windowListener;
    private final Lwjgl3Graphics graphics;
    private final Lwjgl3Input input;
    private final Lwjgl3ApplicationConfiguration config;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    private final IntBuffer tmpBuffer;
    private final IntBuffer tmpBuffer2;
    private boolean iconified = false;
    private final GLFWWindowFocusCallback focusCallback = new GLFWWindowFocusCallback(){

        @Override
        public void invoke(long windowHandle, final int focused) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null) {
                        if (focused == 1) {
                            Lwjgl3Window.this.windowListener.focusGained();
                        } else {
                            Lwjgl3Window.this.windowListener.focusLost();
                        }
                    }
                }
            });
        }
    };
    private final GLFWWindowIconifyCallback iconifyCallback = new GLFWWindowIconifyCallback(){

        @Override
        public void invoke(long windowHandle, final int iconified) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null) {
                        if (iconified == 1) {
                            Lwjgl3Window.this.windowListener.iconified();
                        } else {
                            Lwjgl3Window.this.windowListener.deiconified();
                        }
                    }
                    Lwjgl3Window.this.iconified = iconified == 1;
                    if (iconified == 1) {
                        Lwjgl3Window.this.listener.pause();
                    } else {
                        Lwjgl3Window.this.listener.resume();
                    }
                }
            });
        }
    };
    private final GLFWWindowCloseCallback closeCallback = new GLFWWindowCloseCallback(){

        @Override
        public void invoke(final long windowHandle) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null && !Lwjgl3Window.this.windowListener.closeRequested()) {
                        GLFW.glfwSetWindowShouldClose(windowHandle, 0);
                    }
                }
            });
        }
    };
    private final GLFWDropCallback dropCallback = new GLFWDropCallback(){

        @Override
        public void invoke(long windowHandle, int count, long names) {
            final String[] files = 4.getNames(count, names);
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null) {
                        Lwjgl3Window.this.windowListener.filesDropped(files);
                    }
                }
            });
        }
    };

    Lwjgl3Window(long windowHandle, ApplicationListener listener, Lwjgl3ApplicationConfiguration config) {
        this.windowHandle = windowHandle;
        this.listener = listener;
        this.windowListener = config.windowListener;
        this.config = config;
        this.input = new Lwjgl3Input(this);
        this.graphics = new Lwjgl3Graphics(this);
        this.tmpBuffer = BufferUtils.createIntBuffer(1);
        this.tmpBuffer2 = BufferUtils.createIntBuffer(1);
        GLFW.glfwSetWindowFocusCallback(windowHandle, this.focusCallback);
        GLFW.glfwSetWindowIconifyCallback(windowHandle, this.iconifyCallback);
        GLFW.glfwSetWindowCloseCallback(windowHandle, this.closeCallback);
        GLFW.glfwSetDropCallback(windowHandle, this.dropCallback);
    }

    public ApplicationListener getListener() {
        return this.listener;
    }

    public Lwjgl3WindowListener getWindowListener() {
        return this.windowListener;
    }

    public void setWindowListener(Lwjgl3WindowListener listener) {
        this.windowListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
        }
    }

    public void setPosition(int x, int y) {
        GLFW.glfwSetWindowPos(this.windowHandle, x, y);
    }

    public int getPositionX() {
        GLFW.glfwGetWindowPos(this.windowHandle, this.tmpBuffer, this.tmpBuffer2);
        return this.tmpBuffer.get(0);
    }

    public int getPositionY() {
        GLFW.glfwGetWindowPos(this.windowHandle, this.tmpBuffer, this.tmpBuffer2);
        return this.tmpBuffer2.get(0);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            GLFW.glfwShowWindow(this.windowHandle);
        } else {
            GLFW.glfwHideWindow(this.windowHandle);
        }
    }

    public void closeWindow() {
        GLFW.glfwSetWindowShouldClose(this.windowHandle, 1);
    }

    public void iconifyWindow() {
        GLFW.glfwIconifyWindow(this.windowHandle);
    }

    public void deiconifyWindow() {
        GLFW.glfwRestoreWindow(this.windowHandle);
    }

    Lwjgl3Graphics getGraphics() {
        return this.graphics;
    }

    Lwjgl3Input getInput() {
        return this.input;
    }

    long getWindowHandle() {
        return this.windowHandle;
    }

    void windowHandleChanged(long windowHandle) {
        this.windowHandle = windowHandle;
        this.input.windowHandleChanged(windowHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Array<LifecycleListener> lifecycleListeners) {
        if (!this.listenerInitialized) {
            this.initializeListener();
        }
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.executedRunnables.addAll(this.runnables);
            this.runnables.clear();
        }
        for (Runnable runnable : this.executedRunnables) {
            runnable.run();
        }
        this.executedRunnables.clear();
        if (!this.iconified) {
            this.graphics.update();
            this.listener.render();
            GLFW.glfwSwapBuffers(this.windowHandle);
            this.input.update();
        }
    }

    boolean shouldClose() {
        return GLFW.glfwWindowShouldClose(this.windowHandle) == 1;
    }

    Lwjgl3ApplicationConfiguration getConfig() {
        return this.config;
    }

    boolean isListenerInitialized() {
        return this.listenerInitialized;
    }

    void initializeListener() {
        if (!this.listenerInitialized) {
            this.listener.create();
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
            this.listenerInitialized = true;
        }
    }

    @Override
    public void dispose() {
        this.listener.pause();
        this.listener.dispose();
        Lwjgl3Cursor.dispose(this);
        this.graphics.dispose();
        this.input.dispose();
        GLFW.glfwSetWindowFocusCallback(this.windowHandle, null);
        GLFW.glfwSetWindowIconifyCallback(this.windowHandle, null);
        GLFW.glfwSetWindowCloseCallback(this.windowHandle, null);
        GLFW.glfwSetDropCallback(this.windowHandle, null);
        GLFW.glfwDestroyWindow(this.windowHandle);
        this.focusCallback.release();
        this.iconifyCallback.release();
        this.closeCallback.release();
        this.dropCallback.release();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.windowHandle ^ this.windowHandle >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Lwjgl3Window other = (Lwjgl3Window)obj;
        return this.windowHandle == other.windowHandle;
    }
}

