/*
 * Decompiled with CFR 0.152.
 */
package com.invrs.tov;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.invrs.tov.Assets;
import com.invrs.tov.MainMenuScreen;
import com.invrs.tov.SevenSages;

public class LoadScreen
implements Screen {
    final SevenSages game;
    OrthographicCamera camera;
    private Viewport viewport;
    private Sprite black;
    private Sprite eye;
    private Sprite logo;
    private Animation eyeAnim;
    private float darkness;
    private Music logoSound;
    private float stateTime;
    private float animTime;
    private boolean ready;

    public LoadScreen(SevenSages gam) {
        this.game = gam;
        if (this.game.settings.pref.exists()) {
            this.game.settings.getSettings();
        }
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, this.game.settings.screenWidth, this.game.settings.screenHeight);
        this.viewport = new FitViewport(this.game.settings.screenWidth, (float)this.game.settings.screenHeight, this.camera);
        InputHandler key = new InputHandler();
        Gdx.input.setInputProcessor(key);
        this.logoSound = Gdx.audio.newMusic(Gdx.files.internal("audio/logo.ogg"));
        this.logoSound.setLooping(false);
        this.darkness = 1.0f;
        this.black = new Sprite(new Texture(Gdx.files.internal("images/black.png")));
        this.black.setPosition(0.0f, 0.0f);
        this.black.setSize(this.game.settings.screenWidth, this.game.settings.screenHeight);
        this.black.setAlpha(this.darkness);
        Texture eyeSheet = new Texture(Gdx.files.internal("images/eye.png"));
        this.eyeAnim = new Animation(0.1f, new TextureRegion(eyeSheet, 0, 72, 27, 12), new TextureRegion(eyeSheet, 0, 60, 27, 12), new TextureRegion(eyeSheet, 0, 48, 27, 12), new TextureRegion(eyeSheet, 0, 36, 27, 12), new TextureRegion(eyeSheet, 0, 24, 27, 12), new TextureRegion(eyeSheet, 0, 12, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 0, 27, 12), new TextureRegion(eyeSheet, 0, 12, 27, 12), new TextureRegion(eyeSheet, 0, 24, 27, 12), new TextureRegion(eyeSheet, 0, 36, 27, 12), new TextureRegion(eyeSheet, 0, 48, 27, 12), new TextureRegion(eyeSheet, 0, 60, 27, 12), new TextureRegion(eyeSheet, 0, 72, 27, 12), new TextureRegion(eyeSheet, 0, 0, 0, 0));
        this.eye = new Sprite();
        this.eye.setSize(this.game.settings.x(108.0f), this.game.settings.y(48.0f));
        this.eye.setPosition((float)this.game.settings.centerX + this.game.settings.x(80.0f), (float)this.game.settings.centerY - this.game.settings.y(50.0f));
        this.animTime = 0.0f;
        this.logo = new Sprite(new Texture(Gdx.files.internal("images/ghostlogo.png")));
        this.logo.setSize(this.game.settings.x(512.0f), this.game.settings.y(512.0f));
        this.logo.setPosition((float)this.game.settings.centerX - this.game.settings.x(245.0f), (float)this.game.settings.centerY - this.game.settings.y(256.0f));
        this.game.writing1.getData().setScale(1.0f, 1.0f);
        this.stateTime = 0.0f;
        this.ready = false;
        Assets.load();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.stateTime += Gdx.graphics.getDeltaTime();
        if (this.stateTime > 1.9f && this.stateTime < 3.0f) {
            this.darkness -= 0.0192f;
            if (this.darkness <= 0.0f) {
                this.darkness = 0.0f;
            }
            this.black.setAlpha(this.darkness);
        }
        if (Assets.manager.update()) {
            this.ready = true;
        }
        if (this.stateTime > 4.4f && Assets.manager.update()) {
            this.darkness += 0.0192f;
            if (this.darkness >= 1.0f) {
                this.darkness = 1.0f;
            }
            this.black.setAlpha(this.darkness);
            if (this.darkness == 1.0f && this.stateTime > 7.0f) {
                this.game.writing1.setColor(new Color(0.23529412f, 0.21568628f, 0.19607843f, 1.0f));
                this.game.setScreen(new MainMenuScreen(this.game));
                this.dispose();
            }
        }
        if (!this.logoSound.isPlaying() && this.stateTime < 2.0f) {
            this.logoSound.play();
        }
        this.game.batch.begin();
        this.logo.draw(this.game.batch);
        this.black.draw(this.game.batch);
        if (this.stateTime >= 2.0f) {
            this.animTime += Gdx.graphics.getDeltaTime();
            this.eye.setRegion(this.eyeAnim.getKeyFrame(this.animTime, false));
            this.eye.draw(this.game.batch);
        }
        this.game.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
        this.logoSound.dispose();
    }

    private class InputHandler
    implements InputProcessor {
        private InputHandler() {
        }

        @Override
        public boolean keyDown(int keycode) {
            if ((keycode == 62 || keycode == 131 || keycode == 66 || keycode == 32) && Assets.manager.update()) {
                LoadScreen.this.game.setScreen(new MainMenuScreen(LoadScreen.this.game));
                LoadScreen.this.dispose();
            }
            return false;
        }

        @Override
        public boolean keyUp(int keycode) {
            return false;
        }

        @Override
        public boolean keyTyped(char character) {
            return false;
        }

        @Override
        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchDragged(int screenX, int screenY, int pointer) {
            return false;
        }

        @Override
        public boolean mouseMoved(int screenX, int screenY) {
            return false;
        }

        @Override
        public boolean scrolled(int amount) {
            LoadScreen.this.camera.position.y += (float)(-(amount * 100));
            return false;
        }
    }
}

