/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EGL10 {
    public static final int EGL_ALPHA_SIZE = 12321;
    public static final int EGL_BAD_ACCESS = 12290;
    public static final int EGL_BAD_ALLOC = 12291;
    public static final int EGL_BAD_ATTRIBUTE = 12292;
    public static final int EGL_BAD_CONFIG = 12293;
    public static final int EGL_BAD_CONTEXT = 12294;
    public static final int EGL_BAD_CURRENT_SURFACE = 12295;
    public static final int EGL_BAD_DISPLAY = 12296;
    public static final int EGL_BAD_MATCH = 12297;
    public static final int EGL_BAD_NATIVE_PIXMAP = 12298;
    public static final int EGL_BAD_NATIVE_WINDOW = 12299;
    public static final int EGL_BAD_PARAMETER = 12300;
    public static final int EGL_BAD_SURFACE = 12301;
    public static final int EGL_BLUE_SIZE = 12322;
    public static final int EGL_BUFFER_SIZE = 12320;
    public static final int EGL_CONFIG_CAVEAT = 12327;
    public static final int EGL_CONFIG_ID = 12328;
    public static final int EGL_CORE_NATIVE_ENGINE = 12379;
    public static final int EGL_DEPTH_SIZE = 12325;
    public static final int EGL_DONT_CARE = -1;
    public static final int EGL_DRAW = 12377;
    public static final int EGL_EXTENSIONS = 12373;
    public static final int EGL_FALSE = 0;
    public static final int EGL_GREEN_SIZE = 12323;
    public static final int EGL_HEIGHT = 12374;
    public static final int EGL_LARGEST_PBUFFER = 12376;
    public static final int EGL_LEVEL = 12329;
    public static final int EGL_MAX_PBUFFER_HEIGHT = 12330;
    public static final int EGL_MAX_PBUFFER_PIXELS = 12331;
    public static final int EGL_MAX_PBUFFER_WIDTH = 12332;
    public static final int EGL_NATIVE_RENDERABLE = 12333;
    public static final int EGL_NATIVE_VISUAL_ID = 12334;
    public static final int EGL_NATIVE_VISUAL_TYPE = 12335;
    public static final int EGL_NONE = 12344;
    public static final int EGL_NON_CONFORMANT_CONFIG = 12369;
    public static final int EGL_NOT_INITIALIZED = 12289;
    public static final int EGL_PBUFFER_BIT = 1;
    public static final int EGL_PIXMAP_BIT = 2;
    public static final int EGL_READ = 12378;
    public static final int EGL_RED_SIZE = 12324;
    public static final int EGL_SAMPLES = 12337;
    public static final int EGL_SAMPLE_BUFFERS = 12338;
    public static final int EGL_SLOW_CONFIG = 12368;
    public static final int EGL_STENCIL_SIZE = 12326;
    public static final int EGL_SUCCESS = 12288;
    public static final int EGL_SURFACE_TYPE = 12339;
    public static final int EGL_TRANSPARENT_BLUE_VALUE = 12341;
    public static final int EGL_TRANSPARENT_GREEN_VALUE = 12342;
    public static final int EGL_TRANSPARENT_RED_VALUE = 12343;
    public static final int EGL_TRANSPARENT_RGB = 12370;
    public static final int EGL_TRANSPARENT_TYPE = 12340;
    public static final int EGL_TRUE = 1;
    public static final int EGL_VENDOR = 12371;
    public static final int EGL_VERSION = 12372;
    public static final int EGL_WIDTH = 12375;
    public static final int EGL_WINDOW_BIT = 4;
    public static final long EGL_NO_CONTEXT = 0L;
    public static final long EGL_NO_DISPLAY = 0L;
    public static final long EGL_NO_SURFACE = 0L;
    public final long ChooseConfig;
    public final long CopyBuffers;
    public final long CreateContext;
    public final long CreatePbufferSurface;
    public final long CreatePixmapSurface;
    public final long CreateWindowSurface;
    public final long DestroyContext;
    public final long DestroySurface;
    public final long GetConfigAttrib;
    public final long GetConfigs;
    public final long GetCurrentDisplay;
    public final long GetCurrentSurface;
    public final long GetDisplay;
    public final long GetError;
    public final long GetProcAddress;
    public final long Initialize;
    public final long MakeCurrent;
    public final long QueryContext;
    public final long QueryString;
    public final long QuerySurface;
    public final long SwapBuffers;
    public final long Terminate;
    public final long WaitGL;
    public final long WaitNative;

    protected EGL10() {
        throw new UnsupportedOperationException();
    }

    public EGL10(FunctionProvider provider) {
        this.ChooseConfig = provider.getFunctionAddress("eglChooseConfig");
        this.CopyBuffers = provider.getFunctionAddress("eglCopyBuffers");
        this.CreateContext = provider.getFunctionAddress("eglCreateContext");
        this.CreatePbufferSurface = provider.getFunctionAddress("eglCreatePbufferSurface");
        this.CreatePixmapSurface = provider.getFunctionAddress("eglCreatePixmapSurface");
        this.CreateWindowSurface = provider.getFunctionAddress("eglCreateWindowSurface");
        this.DestroyContext = provider.getFunctionAddress("eglDestroyContext");
        this.DestroySurface = provider.getFunctionAddress("eglDestroySurface");
        this.GetConfigAttrib = provider.getFunctionAddress("eglGetConfigAttrib");
        this.GetConfigs = provider.getFunctionAddress("eglGetConfigs");
        this.GetCurrentDisplay = provider.getFunctionAddress("eglGetCurrentDisplay");
        this.GetCurrentSurface = provider.getFunctionAddress("eglGetCurrentSurface");
        this.GetDisplay = provider.getFunctionAddress("eglGetDisplay");
        this.GetError = provider.getFunctionAddress("eglGetError");
        this.GetProcAddress = provider.getFunctionAddress("eglGetProcAddress");
        this.Initialize = provider.getFunctionAddress("eglInitialize");
        this.MakeCurrent = provider.getFunctionAddress("eglMakeCurrent");
        this.QueryContext = provider.getFunctionAddress("eglQueryContext");
        this.QueryString = provider.getFunctionAddress("eglQueryString");
        this.QuerySurface = provider.getFunctionAddress("eglQuerySurface");
        this.SwapBuffers = provider.getFunctionAddress("eglSwapBuffers");
        this.Terminate = provider.getFunctionAddress("eglTerminate");
        this.WaitGL = provider.getFunctionAddress("eglWaitGL");
        this.WaitNative = provider.getFunctionAddress("eglWaitNative");
    }

    public static EGL10 getInstance() {
        return EGL10.getInstance(EGL.getCapabilities());
    }

    public static EGL10 getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EGL10);
    }

    public static boolean neglChooseConfig(long dpy, long attrib_list, long configs, int config_size, long num_config) {
        long __functionAddress = EGL10.getInstance().ChooseConfig;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPIPZ(__functionAddress, dpy, attrib_list, configs, config_size, num_config);
    }

    public static boolean eglChooseConfig(long dpy, ByteBuffer attrib_list, ByteBuffer configs, int config_size, ByteBuffer num_config) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNT4(attrib_list, 12344);
            }
            if (configs != null) {
                Checks.checkBuffer((Buffer)configs, config_size << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)num_config, 4);
        }
        return EGL10.neglChooseConfig(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(configs), config_size, MemoryUtil.memAddress(num_config));
    }

    public static boolean eglChooseConfig(long dpy, IntBuffer attrib_list, PointerBuffer configs, IntBuffer num_config) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
            Checks.checkBuffer((Buffer)num_config, 1);
        }
        return EGL10.neglChooseConfig(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(configs), configs == null ? 0 : configs.remaining(), MemoryUtil.memAddress(num_config));
    }

    public static boolean eglCopyBuffers(long dpy, long surface, long target) {
        long __functionAddress = EGL10.getInstance().CopyBuffers;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
            Checks.checkPointer(target);
        }
        return JNI.callPPPZ(__functionAddress, dpy, surface, target);
    }

    public static long neglCreateContext(long dpy, long config, long share_context, long attrib_list) {
        long __functionAddress = EGL10.getInstance().CreateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, share_context, attrib_list);
    }

    public static long eglCreateContext(long dpy, long config, long share_context, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EGL10.neglCreateContext(dpy, config, share_context, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateContext(long dpy, long config, long share_context, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreateContext(dpy, config, share_context, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePbufferSurface(long dpy, long config, long attrib_list) {
        long __functionAddress = EGL10.getInstance().CreatePbufferSurface;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
        }
        return JNI.callPPPP(__functionAddress, dpy, config, attrib_list);
    }

    public static long eglCreatePbufferSurface(long dpy, long config, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EGL10.neglCreatePbufferSurface(dpy, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreatePbufferSurface(long dpy, long config, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreatePbufferSurface(dpy, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePixmapSurface(long dpy, long config, long pixmap, long attrib_list) {
        long __functionAddress = EGL10.getInstance().CreatePixmapSurface;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(pixmap);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, pixmap, attrib_list);
    }

    public static long eglCreatePixmapSurface(long dpy, long config, long pixmap, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EGL10.neglCreatePixmapSurface(dpy, config, pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreatePixmapSurface(long dpy, long config, long pixmap, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreatePixmapSurface(dpy, config, pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreateWindowSurface(long dpy, long config, long win, long attrib_list) {
        long __functionAddress = EGL10.getInstance().CreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(win);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, win, attrib_list);
    }

    public static long eglCreateWindowSurface(long dpy, long config, long win, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EGL10.neglCreateWindowSurface(dpy, config, win, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateWindowSurface(long dpy, long config, long win, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL10.neglCreateWindowSurface(dpy, config, win, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglDestroyContext(long dpy, long ctx) {
        long __functionAddress = EGL10.getInstance().DestroyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPZ(__functionAddress, dpy, ctx);
    }

    public static boolean eglDestroySurface(long dpy, long surface) {
        long __functionAddress = EGL10.getInstance().DestroySurface;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPZ(__functionAddress, dpy, surface);
    }

    public static boolean neglGetConfigAttrib(long dpy, long config, int attribute, long value) {
        long __functionAddress = EGL10.getInstance().GetConfigAttrib;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, config, attribute, value);
    }

    public static boolean eglGetConfigAttrib(long dpy, long config, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return EGL10.neglGetConfigAttrib(dpy, config, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglGetConfigAttrib(long dpy, long config, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return EGL10.neglGetConfigAttrib(dpy, config, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean neglGetConfigs(long dpy, long configs, int config_size, long num_config) {
        long __functionAddress = EGL10.getInstance().GetConfigs;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, configs, config_size, num_config);
    }

    public static boolean eglGetConfigs(long dpy, ByteBuffer configs, int config_size, ByteBuffer num_config) {
        if (Checks.CHECKS) {
            if (configs != null) {
                Checks.checkBuffer((Buffer)configs, config_size << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)num_config, 4);
        }
        return EGL10.neglGetConfigs(dpy, MemoryUtil.memAddressSafe(configs), config_size, MemoryUtil.memAddress(num_config));
    }

    public static boolean eglGetConfigs(long dpy, PointerBuffer configs, IntBuffer num_config) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)num_config, 1);
        }
        return EGL10.neglGetConfigs(dpy, MemoryUtil.memAddressSafe(configs), configs == null ? 0 : configs.remaining(), MemoryUtil.memAddress(num_config));
    }

    public static long eglGetCurrentDisplay() {
        long __functionAddress = EGL10.getInstance().GetCurrentDisplay;
        return JNI.callP(__functionAddress);
    }

    public static long eglGetCurrentSurface(int readdraw) {
        long __functionAddress = EGL10.getInstance().GetCurrentSurface;
        return JNI.callIP(__functionAddress, readdraw);
    }

    public static long eglGetDisplay(long display_id) {
        long __functionAddress = EGL10.getInstance().GetDisplay;
        return JNI.callPP(__functionAddress, display_id);
    }

    public static int eglGetError() {
        long __functionAddress = EGL10.getInstance().GetError;
        return JNI.callI(__functionAddress);
    }

    public static long neglGetProcAddress(long procname) {
        long __functionAddress = EGL10.getInstance().GetProcAddress;
        return JNI.callPP(__functionAddress, procname);
    }

    public static long eglGetProcAddress(ByteBuffer procname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(procname);
        }
        return EGL10.neglGetProcAddress(MemoryUtil.memAddress(procname));
    }

    public static long eglGetProcAddress(CharSequence procname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int procnameEncoded = __buffer.stringParamASCII(procname, true);
        return EGL10.neglGetProcAddress(__buffer.address(procnameEncoded));
    }

    public static boolean neglInitialize(long dpy, long major, long minor) {
        long __functionAddress = EGL10.getInstance().Initialize;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPZ(__functionAddress, dpy, major, minor);
    }

    public static boolean eglInitialize(long dpy, ByteBuffer major, ByteBuffer minor) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)major, 4);
            Checks.checkBuffer((Buffer)minor, 4);
        }
        return EGL10.neglInitialize(dpy, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static boolean eglInitialize(long dpy, IntBuffer major, IntBuffer minor) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)major, 1);
            Checks.checkBuffer((Buffer)minor, 1);
        }
        return EGL10.neglInitialize(dpy, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static boolean eglMakeCurrent(long dpy, long draw, long read, long ctx) {
        long __functionAddress = EGL10.getInstance().MakeCurrent;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(draw);
            Checks.checkPointer(read);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPPPZ(__functionAddress, dpy, draw, read, ctx);
    }

    public static boolean neglQueryContext(long dpy, long ctx, int attribute, long value) {
        long __functionAddress = EGL10.getInstance().QueryContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, ctx, attribute, value);
    }

    public static boolean eglQueryContext(long dpy, long ctx, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return EGL10.neglQueryContext(dpy, ctx, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryContext(long dpy, long ctx, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return EGL10.neglQueryContext(dpy, ctx, attribute, MemoryUtil.memAddress(value));
    }

    public static long neglQueryString(long dpy, int name) {
        long __functionAddress = EGL10.getInstance().QueryString;
        return JNI.callPIP(__functionAddress, dpy, name);
    }

    public static String eglQueryString(long dpy, int name) {
        long __result = EGL10.neglQueryString(dpy, name);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static boolean neglQuerySurface(long dpy, long surface, int attribute, long value) {
        long __functionAddress = EGL10.getInstance().QuerySurface;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, surface, attribute, value);
    }

    public static boolean eglQuerySurface(long dpy, long surface, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return EGL10.neglQuerySurface(dpy, surface, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQuerySurface(long dpy, long surface, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return EGL10.neglQuerySurface(dpy, surface, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglSwapBuffers(long dpy, long surface) {
        long __functionAddress = EGL10.getInstance().SwapBuffers;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPZ(__functionAddress, dpy, surface);
    }

    public static boolean eglTerminate(long dpy) {
        long __functionAddress = EGL10.getInstance().Terminate;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPZ(__functionAddress, dpy);
    }

    public static boolean eglWaitGL() {
        long __functionAddress = EGL10.getInstance().WaitGL;
        return JNI.callZ(__functionAddress);
    }

    public static boolean eglWaitNative(int engine) {
        long __functionAddress = EGL10.getInstance().WaitNative;
        return JNI.callIZ(__functionAddress, engine);
    }
}

