/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRFenceSync {
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE_KHR = 12528;
    public static final int EGL_SYNC_CONDITION_KHR = 12536;
    public static final int EGL_SYNC_FENCE_KHR = 12537;
    public final long CreateSyncKHR;
    public final long DestroySyncKHR;
    public final long ClientWaitSyncKHR;
    public final long GetSyncAttribKHR;

    protected KHRFenceSync() {
        throw new UnsupportedOperationException();
    }

    public KHRFenceSync(FunctionProvider provider) {
        this.CreateSyncKHR = provider.getFunctionAddress("eglCreateSyncKHR");
        this.DestroySyncKHR = provider.getFunctionAddress("eglDestroySyncKHR");
        this.ClientWaitSyncKHR = provider.getFunctionAddress("eglClientWaitSyncKHR");
        this.GetSyncAttribKHR = provider.getFunctionAddress("eglGetSyncAttribKHR");
    }

    public static KHRFenceSync getInstance() {
        return KHRFenceSync.getInstance(EGL.getCapabilities());
    }

    public static KHRFenceSync getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRFenceSync);
    }

    public static long neglCreateSyncKHR(long dpy, int type, long attrib_list) {
        long __functionAddress = KHRFenceSync.getInstance().CreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPIPP(__functionAddress, dpy, type, attrib_list);
    }

    public static long eglCreateSyncKHR(long dpy, int type, ByteBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return KHRFenceSync.neglCreateSyncKHR(dpy, type, MemoryUtil.memAddress(attrib_list));
    }

    public static long eglCreateSyncKHR(long dpy, int type, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRFenceSync.neglCreateSyncKHR(dpy, type, MemoryUtil.memAddress(attrib_list));
    }

    public static boolean eglDestroySyncKHR(long dpy, long sync) {
        long __functionAddress = KHRFenceSync.getInstance().DestroySyncKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPZ(__functionAddress, dpy, sync);
    }

    public static int eglClientWaitSyncKHR(long dpy, long sync, int flags, long timeout) {
        long __functionAddress = KHRFenceSync.getInstance().ClientWaitSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPIJI(__functionAddress, dpy, sync, flags, timeout);
    }

    public static boolean neglGetSyncAttribKHR(long dpy, long sync, int attribute, long value) {
        long __functionAddress = KHRFenceSync.getInstance().GetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, sync, attribute, value);
    }

    public static boolean eglGetSyncAttribKHR(long dpy, long sync, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return KHRFenceSync.neglGetSyncAttribKHR(dpy, sync, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglGetSyncAttribKHR(long dpy, long sync, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return KHRFenceSync.neglGetSyncAttribKHR(dpy, sync, attribute, MemoryUtil.memAddress(value));
    }
}

