/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRPartialUpdate {
    public static final int EGL_BUFFER_AGE_KHR = 12605;
    public final long SetDamageRegionKHR;

    protected KHRPartialUpdate() {
        throw new UnsupportedOperationException();
    }

    public KHRPartialUpdate(FunctionProvider provider) {
        this.SetDamageRegionKHR = provider.getFunctionAddress("eglSetDamageRegionKHR");
    }

    public static KHRPartialUpdate getInstance() {
        return KHRPartialUpdate.getInstance(EGL.getCapabilities());
    }

    public static KHRPartialUpdate getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRPartialUpdate);
    }

    public static boolean neglSetDamageRegionKHR(long dpy, long surface, long rects, int n_rects) {
        long __functionAddress = KHRPartialUpdate.getInstance().SetDamageRegionKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPPIZ(__functionAddress, dpy, surface, rects, n_rects);
    }

    public static boolean eglSetDamageRegionKHR(long dpy, long surface, ByteBuffer rects, int n_rects) {
        if (Checks.CHECKS && rects != null) {
            Checks.checkBuffer((Buffer)rects, n_rects << 2);
        }
        return KHRPartialUpdate.neglSetDamageRegionKHR(dpy, surface, MemoryUtil.memAddressSafe(rects), n_rects);
    }

    public static boolean eglSetDamageRegionKHR(long dpy, long surface, IntBuffer rects) {
        return KHRPartialUpdate.neglSetDamageRegionKHR(dpy, surface, MemoryUtil.memAddressSafe(rects), rects == null ? 0 : rects.remaining());
    }
}

