/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStreamProducerEGLSurface {
    public static final int EGL_STREAM_BIT_KHR = 2048;
    public final long CreateStreamProducerSurfaceKHR;

    protected KHRStreamProducerEGLSurface() {
        throw new UnsupportedOperationException();
    }

    public KHRStreamProducerEGLSurface(FunctionProvider provider) {
        this.CreateStreamProducerSurfaceKHR = provider.getFunctionAddress("eglCreateStreamProducerSurfaceKHR");
    }

    public static KHRStreamProducerEGLSurface getInstance() {
        return KHRStreamProducerEGLSurface.getInstance(EGL.getCapabilities());
    }

    public static KHRStreamProducerEGLSurface getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRStreamProducerEGLSurface);
    }

    public static long neglCreateStreamProducerSurfaceKHR(long dpy, long config, long stream, long attrib_list) {
        long __functionAddress = KHRStreamProducerEGLSurface.getInstance().CreateStreamProducerSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(stream);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, stream, attrib_list);
    }

    public static long eglCreateStreamProducerSurfaceKHR(long dpy, long config, long stream, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return KHRStreamProducerEGLSurface.neglCreateStreamProducerSurfaceKHR(dpy, config, stream, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateStreamProducerSurfaceKHR(long dpy, long config, long stream, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRStreamProducerEGLSurface.neglCreateStreamProducerSurfaceKHR(dpy, config, stream, MemoryUtil.memAddressSafe(attrib_list));
    }
}

