/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.macosx.ObjCRuntime;
import org.lwjgl.system.macosx.Unistd;

final class EventLoop {
    private EventLoop() {
    }

    private static boolean isMainThread() {
        long NSThread;
        long currentThread;
        long objc_msgSend = ObjCRuntime.getLibrary().getFunctionAddress("objc_msgSend");
        return JNI.invokePPB(objc_msgSend, currentThread = JNI.invokePPP(objc_msgSend, NSThread = ObjCRuntime.objc_getClass("NSThread"), ObjCRuntime.sel_getUid("currentThread")), ObjCRuntime.sel_getUid("isMainThread")) != 0;
    }

    private static boolean isJavaStartedOnFirstThread() {
        return "1".equals(System.getenv().get("JAVA_STARTED_ON_FIRST_THREAD_" + Unistd.getpid()));
    }

    static final class OnScreen {
        private OnScreen() {
        }

        static void check() {
        }

        static {
            if (Platform.get() == Platform.MACOSX && !EventLoop.isMainThread()) {
                throw new IllegalStateException("Please run the JVM with -XstartOnFirstThread and make sure a window toolkit other than GLFW (e.g. AWT or JavaFX) is not initialized.");
            }
        }
    }

    static final class OffScreen {
        private OffScreen() {
        }

        static void check() {
        }

        static {
            if (Platform.get() == Platform.MACOSX && !EventLoop.isMainThread()) {
                SharedLibrary AppKit = Library.loadNative("/System/Library/Frameworks/AppKit.framework");
                try {
                    long NSApp = AppKit.getFunctionAddress("NSApp");
                    if (MemoryUtil.memGetAddress(NSApp) == 0L) {
                        throw new IllegalStateException(EventLoop.isJavaStartedOnFirstThread() ? "GLFW windows may only be created on the main thread." : "GLFW windows may only be created on the main thread and that thread must be the first thread in the process. Please run the JVM with -XstartOnFirstThread. For offscreen rendering, make sure another window toolkit (e.g. AWT or JavaFX) is initialized before GLFW.");
                    }
                    APIUtil.apiLog("GLFW can only be used for offscreen rendering.");
                }
                finally {
                    AppKit.release();
                }
            }
        }
    }
}

