/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.SharedLibrary;

public class GLFWNativeGLX {
    public final long GetGLXContext;
    public final long GetGLXWindow;
    private static final GLFWNativeGLX instance = new GLFWNativeGLX(GLFWNativeGLX.getLibrary());

    protected GLFWNativeGLX() {
        throw new UnsupportedOperationException();
    }

    public GLFWNativeGLX(FunctionProvider provider) {
        this.GetGLXContext = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetGLXContext"));
        this.GetGLXWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetGLXWindow"));
    }

    public static SharedLibrary getLibrary() {
        return GLFW.getLibrary();
    }

    public static GLFWNativeGLX getInstance() {
        return instance;
    }

    public static long glfwGetGLXContext(long window) {
        long __functionAddress = GLFWNativeGLX.getInstance().GetGLXContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }

    public static long glfwGetGLXWindow(long window) {
        long __functionAddress = GLFWNativeGLX.getInstance().GetGLXWindow;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }
}

