/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.OpenCLException;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class CL {
    private static FunctionProviderLocal functionProvider;
    private static CLCapabilities icd;

    private CL() {
    }

    public static void create() {
        SharedLibrary CL2;
        switch (Platform.get()) {
            case LINUX: 
            case WINDOWS: {
                CL2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENCL, "OpenCL");
                break;
            }
            case MACOSX: {
                CL2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENCL, "OpenCL", "/System/Library/Frameworks/OpenCL.framework");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        CL.create(CL2);
    }

    public static void create(String libName) {
        CL.create(Library.loadNative(libName));
    }

    public static void create(final SharedLibrary OPENCL) {
        try {
            FunctionProviderLocal.Default functionProvider = new FunctionProviderLocal.Default(){
                private final long clGetExtensionFunctionAddress;
                private final long clGetExtensionFunctionAddressForPlatform;
                private final long platform;
                {
                    this.clGetExtensionFunctionAddress = OPENCL.getFunctionAddress("clGetExtensionFunctionAddress");
                    this.clGetExtensionFunctionAddressForPlatform = OPENCL.getFunctionAddress("clGetExtensionFunctionAddressForPlatform");
                    if (this.clGetExtensionFunctionAddress == 0L && this.clGetExtensionFunctionAddressForPlatform == 0L) {
                        OPENCL.release();
                        throw new OpenCLException("A core OpenCL function is missing. Make sure that OpenCL is available.");
                    }
                    long platform = 0L;
                    if (this.clGetExtensionFunctionAddressForPlatform != 0L) {
                        long clGetPlatformIDs = OPENCL.getFunctionAddress("clGetPlatformIDs");
                        if (clGetPlatformIDs == 0L) {
                            throw new OpenCLException("A core OpenCL function is missing. Make sure that OpenCL is available.");
                        }
                        APIBuffer __buffer = APIUtil.apiBuffer();
                        JNI.callIPPI(clGetPlatformIDs, 0, 0L, __buffer.address());
                        int platforms = __buffer.intValue(0);
                        if (platforms == 1) {
                            JNI.callIPPI(clGetPlatformIDs, 1, __buffer.address(), 0L);
                            long cl_platform_id = __buffer.pointerValue(0);
                            if (this.supportsOpenCL12(__buffer, cl_platform_id)) {
                                platform = cl_platform_id;
                            }
                        } else if (this.clGetExtensionFunctionAddress == 0L) {
                            throw new IllegalStateException();
                        }
                    }
                    this.platform = platform;
                }

                private boolean supportsOpenCL12(APIBuffer __buffer, long platform) {
                    long clGetPlatformInfo = OPENCL.getFunctionAddress("clGetPlatformInfo");
                    if (clGetPlatformInfo == 0L) {
                        return false;
                    }
                    int errcode = JNI.callPIPPPI(clGetPlatformInfo, platform, 2305, 0L, 0L, __buffer.address());
                    if (errcode != 0) {
                        return false;
                    }
                    long bytes = __buffer.pointerValue(0);
                    __buffer.bufferParam((int)bytes);
                    errcode = JNI.callPIPPPI(clGetPlatformInfo, platform, 2305, bytes, __buffer.address(), 0L);
                    if (errcode != 0) {
                        return false;
                    }
                    APIUtil.APIVersion version = APIUtil.apiParseVersion(__buffer.stringValueASCII(0, (int)bytes - 1), "OpenCL");
                    return 1 < version.major || 2 <= version.minor;
                }

                @Override
                public long getFunctionAddress(CharSequence functionName) {
                    long address;
                    APIBuffer __buffer = APIUtil.apiBuffer();
                    __buffer.stringParamASCII(functionName, true);
                    long l = address = this.platform == 0L ? JNI.callPP(this.clGetExtensionFunctionAddress, __buffer.address()) : JNI.callPPP(this.clGetExtensionFunctionAddressForPlatform, this.platform, __buffer.address());
                    if (address == 0L) {
                        address = OPENCL.getFunctionAddress(functionName);
                    }
                    return address;
                }

                @Override
                public long getFunctionAddress(long handle, CharSequence functionName) {
                    APIBuffer __buffer = APIUtil.apiBuffer();
                    __buffer.stringParamASCII(functionName, true);
                    return JNI.callPPP(this.clGetExtensionFunctionAddressForPlatform, handle, __buffer.address());
                }

                @Override
                protected void destroy() {
                    OPENCL.release();
                }
            };
            CL.create(functionProvider);
        }
        catch (RuntimeException e) {
            OPENCL.release();
            throw e;
        }
    }

    public static void create(FunctionProviderLocal functionProvider) {
        if (CL.functionProvider != null) {
            throw new IllegalStateException("OpenCL has already been created.");
        }
        CL.functionProvider = functionProvider;
        icd = new CLCapabilities(functionProvider);
        if (CL.icd.__CL10 == null) {
            throw new IllegalStateException("OpenCL 1.0 is missing. Make sure that OpenCL is available");
        }
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        functionProvider.release();
        functionProvider = null;
        icd = null;
    }

    public static FunctionProviderLocal getFunctionProvider() {
        return functionProvider;
    }

    public static CLCapabilities getICD() {
        return icd;
    }

    static void addExtensions(String extensionsString, Set<String> supportedExtensions) {
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static void addCLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions) {
        CL.addCLVersions(MAJOR, MINOR, supportedExtensions, "", new int[][]{{0, 1, 2}, {0}});
        if (supportedExtensions.contains("cl_khr_gl_sharing") || supportedExtensions.contains("cl_APPLE_gl_sharing")) {
            CL.addCLVersions(MAJOR, MINOR, supportedExtensions, "GL", new int[][]{{0, 2}, new int[0]});
        }
    }

    private static void addCLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions, String postfix, int[][] versions) {
        block0: for (int major = 1; major <= Math.min(MAJOR, versions.length); ++major) {
            for (int minor : versions[major - 1]) {
                if (major == MAJOR && MINOR < minor) continue block0;
                supportedExtensions.add(String.format("OpenCL%d%d%s", major, minor, postfix));
            }
        }
    }

    static <T> T checkExtension(Set<String> ext, String extension, T functions) {
        if (ext.contains(extension)) {
            if (functions != null) {
                return functions;
            }
            APIUtil.apiLog("[CL] " + extension + " was reported as available but an entry point is missing.");
        }
        return null;
    }

    static {
        if (!((Boolean)Configuration.EXPLICIT_INIT_OPENCL.get()).booleanValue()) {
            CL.create();
        }
    }
}

