/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLImageFormat
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int IMAGE_CHANNEL_ORDER;
    public static final int IMAGE_CHANNEL_DATA_TYPE;

    CLImageFormat(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public CLImageFormat(long struct) {
        this(struct, null);
    }

    public CLImageFormat(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int image_channel_order() {
        return CLImageFormat.nimage_channel_order(this.address());
    }

    public int image_channel_data_type() {
        return CLImageFormat.nimage_channel_data_type(this.address());
    }

    public CLImageFormat image_channel_order(int value) {
        CLImageFormat.nimage_channel_order(this.address(), value);
        return this;
    }

    public CLImageFormat image_channel_data_type(int value) {
        CLImageFormat.nimage_channel_data_type(this.address(), value);
        return this;
    }

    public CLImageFormat set(int image_channel_order, int image_channel_data_type) {
        this.image_channel_order(image_channel_order);
        this.image_channel_data_type(image_channel_data_type);
        return this;
    }

    public CLImageFormat nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public CLImageFormat set(CLImageFormat src) {
        return this.nset(src.address());
    }

    public CLImageFormat set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static CLImageFormat malloc() {
        return new CLImageFormat(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CLImageFormat calloc() {
        return new CLImageFormat(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CLImageFormat create() {
        return new CLImageFormat(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nimage_channel_order(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE_CHANNEL_ORDER);
    }

    public static int nimage_channel_data_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE_CHANNEL_DATA_TYPE);
    }

    public static void nimage_channel_order(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE_CHANNEL_ORDER, value);
    }

    public static void nimage_channel_data_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE_CHANNEL_DATA_TYPE, value);
    }

    static {
        Struct.Layout layout = CLImageFormat.__struct(CLImageFormat.__member(4), CLImageFormat.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        IMAGE_CHANNEL_ORDER = layout.offsetof(0);
        IMAGE_CHANNEL_DATA_TYPE = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<CLImageFormat, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected CLImageFormat newInstance(long address) {
            return new CLImageFormat(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int image_channel_order() {
            return CLImageFormat.nimage_channel_order(this.address());
        }

        public int image_channel_data_type() {
            return CLImageFormat.nimage_channel_data_type(this.address());
        }

        public Buffer image_channel_order(int value) {
            CLImageFormat.nimage_channel_order(this.address(), value);
            return this;
        }

        public Buffer image_channel_data_type(int value) {
            CLImageFormat.nimage_channel_data_type(this.address(), value);
            return this;
        }
    }
}

