/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTMigrateMemobject {
    public static final int CL_MIGRATE_MEM_OBJECT_HOST_EXT = 1;
    public static final int CL_COMMAND_MIGRATE_MEM_OBJECT_EXT = 16448;
    public final long EnqueueMigrateMemObjectEXT;

    protected EXTMigrateMemobject() {
        throw new UnsupportedOperationException();
    }

    public EXTMigrateMemobject(FunctionProvider provider) {
        this.EnqueueMigrateMemObjectEXT = provider.getFunctionAddress("clEnqueueMigrateMemObjectEXT");
    }

    public static EXTMigrateMemobject getInstance() {
        return EXTMigrateMemobject.getInstance(CL.getICD());
    }

    public static EXTMigrateMemobject getInstance(CLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTMigrateMemobject);
    }

    static EXTMigrateMemobject create(FunctionProvider provider) {
        EXTMigrateMemobject funcs = new EXTMigrateMemobject(provider);
        boolean supported = Checks.checkFunctions(funcs.EnqueueMigrateMemObjectEXT);
        return supported ? funcs : null;
    }

    public static int nclEnqueueMigrateMemObjectEXT(long command_queue, int num_mem_objects, long mem_objects, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = EXTMigrateMemobject.getInstance().EnqueueMigrateMemObjectEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
        }
        return JNI.callPIPJIPPI(__functionAddress, command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueMigrateMemObjectEXT(long command_queue, int num_mem_objects, ByteBuffer mem_objects, long flags, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_mem_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return EXTMigrateMemobject.nclEnqueueMigrateMemObjectEXT(command_queue, num_mem_objects, MemoryUtil.memAddress(mem_objects), flags, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueMigrateMemObjectEXT(long command_queue, PointerBuffer mem_objects, long flags, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return EXTMigrateMemobject.nclEnqueueMigrateMemObjectEXT(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), flags, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

