/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class AMDVertexShaderTessellator {
    public static final int GL_SAMPLER_BUFFER_AMD = 36865;
    public static final int GL_INT_SAMPLER_BUFFER_AMD = 36866;
    public static final int GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD = 36867;
    public static final int GL_DISCRETE_AMD = 36870;
    public static final int GL_CONTINUOUS_AMD = 36871;
    public static final int GL_TESSELLATION_MODE_AMD = 36868;
    public static final int GL_TESSELLATION_FACTOR_AMD = 36869;
    public final long TessellationFactorAMD;
    public final long TessellationModeAMD;

    protected AMDVertexShaderTessellator() {
        throw new UnsupportedOperationException();
    }

    public AMDVertexShaderTessellator(FunctionProvider provider) {
        this.TessellationFactorAMD = provider.getFunctionAddress("glTessellationFactorAMD");
        this.TessellationModeAMD = provider.getFunctionAddress("glTessellationModeAMD");
    }

    public static AMDVertexShaderTessellator getInstance() {
        return AMDVertexShaderTessellator.getInstance(GL.getCapabilities());
    }

    public static AMDVertexShaderTessellator getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__AMDVertexShaderTessellator);
    }

    static AMDVertexShaderTessellator create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_AMD_vertex_shader_tessellator")) {
            return null;
        }
        AMDVertexShaderTessellator funcs = new AMDVertexShaderTessellator(provider);
        boolean supported = Checks.checkFunctions(funcs.TessellationFactorAMD, funcs.TessellationModeAMD);
        return GL.checkExtension("GL_AMD_vertex_shader_tessellator", funcs, supported);
    }

    public static void glTessellationFactorAMD(float factor) {
        long __functionAddress = AMDVertexShaderTessellator.getInstance().TessellationFactorAMD;
        JNI.callFV(__functionAddress, factor);
    }

    public static void glTessellationModeAMD(int mode) {
        long __functionAddress = AMDVertexShaderTessellator.getInstance().TessellationModeAMD;
        JNI.callIV(__functionAddress, mode);
    }
}

