/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBBaseInstance {
    public final long DrawArraysInstancedBaseInstance;
    public final long DrawElementsInstancedBaseInstance;
    public final long DrawElementsInstancedBaseVertexBaseInstance;

    protected ARBBaseInstance() {
        throw new UnsupportedOperationException();
    }

    public ARBBaseInstance(FunctionProvider provider) {
        this.DrawArraysInstancedBaseInstance = provider.getFunctionAddress("glDrawArraysInstancedBaseInstance");
        this.DrawElementsInstancedBaseInstance = provider.getFunctionAddress("glDrawElementsInstancedBaseInstance");
        this.DrawElementsInstancedBaseVertexBaseInstance = provider.getFunctionAddress("glDrawElementsInstancedBaseVertexBaseInstance");
    }

    public static ARBBaseInstance getInstance() {
        return ARBBaseInstance.getInstance(GL.getCapabilities());
    }

    public static ARBBaseInstance getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBBaseInstance);
    }

    static ARBBaseInstance create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_base_instance")) {
            return null;
        }
        ARBBaseInstance funcs = new ARBBaseInstance(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedBaseInstance, funcs.DrawElementsInstancedBaseInstance, funcs.DrawElementsInstancedBaseVertexBaseInstance);
        return GL.checkExtension("GL_ARB_base_instance", funcs, supported);
    }

    public static void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int primcount, int baseinstance) {
        long __functionAddress = ARBBaseInstance.getInstance().DrawArraysInstancedBaseInstance;
        JNI.callIIIIIV(__functionAddress, mode, first, count, primcount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseInstance(int mode, int count, int type, long indices, int primcount, int baseinstance) {
        long __functionAddress = ARBBaseInstance.getInstance().DrawElementsInstancedBaseInstance;
        JNI.callIIIPIIV(__functionAddress, mode, count, type, indices, primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int count, int type, ByteBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLChecks.typeToByteShift(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, count, type, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int count, int type, long indicesOffset, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, count, type, indicesOffset, primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int type, ByteBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, ByteBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, ShortBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, IntBuffer indices, int primcount, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indices, int primcount, int basevertex, int baseinstance) {
        long __functionAddress = ARBBaseInstance.getInstance().DrawElementsInstancedBaseVertexBaseInstance;
        JNI.callIIIPIIIV(__functionAddress, mode, count, type, indices, primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLChecks.typeToByteShift(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indicesOffset, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indicesOffset, primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int type, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, ShortBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, IntBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }
}

