/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBBlendFuncExtended {
    public static final int GL_SRC1_COLOR = 35065;
    public static final int GL_ONE_MINUS_SRC1_COLOR = 35066;
    public static final int GL_ONE_MINUS_SRC1_ALPHA = 35067;
    public static final int GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 35068;
    public final long BindFragDataLocationIndexed;
    public final long GetFragDataIndex;

    protected ARBBlendFuncExtended() {
        throw new UnsupportedOperationException();
    }

    public ARBBlendFuncExtended(FunctionProvider provider) {
        this.BindFragDataLocationIndexed = provider.getFunctionAddress("glBindFragDataLocationIndexed");
        this.GetFragDataIndex = provider.getFunctionAddress("glGetFragDataIndex");
    }

    public static ARBBlendFuncExtended getInstance() {
        return ARBBlendFuncExtended.getInstance(GL.getCapabilities());
    }

    public static ARBBlendFuncExtended getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBBlendFuncExtended);
    }

    static ARBBlendFuncExtended create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_blend_func_extended")) {
            return null;
        }
        ARBBlendFuncExtended funcs = new ARBBlendFuncExtended(provider);
        boolean supported = Checks.checkFunctions(funcs.BindFragDataLocationIndexed, funcs.GetFragDataIndex);
        return GL.checkExtension("GL_ARB_blend_func_extended", funcs, supported);
    }

    public static void nglBindFragDataLocationIndexed(int program, int colorNumber, int index, long name) {
        long __functionAddress = ARBBlendFuncExtended.getInstance().BindFragDataLocationIndexed;
        JNI.callIIIPV(__functionAddress, program, colorNumber, index, name);
    }

    public static void glBindFragDataLocationIndexed(int program, int colorNumber, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        ARBBlendFuncExtended.nglBindFragDataLocationIndexed(program, colorNumber, index, MemoryUtil.memAddress(name));
    }

    public static void glBindFragDataLocationIndexed(int program, int colorNumber, int index, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        ARBBlendFuncExtended.nglBindFragDataLocationIndexed(program, colorNumber, index, __buffer.address(nameEncoded));
    }

    public static int nglGetFragDataIndex(int program, long name) {
        long __functionAddress = ARBBlendFuncExtended.getInstance().GetFragDataIndex;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetFragDataIndex(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBBlendFuncExtended.nglGetFragDataIndex(program, MemoryUtil.memAddress(name));
    }

    public static int glGetFragDataIndex(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return ARBBlendFuncExtended.nglGetFragDataIndex(program, __buffer.address(nameEncoded));
    }
}

