/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBBufferStorage {
    public static final int GL_MAP_PERSISTENT_BIT = 64;
    public static final int GL_MAP_COHERENT_BIT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT = 256;
    public static final int GL_CLIENT_STORAGE_BIT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 16384;
    public final long BufferStorage;
    public final long NamedBufferStorageEXT;

    protected ARBBufferStorage() {
        throw new UnsupportedOperationException();
    }

    public ARBBufferStorage(FunctionProvider provider) {
        this.BufferStorage = provider.getFunctionAddress("glBufferStorage");
        this.NamedBufferStorageEXT = provider.getFunctionAddress("glNamedBufferStorageEXT");
    }

    public static ARBBufferStorage getInstance() {
        return ARBBufferStorage.getInstance(GL.getCapabilities());
    }

    public static ARBBufferStorage getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBBufferStorage);
    }

    static ARBBufferStorage create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_buffer_storage")) {
            return null;
        }
        ARBBufferStorage funcs = new ARBBufferStorage(provider);
        boolean supported = Checks.checkFunctions(funcs.BufferStorage, ext.contains("GL_EXT_direct_state_access") ? funcs.NamedBufferStorageEXT : -1L);
        return GL.checkExtension("GL_ARB_buffer_storage", funcs, supported);
    }

    public static void nglBufferStorage(int target, long size, long data, int flags) {
        long __functionAddress = ARBBufferStorage.getInstance().BufferStorage;
        JNI.callIPPIV(__functionAddress, target, size, data, flags);
    }

    public static void glBufferStorage(int target, long size, ByteBuffer data, int flags) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBBufferStorage.nglBufferStorage(target, size, MemoryUtil.memAddressSafe(data), flags);
    }

    public static void glBufferStorage(int target, long size, int flags) {
        ARBBufferStorage.nglBufferStorage(target, size, 0L, flags);
    }

    public static void glBufferStorage(int target, ByteBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, ShortBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, IntBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, FloatBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, DoubleBuffer data, int flags) {
        ARBBufferStorage.nglBufferStorage(target, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static void nglNamedBufferStorageEXT(int buffer, long size, long data, int flags) {
        long __functionAddress = ARBBufferStorage.getInstance().NamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPPIV(__functionAddress, buffer, size, data, flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, long size, ByteBuffer data, int flags) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, size, MemoryUtil.memAddressSafe(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, long size, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, ByteBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, ShortBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, IntBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, FloatBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorageEXT(int buffer, DoubleBuffer data, int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }
}

