/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBClearBufferObject {
    public final long ClearBufferData;
    public final long ClearBufferSubData;
    public final long ClearNamedBufferDataEXT;
    public final long ClearNamedBufferSubDataEXT;

    protected ARBClearBufferObject() {
        throw new UnsupportedOperationException();
    }

    public ARBClearBufferObject(FunctionProvider provider) {
        this.ClearBufferData = provider.getFunctionAddress("glClearBufferData");
        this.ClearBufferSubData = provider.getFunctionAddress("glClearBufferSubData");
        this.ClearNamedBufferDataEXT = provider.getFunctionAddress("glClearNamedBufferDataEXT");
        this.ClearNamedBufferSubDataEXT = provider.getFunctionAddress("glClearNamedBufferSubDataEXT");
    }

    public static ARBClearBufferObject getInstance() {
        return ARBClearBufferObject.getInstance(GL.getCapabilities());
    }

    public static ARBClearBufferObject getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBClearBufferObject);
    }

    static ARBClearBufferObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_clear_buffer_object")) {
            return null;
        }
        ARBClearBufferObject funcs = new ARBClearBufferObject(provider);
        boolean supported = Checks.checkFunctions(funcs.ClearBufferData, funcs.ClearBufferSubData, ext.contains("GL_EXT_direct_state_access") ? funcs.ClearNamedBufferDataEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.ClearNamedBufferSubDataEXT : -1L);
        return GL.checkExtension("GL_ARB_clear_buffer_object", funcs, supported);
    }

    public static void nglClearBufferData(int target, int internalformat, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearBufferData;
        JNI.callIIIIPV(__functionAddress, target, internalformat, format, type, data);
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearBufferSubData;
        JNI.callIIPPIIPV(__functionAddress, target, internalformat, offset, size, format, type, data);
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearNamedBufferDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIPV(__functionAddress, buffer, internalformat, format, type, data);
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearNamedBufferSubDataEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPPIIPV(__functionAddress, buffer, internalformat, offset, size, format, type, data);
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }
}

