/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBDrawIndirect {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public final long DrawArraysIndirect;
    public final long DrawElementsIndirect;

    protected ARBDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    public ARBDrawIndirect(FunctionProvider provider) {
        this.DrawArraysIndirect = provider.getFunctionAddress("glDrawArraysIndirect");
        this.DrawElementsIndirect = provider.getFunctionAddress("glDrawElementsIndirect");
    }

    public static ARBDrawIndirect getInstance() {
        return ARBDrawIndirect.getInstance(GL.getCapabilities());
    }

    public static ARBDrawIndirect getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBDrawIndirect);
    }

    static ARBDrawIndirect create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_draw_indirect")) {
            return null;
        }
        ARBDrawIndirect funcs = new ARBDrawIndirect(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysIndirect, funcs.DrawElementsIndirect);
        return GL.checkExtension("GL_ARB_draw_indirect", funcs, supported);
    }

    public static void nglDrawArraysIndirect(int mode, long indirect) {
        long __functionAddress = ARBDrawIndirect.getInstance().DrawArraysIndirect;
        JNI.callIPV(__functionAddress, mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 16);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirectOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, indirectOffset);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 4);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void nglDrawElementsIndirect(int mode, int type, long indirect) {
        long __functionAddress = ARBDrawIndirect.getInstance().DrawElementsIndirect;
        JNI.callIIPV(__functionAddress, mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 20);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirectOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, indirectOffset);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 5);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }
}

