/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBSampleLocations {
    public static final int GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB = 37693;
    public static final int GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB = 37694;
    public static final int GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB = 37695;
    public static final int GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB = 37696;
    public static final int GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB = 37698;
    public static final int GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB = 37699;
    public final long FramebufferSampleLocationsfvARB;
    public final long NamedFramebufferSampleLocationsfvARB;
    public final long EvaluateDepthValuesARB;

    protected ARBSampleLocations() {
        throw new UnsupportedOperationException();
    }

    public ARBSampleLocations(FunctionProvider provider) {
        this.FramebufferSampleLocationsfvARB = provider.getFunctionAddress("glFramebufferSampleLocationsfvARB");
        this.NamedFramebufferSampleLocationsfvARB = provider.getFunctionAddress("glNamedFramebufferSampleLocationsfvARB");
        this.EvaluateDepthValuesARB = provider.getFunctionAddress("glEvaluateDepthValuesARB");
    }

    public static ARBSampleLocations getInstance() {
        return ARBSampleLocations.getInstance(GL.getCapabilities());
    }

    public static ARBSampleLocations getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBSampleLocations);
    }

    static ARBSampleLocations create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_sample_locations")) {
            return null;
        }
        ARBSampleLocations funcs = new ARBSampleLocations(provider);
        boolean supported = Checks.checkFunctions(funcs.FramebufferSampleLocationsfvARB, funcs.NamedFramebufferSampleLocationsfvARB, funcs.EvaluateDepthValuesARB);
        return GL.checkExtension("GL_ARB_sample_locations", funcs, supported);
    }

    public static void nglFramebufferSampleLocationsfvARB(int target, int start, int count, long v) {
        long __functionAddress = ARBSampleLocations.getInstance().FramebufferSampleLocationsfvARB;
        JNI.callIIIPV(__functionAddress, target, start, count, v);
    }

    public static void glFramebufferSampleLocationsfvARB(int target, int start, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 2);
        }
        ARBSampleLocations.nglFramebufferSampleLocationsfvARB(target, start, count, MemoryUtil.memAddress(v));
    }

    public static void glFramebufferSampleLocationsfvARB(int target, int start, FloatBuffer v) {
        ARBSampleLocations.nglFramebufferSampleLocationsfvARB(target, start, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static void nglNamedFramebufferSampleLocationsfvARB(int framebuffer, int start, int count, long v) {
        long __functionAddress = ARBSampleLocations.getInstance().NamedFramebufferSampleLocationsfvARB;
        JNI.callIIIPV(__functionAddress, framebuffer, start, count, v);
    }

    public static void glNamedFramebufferSampleLocationsfvARB(int framebuffer, int start, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 2);
        }
        ARBSampleLocations.nglNamedFramebufferSampleLocationsfvARB(framebuffer, start, count, MemoryUtil.memAddress(v));
    }

    public static void glNamedFramebufferSampleLocationsfvARB(int framebuffer, int start, FloatBuffer v) {
        ARBSampleLocations.nglNamedFramebufferSampleLocationsfvARB(framebuffer, start, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static void glEvaluateDepthValuesARB() {
        long __functionAddress = ARBSampleLocations.getInstance().EvaluateDepthValuesARB;
        JNI.callV(__functionAddress);
    }
}

