/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class ARBSparseTexture {
    public static final int GL_TEXTURE_SPARSE_ARB = 37286;
    public static final int GL_VIRTUAL_PAGE_SIZE_INDEX_ARB = 37287;
    public static final int GL_NUM_SPARSE_LEVELS_ARB = 37290;
    public static final int GL_NUM_VIRTUAL_PAGE_SIZES_ARB = 37288;
    public static final int GL_VIRTUAL_PAGE_SIZE_X_ARB = 37269;
    public static final int GL_VIRTUAL_PAGE_SIZE_Y_ARB = 37270;
    public static final int GL_VIRTUAL_PAGE_SIZE_Z_ARB = 37271;
    public static final int GL_MAX_SPARSE_TEXTURE_SIZE_ARB = 37272;
    public static final int GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 37273;
    public static final int GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = 37274;
    public static final int GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 37289;
    public final long TexPageCommitmentARB;
    public final long TexturePageCommitmentEXT;

    protected ARBSparseTexture() {
        throw new UnsupportedOperationException();
    }

    public ARBSparseTexture(FunctionProvider provider) {
        this.TexPageCommitmentARB = provider.getFunctionAddress("glTexPageCommitmentARB");
        this.TexturePageCommitmentEXT = provider.getFunctionAddress("glTexturePageCommitmentEXT");
    }

    public static ARBSparseTexture getInstance() {
        return ARBSparseTexture.getInstance(GL.getCapabilities());
    }

    public static ARBSparseTexture getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBSparseTexture);
    }

    static ARBSparseTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_sparse_texture")) {
            return null;
        }
        ARBSparseTexture funcs = new ARBSparseTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.TexPageCommitmentARB, ext.contains("GL_EXT_direct_state_access") ? funcs.TexturePageCommitmentEXT : -1L);
        return GL.checkExtension("GL_ARB_sparse_texture", funcs, supported);
    }

    public static void glTexPageCommitmentARB(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, boolean commit) {
        long __functionAddress = ARBSparseTexture.getInstance().TexPageCommitmentARB;
        JNI.callIIIIIIIIZV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, commit);
    }

    public static void glTexturePageCommitmentEXT(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, boolean commit) {
        long __functionAddress = ARBSparseTexture.getInstance().TexturePageCommitmentEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIIIIZV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, commit);
    }
}

