/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBTransformFeedback3 {
    public static final int GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 36464;
    public static final int GL_MAX_VERTEX_STREAMS = 36465;
    public final long DrawTransformFeedbackStream;
    public final long BeginQueryIndexed;
    public final long EndQueryIndexed;
    public final long GetQueryIndexediv;

    protected ARBTransformFeedback3() {
        throw new UnsupportedOperationException();
    }

    public ARBTransformFeedback3(FunctionProvider provider) {
        this.DrawTransformFeedbackStream = provider.getFunctionAddress("glDrawTransformFeedbackStream");
        this.BeginQueryIndexed = provider.getFunctionAddress("glBeginQueryIndexed");
        this.EndQueryIndexed = provider.getFunctionAddress("glEndQueryIndexed");
        this.GetQueryIndexediv = provider.getFunctionAddress("glGetQueryIndexediv");
    }

    public static ARBTransformFeedback3 getInstance() {
        return ARBTransformFeedback3.getInstance(GL.getCapabilities());
    }

    public static ARBTransformFeedback3 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBTransformFeedback3);
    }

    static ARBTransformFeedback3 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_transform_feedback3")) {
            return null;
        }
        ARBTransformFeedback3 funcs = new ARBTransformFeedback3(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawTransformFeedbackStream, funcs.BeginQueryIndexed, funcs.EndQueryIndexed, funcs.GetQueryIndexediv);
        return GL.checkExtension("GL_ARB_transform_feedback3", funcs, supported);
    }

    public static void glDrawTransformFeedbackStream(int mode, int id, int stream) {
        long __functionAddress = ARBTransformFeedback3.getInstance().DrawTransformFeedbackStream;
        JNI.callIIIV(__functionAddress, mode, id, stream);
    }

    public static void glBeginQueryIndexed(int target, int index, int id) {
        long __functionAddress = ARBTransformFeedback3.getInstance().BeginQueryIndexed;
        JNI.callIIIV(__functionAddress, target, index, id);
    }

    public static void glEndQueryIndexed(int target, int index) {
        long __functionAddress = ARBTransformFeedback3.getInstance().EndQueryIndexed;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static void nglGetQueryIndexediv(int target, int index, int pname, long params) {
        long __functionAddress = ARBTransformFeedback3.getInstance().GetQueryIndexediv;
        JNI.callIIIPV(__functionAddress, target, index, pname, params);
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBTransformFeedback3.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBTransformFeedback3.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryIndexedi(int target, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBTransformFeedback3.nglGetQueryIndexediv(target, index, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

