/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDebugMarker {
    public final long InsertEventMarkerEXT;
    public final long PushGroupMarkerEXT;
    public final long PopGroupMarkerEXT;

    protected EXTDebugMarker() {
        throw new UnsupportedOperationException();
    }

    public EXTDebugMarker(FunctionProvider provider) {
        this.InsertEventMarkerEXT = provider.getFunctionAddress("glInsertEventMarkerEXT");
        this.PushGroupMarkerEXT = provider.getFunctionAddress("glPushGroupMarkerEXT");
        this.PopGroupMarkerEXT = provider.getFunctionAddress("glPopGroupMarkerEXT");
    }

    public static EXTDebugMarker getInstance() {
        return EXTDebugMarker.getInstance(GL.getCapabilities());
    }

    public static EXTDebugMarker getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDebugMarker);
    }

    static EXTDebugMarker create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_debug_marker")) {
            return null;
        }
        EXTDebugMarker funcs = new EXTDebugMarker(provider);
        boolean supported = Checks.checkFunctions(funcs.InsertEventMarkerEXT, funcs.PushGroupMarkerEXT, funcs.PopGroupMarkerEXT);
        return GL.checkExtension("GL_EXT_debug_marker", funcs, supported);
    }

    public static void nglInsertEventMarkerEXT(int length, long marker) {
        long __functionAddress = EXTDebugMarker.getInstance().InsertEventMarkerEXT;
        JNI.callIPV(__functionAddress, length, marker);
    }

    public static void glInsertEventMarkerEXT(int length, ByteBuffer marker) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)marker, length);
        }
        EXTDebugMarker.nglInsertEventMarkerEXT(length, MemoryUtil.memAddress(marker));
    }

    public static void glInsertEventMarkerEXT(ByteBuffer marker) {
        EXTDebugMarker.nglInsertEventMarkerEXT(marker.remaining(), MemoryUtil.memAddress(marker));
    }

    public static void glInsertEventMarkerEXT(CharSequence marker) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int markerEncoded = __buffer.stringParamUTF8(marker, false);
        int markerEncodedLen = __buffer.getOffset() - markerEncoded;
        EXTDebugMarker.nglInsertEventMarkerEXT(markerEncodedLen, __buffer.address(markerEncoded));
    }

    public static void nglPushGroupMarkerEXT(int length, long marker) {
        long __functionAddress = EXTDebugMarker.getInstance().PushGroupMarkerEXT;
        JNI.callIPV(__functionAddress, length, marker);
    }

    public static void glPushGroupMarkerEXT(int length, ByteBuffer marker) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)marker, length);
        }
        EXTDebugMarker.nglPushGroupMarkerEXT(length, MemoryUtil.memAddress(marker));
    }

    public static void glPushGroupMarkerEXT(ByteBuffer marker) {
        EXTDebugMarker.nglPushGroupMarkerEXT(marker.remaining(), MemoryUtil.memAddress(marker));
    }

    public static void glPushGroupMarkerEXT(CharSequence marker) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int markerEncoded = __buffer.stringParamUTF8(marker, false);
        int markerEncodedLen = __buffer.getOffset() - markerEncoded;
        EXTDebugMarker.nglPushGroupMarkerEXT(markerEncodedLen, __buffer.address(markerEncoded));
    }

    public static void glPopGroupMarkerEXT() {
        long __functionAddress = EXTDebugMarker.getInstance().PopGroupMarkerEXT;
        JNI.callV(__functionAddress);
    }
}

