/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTPointParameters {
    public static final int GL_POINT_SIZE_MIN_EXT = 33062;
    public static final int GL_POINT_SIZE_MAX_EXT = 33063;
    public static final int GL_POINT_FADE_THRESHOLD_SIZE_EXT = 33064;
    public static final int GL_DISTANCE_ATTENUATION_EXT = 33065;
    public final long PointParameterfEXT;
    public final long PointParameterfvEXT;

    protected EXTPointParameters() {
        throw new UnsupportedOperationException();
    }

    public EXTPointParameters(FunctionProvider provider) {
        this.PointParameterfEXT = provider.getFunctionAddress("glPointParameterfEXT");
        this.PointParameterfvEXT = provider.getFunctionAddress("glPointParameterfvEXT");
    }

    public static EXTPointParameters getInstance() {
        return EXTPointParameters.getInstance(GL.getCapabilities());
    }

    public static EXTPointParameters getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTPointParameters);
    }

    static EXTPointParameters create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_point_parameters")) {
            return null;
        }
        EXTPointParameters funcs = new EXTPointParameters(provider);
        boolean supported = Checks.checkFunctions(funcs.PointParameterfEXT, funcs.PointParameterfvEXT);
        return GL.checkExtension("GL_EXT_point_parameters", funcs, supported);
    }

    public static void glPointParameterfEXT(int pname, float param) {
        long __functionAddress = EXTPointParameters.getInstance().PointParameterfEXT;
        JNI.callIFV(__functionAddress, pname, param);
    }

    public static void nglPointParameterfvEXT(int pname, long params) {
        long __functionAddress = EXTPointParameters.getInstance().PointParameterfvEXT;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glPointParameterfvEXT(int pname, ByteBuffer params) {
        EXTPointParameters.nglPointParameterfvEXT(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameterfvEXT(int pname, FloatBuffer params) {
        EXTPointParameters.nglPointParameterfvEXT(pname, MemoryUtil.memAddress(params));
    }
}

