/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GL20 {
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_1D = 35677;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_SAMPLER_1D_SHADOW = 35681;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_VARYING_FLOATS = 35659;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_TEXTURE_COORDS = 34929;
    public static final int GL_VERTEX_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_VERTEX_PROGRAM_TWO_SIDE = 34371;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_POINT_SPRITE = 34913;
    public static final int GL_COORD_REPLACE = 34914;
    public static final int GL_POINT_SPRITE_COORD_ORIGIN = 36000;
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public final long CreateProgram;
    public final long DeleteProgram;
    public final long IsProgram;
    public final long CreateShader;
    public final long DeleteShader;
    public final long IsShader;
    public final long AttachShader;
    public final long DetachShader;
    public final long ShaderSource;
    public final long CompileShader;
    public final long LinkProgram;
    public final long UseProgram;
    public final long ValidateProgram;
    public final long Uniform1f;
    public final long Uniform2f;
    public final long Uniform3f;
    public final long Uniform4f;
    public final long Uniform1i;
    public final long Uniform2i;
    public final long Uniform3i;
    public final long Uniform4i;
    public final long Uniform1fv;
    public final long Uniform2fv;
    public final long Uniform3fv;
    public final long Uniform4fv;
    public final long Uniform1iv;
    public final long Uniform2iv;
    public final long Uniform3iv;
    public final long Uniform4iv;
    public final long UniformMatrix2fv;
    public final long UniformMatrix3fv;
    public final long UniformMatrix4fv;
    public final long GetShaderiv;
    public final long GetProgramiv;
    public final long GetShaderInfoLog;
    public final long GetProgramInfoLog;
    public final long GetAttachedShaders;
    public final long GetUniformLocation;
    public final long GetActiveUniform;
    public final long GetUniformfv;
    public final long GetUniformiv;
    public final long GetShaderSource;
    public final long VertexAttrib1f;
    public final long VertexAttrib1s;
    public final long VertexAttrib1d;
    public final long VertexAttrib2f;
    public final long VertexAttrib2s;
    public final long VertexAttrib2d;
    public final long VertexAttrib3f;
    public final long VertexAttrib3s;
    public final long VertexAttrib3d;
    public final long VertexAttrib4f;
    public final long VertexAttrib4s;
    public final long VertexAttrib4d;
    public final long VertexAttrib4Nub;
    public final long VertexAttrib1fv;
    public final long VertexAttrib1sv;
    public final long VertexAttrib1dv;
    public final long VertexAttrib2fv;
    public final long VertexAttrib2sv;
    public final long VertexAttrib2dv;
    public final long VertexAttrib3fv;
    public final long VertexAttrib3sv;
    public final long VertexAttrib3dv;
    public final long VertexAttrib4fv;
    public final long VertexAttrib4sv;
    public final long VertexAttrib4dv;
    public final long VertexAttrib4iv;
    public final long VertexAttrib4bv;
    public final long VertexAttrib4ubv;
    public final long VertexAttrib4usv;
    public final long VertexAttrib4uiv;
    public final long VertexAttrib4Nbv;
    public final long VertexAttrib4Nsv;
    public final long VertexAttrib4Niv;
    public final long VertexAttrib4Nubv;
    public final long VertexAttrib4Nusv;
    public final long VertexAttrib4Nuiv;
    public final long VertexAttribPointer;
    public final long EnableVertexAttribArray;
    public final long DisableVertexAttribArray;
    public final long BindAttribLocation;
    public final long GetActiveAttrib;
    public final long GetAttribLocation;
    public final long GetVertexAttribiv;
    public final long GetVertexAttribfv;
    public final long GetVertexAttribdv;
    public final long GetVertexAttribPointerv;
    public final long DrawBuffers;
    public final long BlendEquationSeparate;
    public final long StencilOpSeparate;
    public final long StencilFuncSeparate;
    public final long StencilMaskSeparate;

    protected GL20() {
        throw new UnsupportedOperationException();
    }

    public GL20(FunctionProvider provider) {
        this.CreateProgram = provider.getFunctionAddress("glCreateProgram");
        this.DeleteProgram = provider.getFunctionAddress("glDeleteProgram");
        this.IsProgram = provider.getFunctionAddress("glIsProgram");
        this.CreateShader = provider.getFunctionAddress("glCreateShader");
        this.DeleteShader = provider.getFunctionAddress("glDeleteShader");
        this.IsShader = provider.getFunctionAddress("glIsShader");
        this.AttachShader = provider.getFunctionAddress("glAttachShader");
        this.DetachShader = provider.getFunctionAddress("glDetachShader");
        this.ShaderSource = provider.getFunctionAddress("glShaderSource");
        this.CompileShader = provider.getFunctionAddress("glCompileShader");
        this.LinkProgram = provider.getFunctionAddress("glLinkProgram");
        this.UseProgram = provider.getFunctionAddress("glUseProgram");
        this.ValidateProgram = provider.getFunctionAddress("glValidateProgram");
        this.Uniform1f = provider.getFunctionAddress("glUniform1f");
        this.Uniform2f = provider.getFunctionAddress("glUniform2f");
        this.Uniform3f = provider.getFunctionAddress("glUniform3f");
        this.Uniform4f = provider.getFunctionAddress("glUniform4f");
        this.Uniform1i = provider.getFunctionAddress("glUniform1i");
        this.Uniform2i = provider.getFunctionAddress("glUniform2i");
        this.Uniform3i = provider.getFunctionAddress("glUniform3i");
        this.Uniform4i = provider.getFunctionAddress("glUniform4i");
        this.Uniform1fv = provider.getFunctionAddress("glUniform1fv");
        this.Uniform2fv = provider.getFunctionAddress("glUniform2fv");
        this.Uniform3fv = provider.getFunctionAddress("glUniform3fv");
        this.Uniform4fv = provider.getFunctionAddress("glUniform4fv");
        this.Uniform1iv = provider.getFunctionAddress("glUniform1iv");
        this.Uniform2iv = provider.getFunctionAddress("glUniform2iv");
        this.Uniform3iv = provider.getFunctionAddress("glUniform3iv");
        this.Uniform4iv = provider.getFunctionAddress("glUniform4iv");
        this.UniformMatrix2fv = provider.getFunctionAddress("glUniformMatrix2fv");
        this.UniformMatrix3fv = provider.getFunctionAddress("glUniformMatrix3fv");
        this.UniformMatrix4fv = provider.getFunctionAddress("glUniformMatrix4fv");
        this.GetShaderiv = provider.getFunctionAddress("glGetShaderiv");
        this.GetProgramiv = provider.getFunctionAddress("glGetProgramiv");
        this.GetShaderInfoLog = provider.getFunctionAddress("glGetShaderInfoLog");
        this.GetProgramInfoLog = provider.getFunctionAddress("glGetProgramInfoLog");
        this.GetAttachedShaders = provider.getFunctionAddress("glGetAttachedShaders");
        this.GetUniformLocation = provider.getFunctionAddress("glGetUniformLocation");
        this.GetActiveUniform = provider.getFunctionAddress("glGetActiveUniform");
        this.GetUniformfv = provider.getFunctionAddress("glGetUniformfv");
        this.GetUniformiv = provider.getFunctionAddress("glGetUniformiv");
        this.GetShaderSource = provider.getFunctionAddress("glGetShaderSource");
        this.VertexAttrib1f = provider.getFunctionAddress("glVertexAttrib1f");
        this.VertexAttrib1s = provider.getFunctionAddress("glVertexAttrib1s");
        this.VertexAttrib1d = provider.getFunctionAddress("glVertexAttrib1d");
        this.VertexAttrib2f = provider.getFunctionAddress("glVertexAttrib2f");
        this.VertexAttrib2s = provider.getFunctionAddress("glVertexAttrib2s");
        this.VertexAttrib2d = provider.getFunctionAddress("glVertexAttrib2d");
        this.VertexAttrib3f = provider.getFunctionAddress("glVertexAttrib3f");
        this.VertexAttrib3s = provider.getFunctionAddress("glVertexAttrib3s");
        this.VertexAttrib3d = provider.getFunctionAddress("glVertexAttrib3d");
        this.VertexAttrib4f = provider.getFunctionAddress("glVertexAttrib4f");
        this.VertexAttrib4s = provider.getFunctionAddress("glVertexAttrib4s");
        this.VertexAttrib4d = provider.getFunctionAddress("glVertexAttrib4d");
        this.VertexAttrib4Nub = provider.getFunctionAddress("glVertexAttrib4Nub");
        this.VertexAttrib1fv = provider.getFunctionAddress("glVertexAttrib1fv");
        this.VertexAttrib1sv = provider.getFunctionAddress("glVertexAttrib1sv");
        this.VertexAttrib1dv = provider.getFunctionAddress("glVertexAttrib1dv");
        this.VertexAttrib2fv = provider.getFunctionAddress("glVertexAttrib2fv");
        this.VertexAttrib2sv = provider.getFunctionAddress("glVertexAttrib2sv");
        this.VertexAttrib2dv = provider.getFunctionAddress("glVertexAttrib2dv");
        this.VertexAttrib3fv = provider.getFunctionAddress("glVertexAttrib3fv");
        this.VertexAttrib3sv = provider.getFunctionAddress("glVertexAttrib3sv");
        this.VertexAttrib3dv = provider.getFunctionAddress("glVertexAttrib3dv");
        this.VertexAttrib4fv = provider.getFunctionAddress("glVertexAttrib4fv");
        this.VertexAttrib4sv = provider.getFunctionAddress("glVertexAttrib4sv");
        this.VertexAttrib4dv = provider.getFunctionAddress("glVertexAttrib4dv");
        this.VertexAttrib4iv = provider.getFunctionAddress("glVertexAttrib4iv");
        this.VertexAttrib4bv = provider.getFunctionAddress("glVertexAttrib4bv");
        this.VertexAttrib4ubv = provider.getFunctionAddress("glVertexAttrib4ubv");
        this.VertexAttrib4usv = provider.getFunctionAddress("glVertexAttrib4usv");
        this.VertexAttrib4uiv = provider.getFunctionAddress("glVertexAttrib4uiv");
        this.VertexAttrib4Nbv = provider.getFunctionAddress("glVertexAttrib4Nbv");
        this.VertexAttrib4Nsv = provider.getFunctionAddress("glVertexAttrib4Nsv");
        this.VertexAttrib4Niv = provider.getFunctionAddress("glVertexAttrib4Niv");
        this.VertexAttrib4Nubv = provider.getFunctionAddress("glVertexAttrib4Nubv");
        this.VertexAttrib4Nusv = provider.getFunctionAddress("glVertexAttrib4Nusv");
        this.VertexAttrib4Nuiv = provider.getFunctionAddress("glVertexAttrib4Nuiv");
        this.VertexAttribPointer = provider.getFunctionAddress("glVertexAttribPointer");
        this.EnableVertexAttribArray = provider.getFunctionAddress("glEnableVertexAttribArray");
        this.DisableVertexAttribArray = provider.getFunctionAddress("glDisableVertexAttribArray");
        this.BindAttribLocation = provider.getFunctionAddress("glBindAttribLocation");
        this.GetActiveAttrib = provider.getFunctionAddress("glGetActiveAttrib");
        this.GetAttribLocation = provider.getFunctionAddress("glGetAttribLocation");
        this.GetVertexAttribiv = provider.getFunctionAddress("glGetVertexAttribiv");
        this.GetVertexAttribfv = provider.getFunctionAddress("glGetVertexAttribfv");
        this.GetVertexAttribdv = provider.getFunctionAddress("glGetVertexAttribdv");
        this.GetVertexAttribPointerv = provider.getFunctionAddress("glGetVertexAttribPointerv");
        this.DrawBuffers = provider.getFunctionAddress("glDrawBuffers");
        this.BlendEquationSeparate = provider.getFunctionAddress("glBlendEquationSeparate");
        this.StencilOpSeparate = provider.getFunctionAddress("glStencilOpSeparate");
        this.StencilFuncSeparate = provider.getFunctionAddress("glStencilFuncSeparate");
        this.StencilMaskSeparate = provider.getFunctionAddress("glStencilMaskSeparate");
    }

    public static GL20 getInstance() {
        return GL20.getInstance(GL.getCapabilities());
    }

    public static GL20 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL20);
    }

    static GL20 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL20")) {
            return null;
        }
        GL20 funcs = new GL20(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateProgram, funcs.DeleteProgram, funcs.IsProgram, funcs.CreateShader, funcs.DeleteShader, funcs.IsShader, funcs.AttachShader, funcs.DetachShader, funcs.ShaderSource, funcs.CompileShader, funcs.LinkProgram, funcs.UseProgram, funcs.ValidateProgram, funcs.Uniform1f, funcs.Uniform2f, funcs.Uniform3f, funcs.Uniform4f, funcs.Uniform1i, funcs.Uniform2i, funcs.Uniform3i, funcs.Uniform4i, funcs.Uniform1fv, funcs.Uniform2fv, funcs.Uniform3fv, funcs.Uniform4fv, funcs.Uniform1iv, funcs.Uniform2iv, funcs.Uniform3iv, funcs.Uniform4iv, funcs.UniformMatrix2fv, funcs.UniformMatrix3fv, funcs.UniformMatrix4fv, funcs.GetShaderiv, funcs.GetProgramiv, funcs.GetShaderInfoLog, funcs.GetProgramInfoLog, funcs.GetAttachedShaders, funcs.GetUniformLocation, funcs.GetActiveUniform, funcs.GetUniformfv, funcs.GetUniformiv, funcs.GetShaderSource, funcs.VertexAttrib1f, funcs.VertexAttrib1s, funcs.VertexAttrib1d, funcs.VertexAttrib2f, funcs.VertexAttrib2s, funcs.VertexAttrib2d, funcs.VertexAttrib3f, funcs.VertexAttrib3s, funcs.VertexAttrib3d, funcs.VertexAttrib4f, funcs.VertexAttrib4s, funcs.VertexAttrib4d, funcs.VertexAttrib4Nub, funcs.VertexAttrib1fv, funcs.VertexAttrib1sv, funcs.VertexAttrib1dv, funcs.VertexAttrib2fv, funcs.VertexAttrib2sv, funcs.VertexAttrib2dv, funcs.VertexAttrib3fv, funcs.VertexAttrib3sv, funcs.VertexAttrib3dv, funcs.VertexAttrib4fv, funcs.VertexAttrib4sv, funcs.VertexAttrib4dv, funcs.VertexAttrib4iv, funcs.VertexAttrib4bv, funcs.VertexAttrib4ubv, funcs.VertexAttrib4usv, funcs.VertexAttrib4uiv, funcs.VertexAttrib4Nbv, funcs.VertexAttrib4Nsv, funcs.VertexAttrib4Niv, funcs.VertexAttrib4Nubv, funcs.VertexAttrib4Nusv, funcs.VertexAttrib4Nuiv, funcs.VertexAttribPointer, funcs.EnableVertexAttribArray, funcs.DisableVertexAttribArray, funcs.BindAttribLocation, funcs.GetActiveAttrib, funcs.GetAttribLocation, funcs.GetVertexAttribiv, funcs.GetVertexAttribfv, funcs.GetVertexAttribdv, funcs.GetVertexAttribPointerv, funcs.DrawBuffers, funcs.BlendEquationSeparate, funcs.StencilOpSeparate, funcs.StencilFuncSeparate, funcs.StencilMaskSeparate);
        return GL.checkExtension("OpenGL20", funcs, supported);
    }

    public static int glCreateProgram() {
        long __functionAddress = GL20.getInstance().CreateProgram;
        return JNI.callI(__functionAddress);
    }

    public static void glDeleteProgram(int program) {
        long __functionAddress = GL20.getInstance().DeleteProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static boolean glIsProgram(int program) {
        long __functionAddress = GL20.getInstance().IsProgram;
        return JNI.callIZ(__functionAddress, program);
    }

    public static int glCreateShader(int type) {
        long __functionAddress = GL20.getInstance().CreateShader;
        return JNI.callII(__functionAddress, type);
    }

    public static void glDeleteShader(int shader) {
        long __functionAddress = GL20.getInstance().DeleteShader;
        JNI.callIV(__functionAddress, shader);
    }

    public static boolean glIsShader(int shader) {
        long __functionAddress = GL20.getInstance().IsShader;
        return JNI.callIZ(__functionAddress, shader);
    }

    public static void glAttachShader(int program, int shader) {
        long __functionAddress = GL20.getInstance().AttachShader;
        JNI.callIIV(__functionAddress, program, shader);
    }

    public static void glDetachShader(int program, int shader) {
        long __functionAddress = GL20.getInstance().DetachShader;
        JNI.callIIV(__functionAddress, program, shader);
    }

    public static void nglShaderSource(int shader, int count, long strings, long length) {
        long __functionAddress = GL20.getInstance().ShaderSource;
        JNI.callIIPPV(__functionAddress, shader, count, strings, length);
    }

    public static void glShaderSource(int shader, int count, ByteBuffer strings, ByteBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, count << 2);
            }
        }
        GL20.nglShaderSource(shader, count, MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(length));
    }

    public static void glShaderSource(int shader, PointerBuffer strings, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, strings.remaining());
        }
        GL20.nglShaderSource(shader, strings.remaining(), MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence ... strings) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8i(strings);
        try {
            GL20.nglShaderSource(shader, strings.length, __buffer.address(stringsAddress), __buffer.address(stringsAddress + (strings.length << Pointer.POINTER_SHIFT)));
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, strings.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8i(string);
        try {
            GL20.nglShaderSource(shader, 1, __buffer.address(stringsAddress), __buffer.address(stringsAddress + Pointer.POINTER_SIZE));
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, 1);
        }
    }

    public static void glCompileShader(int shader) {
        long __functionAddress = GL20.getInstance().CompileShader;
        JNI.callIV(__functionAddress, shader);
    }

    public static void glLinkProgram(int program) {
        long __functionAddress = GL20.getInstance().LinkProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static void glUseProgram(int program) {
        long __functionAddress = GL20.getInstance().UseProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static void glValidateProgram(int program) {
        long __functionAddress = GL20.getInstance().ValidateProgram;
        JNI.callIV(__functionAddress, program);
    }

    public static void glUniform1f(int location, float v0) {
        long __functionAddress = GL20.getInstance().Uniform1f;
        JNI.callIFV(__functionAddress, location, v0);
    }

    public static void glUniform2f(int location, float v0, float v1) {
        long __functionAddress = GL20.getInstance().Uniform2f;
        JNI.callIFFV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        long __functionAddress = GL20.getInstance().Uniform3f;
        JNI.callIFFFV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL20.getInstance().Uniform4f;
        JNI.callIFFFFV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void glUniform1i(int location, int v0) {
        long __functionAddress = GL20.getInstance().Uniform1i;
        JNI.callIIV(__functionAddress, location, v0);
    }

    public static void glUniform2i(int location, int v0, int v1) {
        long __functionAddress = GL20.getInstance().Uniform2i;
        JNI.callIIIV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3i(int location, int v0, int v1, int v2) {
        long __functionAddress = GL20.getInstance().Uniform3i;
        JNI.callIIIIV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4i(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GL20.getInstance().Uniform4i;
        JNI.callIIIIIV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform1fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform1fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL20.nglUniform1fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1fv(int location, FloatBuffer value) {
        GL20.nglUniform1fv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform2fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL20.nglUniform2fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2fv(int location, FloatBuffer value) {
        GL20.nglUniform2fv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform3fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GL20.nglUniform3fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3fv(int location, FloatBuffer value) {
        GL20.nglUniform3fv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform4fv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4fv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL20.nglUniform4fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4fv(int location, FloatBuffer value) {
        GL20.nglUniform4fv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniform1iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform1iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL20.nglUniform1iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1iv(int location, IntBuffer value) {
        GL20.nglUniform1iv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform2iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL20.nglUniform2iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2iv(int location, IntBuffer value) {
        GL20.nglUniform2iv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform3iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GL20.nglUniform3iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3iv(int location, IntBuffer value) {
        GL20.nglUniform3iv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform4iv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4iv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL20.nglUniform4iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4iv(int location, IntBuffer value) {
        GL20.nglUniform4iv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL20.getInstance().UniformMatrix2fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL20.nglUniformMatrix2fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2fv(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix2fv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL20.getInstance().UniformMatrix3fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL20.nglUniformMatrix3fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3fv(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix3fv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL20.getInstance().UniformMatrix4fv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        GL20.nglUniformMatrix4fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4fv(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix4fv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglGetShaderiv(int shader, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetShaderiv;
        JNI.callIIPV(__functionAddress, shader, pname, params);
    }

    public static void glGetShaderiv(int shader, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetShaderi(int shader, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetShaderiv(shader, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetProgramiv(int program, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetProgramiv;
        JNI.callIIPV(__functionAddress, program, pname, params);
    }

    public static void glGetProgramiv(int program, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgrami(int program, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetProgramiv(program, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetShaderInfoLog(int shader, int maxLength, long length, long infoLog) {
        long __functionAddress = GL20.getInstance().GetShaderInfoLog;
        JNI.callIIPPV(__functionAddress, shader, maxLength, length, infoLog);
    }

    public static void glGetShaderInfoLog(int shader, int maxLength, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL20.nglGetShaderInfoLog(shader, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetShaderInfoLog(int shader, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderInfoLog(shader, maxLength, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetShaderInfoLog(int shader) {
        int maxLength = GL20.glGetShaderi(shader, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderInfoLog(shader, maxLength, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void nglGetProgramInfoLog(int program, int maxLength, long length, long infoLog) {
        long __functionAddress = GL20.getInstance().GetProgramInfoLog;
        JNI.callIIPPV(__functionAddress, program, maxLength, length, infoLog);
    }

    public static void glGetProgramInfoLog(int program, int maxLength, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL20.nglGetProgramInfoLog(program, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramInfoLog(int program, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetProgramInfoLog(program, maxLength, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetProgramInfoLog(int program) {
        int maxLength = GL20.glGetProgrami(program, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetProgramInfoLog(program, maxLength, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void nglGetAttachedShaders(int program, int maxCount, long count, long shaders) {
        long __functionAddress = GL20.getInstance().GetAttachedShaders;
        JNI.callIIPPV(__functionAddress, program, maxCount, count, shaders);
    }

    public static void glGetAttachedShaders(int program, int maxCount, ByteBuffer count, ByteBuffer shaders) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, maxCount << 2);
            if (count != null) {
                Checks.checkBuffer((Buffer)count, 4);
            }
        }
        GL20.nglGetAttachedShaders(program, maxCount, MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (Checks.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        GL20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static IntBuffer glGetAttachedShaders(int program, int maxCount) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        IntBuffer shaders = BufferUtils.createIntBuffer(maxCount);
        GL20.nglGetAttachedShaders(program, maxCount, __buffer.address(count), MemoryUtil.memAddress(shaders));
        shaders.limit(__buffer.intValue(count));
        return shaders.slice();
    }

    public static IntBuffer glGetAttachedShaders(int program) {
        int maxCount = GL20.glGetProgrami(program, 35717);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        IntBuffer shaders = BufferUtils.createIntBuffer(maxCount);
        GL20.nglGetAttachedShaders(program, maxCount, __buffer.address(count), MemoryUtil.memAddress(shaders));
        shaders.limit(__buffer.intValue(count));
        return shaders.slice();
    }

    public static int nglGetUniformLocation(int program, long name) {
        long __functionAddress = GL20.getInstance().GetUniformLocation;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL20.nglGetUniformLocation(program, MemoryUtil.memAddress(name));
    }

    public static int glGetUniformLocation(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GL20.nglGetUniformLocation(program, __buffer.address(nameEncoded));
    }

    public static void nglGetActiveUniform(int program, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = GL20.getInstance().GetActiveUniform;
        JNI.callIIIPPPPV(__functionAddress, program, index, maxLength, length, size, type, name);
    }

    public static void glGetActiveUniform(int program, int index, int maxLength, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        GL20.nglGetActiveUniform(program, index, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GL20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveUniform(int program, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveUniform(program, index, maxLength, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        int maxLength = GL20.glGetProgrami(program, 35719);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveUniform(program, index, maxLength, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetUniformfv(int program, int location, long params) {
        long __functionAddress = GL20.getInstance().GetUniformfv;
        JNI.callIIPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformfv(int program, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformfv(int program, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    public static float glGetUniformf(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL20.nglGetUniformfv(program, location, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetUniformiv(int program, int location, long params) {
        long __functionAddress = GL20.getInstance().GetUniformiv;
        JNI.callIIPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformiv(int program, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformiv(int program, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformi(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetUniformiv(program, location, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetShaderSource(int shader, int maxLength, long length, long source) {
        long __functionAddress = GL20.getInstance().GetShaderSource;
        JNI.callIIPPV(__functionAddress, shader, maxLength, length, source);
    }

    public static void glGetShaderSource(int shader, int maxLength, ByteBuffer length, ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)source, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL20.nglGetShaderSource(shader, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static String glGetShaderSource(int shader, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderSource(shader, maxLength, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }

    public static String glGetShaderSource(int shader) {
        int maxLength = GL20.glGetShaderi(shader, 35720);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderSource(shader, maxLength, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }

    public static void glVertexAttrib1f(int index, float v0) {
        long __functionAddress = GL20.getInstance().VertexAttrib1f;
        JNI.callIFV(__functionAddress, index, v0);
    }

    public static void glVertexAttrib1s(int index, short v0) {
        long __functionAddress = GL20.getInstance().VertexAttrib1s;
        JNI.callISV(__functionAddress, index, v0);
    }

    public static void glVertexAttrib1d(int index, double v0) {
        long __functionAddress = GL20.getInstance().VertexAttrib1d;
        JNI.callIDV(__functionAddress, index, v0);
    }

    public static void glVertexAttrib2f(int index, float v0, float v1) {
        long __functionAddress = GL20.getInstance().VertexAttrib2f;
        JNI.callIFFV(__functionAddress, index, v0, v1);
    }

    public static void glVertexAttrib2s(int index, short v0, short v1) {
        long __functionAddress = GL20.getInstance().VertexAttrib2s;
        JNI.callISSV(__functionAddress, index, v0, v1);
    }

    public static void glVertexAttrib2d(int index, double v0, double v1) {
        long __functionAddress = GL20.getInstance().VertexAttrib2d;
        JNI.callIDDV(__functionAddress, index, v0, v1);
    }

    public static void glVertexAttrib3f(int index, float v0, float v1, float v2) {
        long __functionAddress = GL20.getInstance().VertexAttrib3f;
        JNI.callIFFFV(__functionAddress, index, v0, v1, v2);
    }

    public static void glVertexAttrib3s(int index, short v0, short v1, short v2) {
        long __functionAddress = GL20.getInstance().VertexAttrib3s;
        JNI.callISSSV(__functionAddress, index, v0, v1, v2);
    }

    public static void glVertexAttrib3d(int index, double v0, double v1, double v2) {
        long __functionAddress = GL20.getInstance().VertexAttrib3d;
        JNI.callIDDDV(__functionAddress, index, v0, v1, v2);
    }

    public static void glVertexAttrib4f(int index, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL20.getInstance().VertexAttrib4f;
        JNI.callIFFFFV(__functionAddress, index, v0, v1, v2, v3);
    }

    public static void glVertexAttrib4s(int index, short v0, short v1, short v2, short v3) {
        long __functionAddress = GL20.getInstance().VertexAttrib4s;
        JNI.callISSSSV(__functionAddress, index, v0, v1, v2, v3);
    }

    public static void glVertexAttrib4d(int index, double v0, double v1, double v2, double v3) {
        long __functionAddress = GL20.getInstance().VertexAttrib4d;
        JNI.callIDDDDV(__functionAddress, index, v0, v1, v2, v3);
    }

    public static void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nub;
        JNI.callIBBBBV(__functionAddress, index, x, y, z, w);
    }

    public static void nglVertexAttrib1fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib1fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib1fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib1sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib1sv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1sv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib1sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib1sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib1dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib1dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib1dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib1dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib2fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib2fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib2sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib2sv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2sv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib2sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib2dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib2dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib2dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib3fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib3fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 12);
        }
        GL20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib3sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib3sv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3sv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 6);
        }
        GL20.nglVertexAttrib3sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib3dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib3dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 24);
        }
        GL20.nglVertexAttrib3dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4fv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4fv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4sv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4sv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4sv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4sv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 32);
        }
        GL20.nglVertexAttrib4dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4iv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4iv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4iv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4iv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4iv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4iv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4bv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4bv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4bv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4bv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4ubv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4ubv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4ubv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4ubv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4usv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4usv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4usv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4usv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4usv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4usv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4uiv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4uiv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4uiv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4uiv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4uiv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4uiv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nbv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nbv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nbv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nbv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nsv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nsv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nsv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4Nsv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4Nsv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nsv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Niv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Niv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Niv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4Niv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4Niv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Niv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nubv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nubv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nubv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nubv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nusv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nusv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nusv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4Nusv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4Nusv(int index, ShortBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nusv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttrib4Nuiv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nuiv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4Nuiv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4Nuiv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4Nuiv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nuiv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        long __functionAddress = GL20.getInstance().VertexAttribPointer;
        JNI.callIIIZIPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, pointerOffset);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, IntBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, FloatBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glEnableVertexAttribArray(int index) {
        long __functionAddress = GL20.getInstance().EnableVertexAttribArray;
        JNI.callIV(__functionAddress, index);
    }

    public static void glDisableVertexAttribArray(int index) {
        long __functionAddress = GL20.getInstance().DisableVertexAttribArray;
        JNI.callIV(__functionAddress, index);
    }

    public static void nglBindAttribLocation(int program, int index, long name) {
        long __functionAddress = GL20.getInstance().BindAttribLocation;
        JNI.callIIPV(__functionAddress, program, index, name);
    }

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        GL20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(name));
    }

    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        GL20.nglBindAttribLocation(program, index, __buffer.address(nameEncoded));
    }

    public static void nglGetActiveAttrib(int program, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = GL20.getInstance().GetActiveAttrib;
        JNI.callIIIPPPPV(__functionAddress, program, index, maxLength, length, size, type, name);
    }

    public static void glGetActiveAttrib(int program, int index, int maxLength, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        GL20.nglGetActiveAttrib(program, index, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GL20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveAttrib(int program, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveAttrib(program, index, maxLength, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        int maxLength = GL20.glGetProgrami(program, 35722);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveAttrib(program, index, maxLength, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static int nglGetAttribLocation(int program, long name) {
        long __functionAddress = GL20.getInstance().GetAttribLocation;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL20.nglGetAttribLocation(program, MemoryUtil.memAddress(name));
    }

    public static int glGetAttribLocation(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GL20.nglGetAttribLocation(program, __buffer.address(nameEncoded));
    }

    public static void nglGetVertexAttribiv(int index, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetVertexAttribiv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribiv(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetVertexAttribi(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetVertexAttribiv(index, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetVertexAttribfv(int index, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetVertexAttribfv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribfv(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GL20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribdv(int index, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetVertexAttribdv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribdv(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 32);
        }
        GL20.nglGetVertexAttribdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribdv(int index, int pname, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribPointerv(int index, int pname, long pointer) {
        long __functionAddress = GL20.getInstance().GetVertexAttribPointerv;
        JNI.callIIPV(__functionAddress, index, pname, pointer);
    }

    public static void glGetVertexAttribPointerv(int index, int pname, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pointer, 1 << Pointer.POINTER_SHIFT);
        }
        GL20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    public static void glGetVertexAttribPointerv(int index, int pname, PointerBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pointer, 1);
        }
        GL20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    public static long glGetVertexAttribPointer(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pointer = __buffer.pointerParam();
        GL20.nglGetVertexAttribPointerv(index, pname, __buffer.address(pointer));
        return __buffer.pointerValue(pointer);
    }

    public static void nglDrawBuffers(int n, long bufs) {
        long __functionAddress = GL20.getInstance().DrawBuffers;
        JNI.callIPV(__functionAddress, n, bufs);
    }

    public static void glDrawBuffers(int n, ByteBuffer bufs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)bufs, n << 2);
        }
        GL20.nglDrawBuffers(n, MemoryUtil.memAddress(bufs));
    }

    public static void glDrawBuffers(IntBuffer bufs) {
        GL20.nglDrawBuffers(bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    public static void glDrawBuffers(int buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufs = __buffer.intParam(buf);
        GL20.nglDrawBuffers(1, __buffer.address(bufs));
    }

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        long __functionAddress = GL20.getInstance().BlendEquationSeparate;
        JNI.callIIV(__functionAddress, modeRGB, modeAlpha);
    }

    public static void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        long __functionAddress = GL20.getInstance().StencilOpSeparate;
        JNI.callIIIIV(__functionAddress, face, sfail, dpfail, dppass);
    }

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        long __functionAddress = GL20.getInstance().StencilFuncSeparate;
        JNI.callIIIIV(__functionAddress, face, func, ref, mask);
    }

    public static void glStencilMaskSeparate(int face, int mask) {
        long __functionAddress = GL20.getInstance().StencilMaskSeparate;
        JNI.callIIV(__functionAddress, face, mask);
    }
}

