/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GL31 {
    public static final int GL_R8_SNORM = 36756;
    public static final int GL_RG8_SNORM = 36757;
    public static final int GL_RGB8_SNORM = 36758;
    public static final int GL_RGBA8_SNORM = 36759;
    public static final int GL_R16_SNORM = 36760;
    public static final int GL_RG16_SNORM = 36761;
    public static final int GL_RGB16_SNORM = 36762;
    public static final int GL_RGBA16_SNORM = 36763;
    public static final int GL_SIGNED_NORMALIZED = 36764;
    public static final int GL_SAMPLER_BUFFER = 36290;
    public static final int GL_INT_SAMPLER_2D_RECT = 36301;
    public static final int GL_INT_SAMPLER_BUFFER = 36304;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_RECT = 36309;
    public static final int GL_UNSIGNED_INT_SAMPLER_BUFFER = 36312;
    public static final int GL_COPY_READ_BUFFER = 36662;
    public static final int GL_COPY_WRITE_BUFFER = 36663;
    public static final int GL_PRIMITIVE_RESTART = 36765;
    public static final int GL_PRIMITIVE_RESTART_INDEX = 36766;
    public static final int GL_TEXTURE_BUFFER = 35882;
    public static final int GL_MAX_TEXTURE_BUFFER_SIZE = 35883;
    public static final int GL_TEXTURE_BINDING_BUFFER = 35884;
    public static final int GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 35885;
    public static final int GL_TEXTURE_RECTANGLE = 34037;
    public static final int GL_TEXTURE_BINDING_RECTANGLE = 34038;
    public static final int GL_PROXY_TEXTURE_RECTANGLE = 34039;
    public static final int GL_MAX_RECTANGLE_TEXTURE_SIZE = 34040;
    public static final int GL_SAMPLER_2D_RECT = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW = 35684;
    public static final int GL_UNIFORM_BUFFER = 35345;
    public static final int GL_UNIFORM_BUFFER_BINDING = 35368;
    public static final int GL_UNIFORM_BUFFER_START = 35369;
    public static final int GL_UNIFORM_BUFFER_SIZE = 35370;
    public static final int GL_MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public static final int GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 35372;
    public static final int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public static final int GL_MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public static final int GL_MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public static final int GL_MAX_UNIFORM_BLOCK_SIZE = 35376;
    public static final int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public static final int GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 35378;
    public static final int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public static final int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public static final int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 35381;
    public static final int GL_ACTIVE_UNIFORM_BLOCKS = 35382;
    public static final int GL_UNIFORM_TYPE = 35383;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_UNIFORM_BLOCK_INDEX = 35386;
    public static final int GL_UNIFORM_OFFSET = 35387;
    public static final int GL_UNIFORM_ARRAY_STRIDE = 35388;
    public static final int GL_UNIFORM_MATRIX_STRIDE = 35389;
    public static final int GL_UNIFORM_IS_ROW_MAJOR = 35390;
    public static final int GL_UNIFORM_BLOCK_BINDING = 35391;
    public static final int GL_UNIFORM_BLOCK_DATA_SIZE = 35392;
    public static final int GL_UNIFORM_BLOCK_NAME_LENGTH = 35393;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 35397;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public static final int GL_INVALID_INDEX = -1;
    public final long DrawArraysInstanced;
    public final long DrawElementsInstanced;
    public final long CopyBufferSubData;
    public final long PrimitiveRestartIndex;
    public final long TexBuffer;
    public final long GetUniformIndices;
    public final long GetActiveUniformsiv;
    public final long GetActiveUniformName;
    public final long GetUniformBlockIndex;
    public final long GetActiveUniformBlockiv;
    public final long GetActiveUniformBlockName;
    public final long UniformBlockBinding;

    protected GL31() {
        throw new UnsupportedOperationException();
    }

    public GL31(FunctionProvider provider) {
        this.DrawArraysInstanced = provider.getFunctionAddress("glDrawArraysInstanced");
        this.DrawElementsInstanced = provider.getFunctionAddress("glDrawElementsInstanced");
        this.CopyBufferSubData = provider.getFunctionAddress("glCopyBufferSubData");
        this.PrimitiveRestartIndex = provider.getFunctionAddress("glPrimitiveRestartIndex");
        this.TexBuffer = provider.getFunctionAddress("glTexBuffer");
        this.GetUniformIndices = provider.getFunctionAddress("glGetUniformIndices");
        this.GetActiveUniformsiv = provider.getFunctionAddress("glGetActiveUniformsiv");
        this.GetActiveUniformName = provider.getFunctionAddress("glGetActiveUniformName");
        this.GetUniformBlockIndex = provider.getFunctionAddress("glGetUniformBlockIndex");
        this.GetActiveUniformBlockiv = provider.getFunctionAddress("glGetActiveUniformBlockiv");
        this.GetActiveUniformBlockName = provider.getFunctionAddress("glGetActiveUniformBlockName");
        this.UniformBlockBinding = provider.getFunctionAddress("glUniformBlockBinding");
    }

    public static GL31 getInstance() {
        return GL31.getInstance(GL.getCapabilities());
    }

    public static GL31 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL31);
    }

    static GL31 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL31")) {
            return null;
        }
        GL31 funcs = new GL31(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstanced, funcs.DrawElementsInstanced, funcs.CopyBufferSubData, funcs.PrimitiveRestartIndex, funcs.TexBuffer, funcs.GetUniformIndices, funcs.GetActiveUniformsiv, funcs.GetActiveUniformName, funcs.GetUniformBlockIndex, funcs.GetActiveUniformBlockiv, funcs.GetActiveUniformBlockName, funcs.UniformBlockBinding);
        return GL.checkExtension("OpenGL31", funcs, supported);
    }

    public static void glDrawArraysInstanced(int mode, int first, int count, int primcount) {
        long __functionAddress = GL31.getInstance().DrawArraysInstanced;
        JNI.callIIIIV(__functionAddress, mode, first, count, primcount);
    }

    public static void nglDrawElementsInstanced(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = GL31.getInstance().DrawElementsInstanced;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstanced(int mode, int count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLChecks.typeToByteShift(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        GL31.nglDrawElementsInstanced(mode, count, type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, int count, int type, long indicesOffset, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL31.nglDrawElementsInstanced(mode, count, type, indicesOffset, primcount);
    }

    public static void glDrawElementsInstanced(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL31.nglDrawElementsInstanced(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL31.nglDrawElementsInstanced(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL31.nglDrawElementsInstanced(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL31.nglDrawElementsInstanced(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        long __functionAddress = GL31.getInstance().CopyBufferSubData;
        JNI.callIIPPPV(__functionAddress, readTarget, writeTarget, readOffset, writeOffset, size);
    }

    public static void glPrimitiveRestartIndex(int index) {
        long __functionAddress = GL31.getInstance().PrimitiveRestartIndex;
        JNI.callIV(__functionAddress, index);
    }

    public static void glTexBuffer(int target, int internalformat, int buffer) {
        long __functionAddress = GL31.getInstance().TexBuffer;
        JNI.callIIIV(__functionAddress, target, internalformat, buffer);
    }

    public static void nglGetUniformIndices(int program, int uniformCount, long uniformNames, long uniformIndices) {
        long __functionAddress = GL31.getInstance().GetUniformIndices;
        JNI.callIIPPV(__functionAddress, program, uniformCount, uniformNames, uniformIndices);
    }

    public static void glGetUniformIndices(int program, int uniformCount, ByteBuffer uniformNames, ByteBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformNames, uniformCount << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)uniformIndices, uniformCount << 2);
        }
        GL31.nglGetUniformIndices(program, uniformCount, MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    public static void glGetUniformIndices(int program, PointerBuffer uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformNames.remaining());
        }
        GL31.nglGetUniformIndices(program, uniformNames.remaining(), MemoryUtil.memAddress(uniformNames), MemoryUtil.memAddress(uniformIndices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetUniformIndices(int program, CharSequence[] uniformNames, IntBuffer uniformIndices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformNames.length);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int uniformNamesAddress = __buffer.pointerArrayParamASCII(uniformNames);
        try {
            GL31.nglGetUniformIndices(program, uniformNames.length, __buffer.address(uniformNamesAddress), MemoryUtil.memAddress(uniformIndices));
        }
        finally {
            __buffer.pointerArrayFree(uniformNamesAddress, uniformNames.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformIndices(int program, CharSequence uniformName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int uniformNamesAddress = __buffer.pointerArrayParamASCII(uniformName);
        int uniformIndices = __buffer.intParam();
        try {
            GL31.nglGetUniformIndices(program, 1, __buffer.address(uniformNamesAddress), __buffer.address(uniformIndices));
        }
        finally {
            __buffer.pointerArrayFree(uniformNamesAddress, 1);
        }
        return __buffer.intValue(uniformIndices);
    }

    public static void nglGetActiveUniformsiv(int program, int uniformCount, long uniformIndices, int pname, long params) {
        long __functionAddress = GL31.getInstance().GetActiveUniformsiv;
        JNI.callIIPIPV(__functionAddress, program, uniformCount, uniformIndices, pname, params);
    }

    public static void glGetActiveUniformsiv(int program, int uniformCount, ByteBuffer uniformIndices, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformIndices, uniformCount << 2);
            Checks.checkBuffer((Buffer)params, uniformCount << 2);
        }
        GL31.nglGetActiveUniformsiv(program, uniformCount, MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    public static void glGetActiveUniformsiv(int program, IntBuffer uniformIndices, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, uniformIndices.remaining());
        }
        GL31.nglGetActiveUniformsiv(program, uniformIndices.remaining(), MemoryUtil.memAddress(uniformIndices), pname, MemoryUtil.memAddress(params));
    }

    public static int glGetActiveUniformsi(int program, int uniformIndex, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        int uniformIndices = __buffer.intParam(uniformIndex);
        GL31.nglGetActiveUniformsiv(program, 1, __buffer.address(uniformIndices), pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetActiveUniformName(int program, int uniformIndex, int bufSize, long length, long uniformName) {
        long __functionAddress = GL31.getInstance().GetActiveUniformName;
        JNI.callIIIPPV(__functionAddress, program, uniformIndex, bufSize, length, uniformName);
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, int bufSize, ByteBuffer length, ByteBuffer uniformName) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformName, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL31.nglGetActiveUniformName(program, uniformIndex, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformName));
    }

    public static void glGetActiveUniformName(int program, int uniformIndex, IntBuffer length, ByteBuffer uniformName) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL31.nglGetActiveUniformName(program, uniformIndex, uniformName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformName));
    }

    public static String glGetActiveUniformName(int program, int uniformIndex, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformName = __buffer.bufferParam(bufSize);
        GL31.nglGetActiveUniformName(program, uniformIndex, bufSize, __buffer.address(length), __buffer.address(uniformName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformName);
    }

    public static String glGetActiveUniformName(int program, int uniformIndex) {
        int bufSize = GL31.glGetActiveUniformsi(program, uniformIndex, 35385);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformName = __buffer.bufferParam(bufSize);
        GL31.nglGetActiveUniformName(program, uniformIndex, bufSize, __buffer.address(length), __buffer.address(uniformName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformName);
    }

    public static int nglGetUniformBlockIndex(int program, long uniformBlockName) {
        long __functionAddress = GL31.getInstance().GetUniformBlockIndex;
        return JNI.callIPI(__functionAddress, program, uniformBlockName);
    }

    public static int glGetUniformBlockIndex(int program, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(uniformBlockName);
        }
        return GL31.nglGetUniformBlockIndex(program, MemoryUtil.memAddress(uniformBlockName));
    }

    public static int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int uniformBlockNameEncoded = __buffer.stringParamASCII(uniformBlockName, true);
        return GL31.nglGetUniformBlockIndex(program, __buffer.address(uniformBlockNameEncoded));
    }

    public static void nglGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, long params) {
        long __functionAddress = GL31.getInstance().GetActiveUniformBlockiv;
        JNI.callIIIPV(__functionAddress, program, uniformBlockIndex, pname, params);
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL31.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL31.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetActiveUniformBlocki(int program, int uniformBlockIndex, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL31.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, long length, long uniformBlockName) {
        long __functionAddress = GL31.getInstance().GetActiveUniformBlockName;
        JNI.callIIIPPV(__functionAddress, program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, ByteBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)uniformBlockName, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL31.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, IntBuffer length, ByteBuffer uniformBlockName) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL31.nglGetActiveUniformBlockName(program, uniformBlockIndex, uniformBlockName.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(uniformBlockName));
    }

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformBlockName = __buffer.bufferParam(bufSize);
        GL31.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, __buffer.address(length), __buffer.address(uniformBlockName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformBlockName);
    }

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex) {
        int bufSize = GL31.glGetActiveUniformBlocki(program, uniformBlockIndex, 35393);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int uniformBlockName = __buffer.bufferParam(bufSize);
        GL31.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, __buffer.address(length), __buffer.address(uniformBlockName));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), uniformBlockName);
    }

    public static void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        long __functionAddress = GL31.getInstance().UniformBlockBinding;
        JNI.callIIIV(__functionAddress, program, uniformBlockIndex, uniformBlockBinding);
    }
}

