/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLXEXTImportContext {
    public static final int GLX_SHARE_CONTEXT_EXT = 32778;
    public static final int GLX_VISUAL_ID_EXT = 32779;
    public static final int GLX_SCREEN_EXT = 32780;
    public final long GetCurrentDisplayEXT;
    public final long QueryContextInfoEXT;
    public final long GetContextIDEXT;
    public final long ImportContextEXT;
    public final long FreeContextEXT;

    protected GLXEXTImportContext() {
        throw new UnsupportedOperationException();
    }

    public GLXEXTImportContext(FunctionProvider provider) {
        this.GetCurrentDisplayEXT = provider.getFunctionAddress("glXGetCurrentDisplayEXT");
        this.QueryContextInfoEXT = provider.getFunctionAddress("glXQueryContextInfoEXT");
        this.GetContextIDEXT = provider.getFunctionAddress("glXGetContextIDEXT");
        this.ImportContextEXT = provider.getFunctionAddress("glXImportContextEXT");
        this.FreeContextEXT = provider.getFunctionAddress("glXFreeContextEXT");
    }

    public static GLXEXTImportContext getInstance() {
        return GLXEXTImportContext.getInstance(GL.getCapabilities());
    }

    public static GLXEXTImportContext getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLXEXTImportContext);
    }

    static GLXEXTImportContext create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_EXT_import_context")) {
            return null;
        }
        GLXEXTImportContext funcs = new GLXEXTImportContext(provider);
        boolean supported = Checks.checkFunctions(funcs.GetCurrentDisplayEXT, funcs.QueryContextInfoEXT, funcs.GetContextIDEXT, funcs.ImportContextEXT, funcs.FreeContextEXT);
        return GL.checkExtension("GLX_EXT_import_context", funcs, supported);
    }

    public static long glXGetCurrentDisplayEXT() {
        long __functionAddress = GLXEXTImportContext.getInstance().GetCurrentDisplayEXT;
        return JNI.callP(__functionAddress);
    }

    public static int nglXQueryContextInfoEXT(long display, long context, int attribute, long value) {
        long __functionAddress = GLXEXTImportContext.getInstance().QueryContextInfoEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(context);
        }
        return JNI.callPPIPI(__functionAddress, display, context, attribute, value);
    }

    public static int glXQueryContextInfoEXT(long display, long context, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return GLXEXTImportContext.nglXQueryContextInfoEXT(display, context, attribute, MemoryUtil.memAddress(value));
    }

    public static int glXQueryContextInfoEXT(long display, long context, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLXEXTImportContext.nglXQueryContextInfoEXT(display, context, attribute, MemoryUtil.memAddress(value));
    }

    public static long glXGetContextIDEXT(long context) {
        long __functionAddress = GLXEXTImportContext.getInstance().GetContextIDEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPP(__functionAddress, context);
    }

    public static long glXImportContextEXT(long display, long contextID) {
        long __functionAddress = GLXEXTImportContext.getInstance().ImportContextEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPP(__functionAddress, display, contextID);
    }

    public static void glXFreeContextEXT(long display, long context) {
        long __functionAddress = GLXEXTImportContext.getInstance().FreeContextEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(context);
        }
        JNI.callPPV(__functionAddress, display, context);
    }
}

