/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class INTELMapTexture {
    public static final int GL_TEXTURE_MEMORY_LAYOUT_INTEL = 33791;
    public static final int GL_LAYOUT_DEFAULT_INTEL = 0;
    public static final int GL_LAYOUT_LINEAR_INTEL = 1;
    public static final int GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2;
    public final long SyncTextureINTEL;
    public final long UnmapTexture2DINTEL;
    public final long MapTexture2DINTEL;

    protected INTELMapTexture() {
        throw new UnsupportedOperationException();
    }

    public INTELMapTexture(FunctionProvider provider) {
        this.SyncTextureINTEL = provider.getFunctionAddress("glSyncTextureINTEL");
        this.UnmapTexture2DINTEL = provider.getFunctionAddress("glUnmapTexture2DINTEL");
        this.MapTexture2DINTEL = provider.getFunctionAddress("glMapTexture2DINTEL");
    }

    public static INTELMapTexture getInstance() {
        return INTELMapTexture.getInstance(GL.getCapabilities());
    }

    public static INTELMapTexture getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__INTELMapTexture);
    }

    static INTELMapTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_INTEL_map_texture")) {
            return null;
        }
        INTELMapTexture funcs = new INTELMapTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.SyncTextureINTEL, funcs.UnmapTexture2DINTEL, funcs.MapTexture2DINTEL);
        return GL.checkExtension("GL_INTEL_map_texture", funcs, supported);
    }

    public static void glSyncTextureINTEL(int texture) {
        long __functionAddress = INTELMapTexture.getInstance().SyncTextureINTEL;
        JNI.callIV(__functionAddress, texture);
    }

    public static void glUnmapTexture2DINTEL(int texture, int level) {
        long __functionAddress = INTELMapTexture.getInstance().UnmapTexture2DINTEL;
        JNI.callIIV(__functionAddress, texture, level);
    }

    public static long nglMapTexture2DINTEL(int texture, int level, int access, long stride, long layout) {
        long __functionAddress = INTELMapTexture.getInstance().MapTexture2DINTEL;
        return JNI.callIIIPPP(__functionAddress, texture, level, access, stride, layout);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, ByteBuffer stride, ByteBuffer layout) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, 4);
            Checks.checkBuffer((Buffer)layout, 4);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        return MemoryUtil.memByteBuffer(__result, MemoryUtil.memGetInt(MemoryUtil.memAddress(stride)) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097));
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, 1);
            Checks.checkBuffer((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        int length = MemoryUtil.memGetInt(MemoryUtil.memAddress(stride)) * GLChecks.getTexLevelParameteri(texture, 3553, level, 4097);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapTexture2DINTEL(int texture, int level, int access, IntBuffer stride, IntBuffer layout, long length, ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)stride, 1);
            Checks.checkBuffer((Buffer)layout, 1);
        }
        long __result = INTELMapTexture.nglMapTexture2DINTEL(texture, level, access, MemoryUtil.memAddress(stride), MemoryUtil.memAddress(layout));
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }
}

