/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVPathRendering {
    public static final byte GL_CLOSE_PATH_NV = 0;
    public static final byte GL_MOVE_TO_NV = 2;
    public static final byte GL_RELATIVE_MOVE_TO_NV = 3;
    public static final byte GL_LINE_TO_NV = 4;
    public static final byte GL_RELATIVE_LINE_TO_NV = 5;
    public static final byte GL_HORIZONTAL_LINE_TO_NV = 6;
    public static final byte GL_RELATIVE_HORIZONTAL_LINE_TO_NV = 7;
    public static final byte GL_VERTICAL_LINE_TO_NV = 8;
    public static final byte GL_RELATIVE_VERTICAL_LINE_TO_NV = 9;
    public static final byte GL_QUADRATIC_CURVE_TO_NV = 10;
    public static final byte GL_RELATIVE_QUADRATIC_CURVE_TO_NV = 11;
    public static final byte GL_CUBIC_CURVE_TO_NV = 12;
    public static final byte GL_RELATIVE_CUBIC_CURVE_TO_NV = 13;
    public static final byte GL_SMOOTH_QUADRATIC_CURVE_TO_NV = 14;
    public static final byte GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = 15;
    public static final byte GL_SMOOTH_CUBIC_CURVE_TO_NV = 16;
    public static final byte GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = 17;
    public static final byte GL_SMALL_CCW_ARC_TO_NV = 18;
    public static final byte GL_RELATIVE_SMALL_CCW_ARC_TO_NV = 19;
    public static final byte GL_SMALL_CW_ARC_TO_NV = 20;
    public static final byte GL_RELATIVE_SMALL_CW_ARC_TO_NV = 21;
    public static final byte GL_LARGE_CCW_ARC_TO_NV = 22;
    public static final byte GL_RELATIVE_LARGE_CCW_ARC_TO_NV = 23;
    public static final byte GL_LARGE_CW_ARC_TO_NV = 24;
    public static final byte GL_RELATIVE_LARGE_CW_ARC_TO_NV = 25;
    public static final byte GL_CONIC_CURVE_TO_NV = 26;
    public static final byte GL_RELATIVE_CONIC_CURVE_TO_NV = 27;
    public static final byte GL_ROUNDED_RECT_NV = -24;
    public static final byte GL_RELATIVE_ROUNDED_RECT_NV = -23;
    public static final byte GL_ROUNDED_RECT2_NV = -22;
    public static final byte GL_RELATIVE_ROUNDED_RECT2_NV = -21;
    public static final byte GL_ROUNDED_RECT4_NV = -20;
    public static final byte GL_RELATIVE_ROUNDED_RECT4_NV = -19;
    public static final byte GL_ROUNDED_RECT8_NV = -18;
    public static final byte GL_RELATIVE_ROUNDED_RECT8_NV = -17;
    public static final byte GL_RESTART_PATH_NV = -16;
    public static final byte GL_DUP_FIRST_CUBIC_CURVE_TO_NV = -14;
    public static final byte GL_DUP_LAST_CUBIC_CURVE_TO_NV = -12;
    public static final byte GL_RECT_NV = -10;
    public static final byte GL_RELATIVE_RECT_NV = -9;
    public static final byte GL_CIRCULAR_CCW_ARC_TO_NV = -8;
    public static final byte GL_CIRCULAR_CW_ARC_TO_NV = -6;
    public static final byte GL_CIRCULAR_TANGENT_ARC_TO_NV = -4;
    public static final byte GL_ARC_TO_NV = -2;
    public static final byte GL_RELATIVE_ARC_TO_NV = -1;
    public static final int GL_PATH_FORMAT_SVG_NV = 36976;
    public static final int GL_PATH_FORMAT_PS_NV = 36977;
    public static final int GL_STANDARD_FONT_NAME_NV = 36978;
    public static final int GL_SYSTEM_FONT_NAME_NV = 36979;
    public static final int GL_FILE_NAME_NV = 36980;
    public static final int GL_STANDARD_FONT_FORMAT_NV = 37740;
    public static final int GL_SKIP_MISSING_GLYPH_NV = 37033;
    public static final int GL_USE_MISSING_GLYPH_NV = 37034;
    public static final int GL_FONT_GLYPHS_AVAILABLE_NV = 37736;
    public static final int GL_FONT_TARGET_UNAVAILABLE_NV = 37737;
    public static final int GL_FONT_UNAVAILABLE_NV = 37738;
    public static final int GL_FONT_UNINTELLIGIBLE_NV = 37739;
    public static final int GL_PATH_STROKE_WIDTH_NV = 36981;
    public static final int GL_PATH_INITIAL_END_CAP_NV = 36983;
    public static final int GL_PATH_TERMINAL_END_CAP_NV = 36984;
    public static final int GL_PATH_JOIN_STYLE_NV = 36985;
    public static final int GL_PATH_MITER_LIMIT_NV = 36986;
    public static final int GL_PATH_INITIAL_DASH_CAP_NV = 36988;
    public static final int GL_PATH_TERMINAL_DASH_CAP_NV = 36989;
    public static final int GL_PATH_DASH_OFFSET_NV = 36990;
    public static final int GL_PATH_CLIENT_LENGTH_NV = 36991;
    public static final int GL_PATH_DASH_OFFSET_RESET_NV = 37044;
    public static final int GL_PATH_FILL_MODE_NV = 36992;
    public static final int GL_PATH_FILL_MASK_NV = 36993;
    public static final int GL_PATH_FILL_COVER_MODE_NV = 36994;
    public static final int GL_PATH_STROKE_COVER_MODE_NV = 36995;
    public static final int GL_PATH_STROKE_MASK_NV = 36996;
    public static final int GL_PATH_STROKE_BOUND_NV = 36998;
    public static final int GL_PATH_END_CAPS_NV = 36982;
    public static final int GL_PATH_DASH_CAPS_NV = 36987;
    public static final int GL_COUNT_UP_NV = 37000;
    public static final int GL_COUNT_DOWN_NV = 37001;
    public static final int GL_PRIMARY_COLOR_NV = 34092;
    public static final int GL_SECONDARY_COLOR_NV = 34093;
    public static final int GL_PATH_OBJECT_BOUNDING_BOX_NV = 37002;
    public static final int GL_CONVEX_HULL_NV = 37003;
    public static final int GL_BOUNDING_BOX_NV = 37005;
    public static final int GL_TRANSLATE_X_NV = 37006;
    public static final int GL_TRANSLATE_Y_NV = 37007;
    public static final int GL_TRANSLATE_2D_NV = 37008;
    public static final int GL_TRANSLATE_3D_NV = 37009;
    public static final int GL_AFFINE_2D_NV = 37010;
    public static final int GL_AFFINE_3D_NV = 37012;
    public static final int GL_TRANSPOSE_AFFINE_2D_NV = 37014;
    public static final int GL_TRANSPOSE_AFFINE_3D_NV = 37016;
    public static final int GL_UTF8_NV = 37018;
    public static final int GL_UTF16_NV = 37019;
    public static final int GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 37020;
    public static final int GL_PATH_COMMAND_COUNT_NV = 37021;
    public static final int GL_PATH_COORD_COUNT_NV = 37022;
    public static final int GL_PATH_DASH_ARRAY_COUNT_NV = 37023;
    public static final int GL_PATH_COMPUTED_LENGTH_NV = 37024;
    public static final int GL_PATH_FILL_BOUNDING_BOX_NV = 37025;
    public static final int GL_PATH_STROKE_BOUNDING_BOX_NV = 37026;
    public static final int GL_SQUARE_NV = 37027;
    public static final int GL_ROUND_NV = 37028;
    public static final int GL_TRIANGULAR_NV = 37029;
    public static final int GL_BEVEL_NV = 37030;
    public static final int GL_MITER_REVERT_NV = 37031;
    public static final int GL_MITER_TRUNCATE_NV = 37032;
    public static final int GL_MOVE_TO_RESETS_NV = 37045;
    public static final int GL_MOVE_TO_CONTINUES_NV = 37046;
    public static final int GL_BOLD_BIT_NV = 1;
    public static final int GL_ITALIC_BIT_NV = 2;
    public static final int GL_PATH_ERROR_POSITION_NV = 37035;
    public static final int GL_PATH_FOG_GEN_MODE_NV = 37036;
    public static final int GL_PATH_STENCIL_FUNC_NV = 37047;
    public static final int GL_PATH_STENCIL_REF_NV = 37048;
    public static final int GL_PATH_STENCIL_VALUE_MASK_NV = 37049;
    public static final int GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 37053;
    public static final int GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 37054;
    public static final int GL_PATH_COVER_DEPTH_FUNC_NV = 37055;
    public static final int GL_GLYPH_WIDTH_BIT_NV = 1;
    public static final int GL_GLYPH_HEIGHT_BIT_NV = 2;
    public static final int GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = 4;
    public static final int GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = 8;
    public static final int GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = 16;
    public static final int GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = 32;
    public static final int GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = 64;
    public static final int GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = 128;
    public static final int GL_GLYPH_HAS_KERNING_BIT_NV = 256;
    public static final int GL_FONT_X_MIN_BOUNDS_BIT_NV = 65536;
    public static final int GL_FONT_Y_MIN_BOUNDS_BIT_NV = 131072;
    public static final int GL_FONT_X_MAX_BOUNDS_BIT_NV = 262144;
    public static final int GL_FONT_Y_MAX_BOUNDS_BIT_NV = 524288;
    public static final int GL_FONT_UNITS_PER_EM_BIT_NV = 0x100000;
    public static final int GL_FONT_ASCENDER_BIT_NV = 0x200000;
    public static final int GL_FONT_DESCENDER_BIT_NV = 0x400000;
    public static final int GL_FONT_HEIGHT_BIT_NV = 0x800000;
    public static final int GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = 0x1000000;
    public static final int GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = 0x2000000;
    public static final int GL_FONT_UNDERLINE_POSITION_BIT_NV = 0x4000000;
    public static final int GL_FONT_UNDERLINE_THICKNESS_BIT_NV = 0x8000000;
    public static final int GL_FONT_HAS_KERNING_BIT_NV = 0x10000000;
    public static final int GL_FONT_NUM_GLYPH_INDICES_BIT_NV = 0x20000000;
    public static final int GL_ACCUM_ADJACENT_PAIRS_NV = 37037;
    public static final int GL_ADJACENT_PAIRS_NV = 37038;
    public static final int GL_FIRST_TO_REST_NV = 37039;
    public static final int GL_PATH_GEN_MODE_NV = 37040;
    public static final int GL_PATH_GEN_COEFF_NV = 37041;
    public static final int GL_PATH_GEN_COLOR_FORMAT_NV = 37042;
    public static final int GL_PATH_GEN_COMPONENTS_NV = 37043;
    public static final int GL_FRAGMENT_INPUT_NV = 37741;
    public static final int GL_PATH_PROJECTION_NV = 5889;
    public static final int GL_PATH_MODELVIEW_NV = 5888;
    public static final int GL_PATH_MODELVIEW_STACK_DEPTH_NV = 2979;
    public static final int GL_PATH_MODELVIEW_MATRIX_NV = 2982;
    public static final int GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = 3382;
    public static final int GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = 34019;
    public static final int GL_PATH_PROJECTION_STACK_DEPTH_NV = 2980;
    public static final int GL_PATH_PROJECTION_MATRIX_NV = 2983;
    public static final int GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = 3384;
    public static final int GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = 34020;
    public static final int GL_2_BYTES_NV = 5127;
    public static final int GL_3_BYTES_NV = 5128;
    public static final int GL_4_BYTES_NV = 5129;
    public static final int GL_EYE_LINEAR_NV = 9216;
    public static final int GL_OBJECT_LINEAR_NV = 9217;
    public static final int GL_CONSTANT_NV = 34166;
    public final long PathCommandsNV;
    public final long PathCoordsNV;
    public final long PathSubCommandsNV;
    public final long PathSubCoordsNV;
    public final long PathStringNV;
    public final long PathGlyphsNV;
    public final long PathGlyphRangeNV;
    public final long PathGlyphIndexArrayNV;
    public final long PathMemoryGlyphIndexArrayNV;
    public final long CopyPathNV;
    public final long WeightPathsNV;
    public final long InterpolatePathsNV;
    public final long TransformPathNV;
    public final long PathParameterivNV;
    public final long PathParameteriNV;
    public final long PathParameterfvNV;
    public final long PathParameterfNV;
    public final long PathDashArrayNV;
    public final long GenPathsNV;
    public final long DeletePathsNV;
    public final long IsPathNV;
    public final long PathStencilFuncNV;
    public final long PathStencilDepthOffsetNV;
    public final long StencilFillPathNV;
    public final long StencilStrokePathNV;
    public final long StencilFillPathInstancedNV;
    public final long StencilStrokePathInstancedNV;
    public final long PathCoverDepthFuncNV;
    public final long PathColorGenNV;
    public final long PathTexGenNV;
    public final long PathFogGenNV;
    public final long CoverFillPathNV;
    public final long CoverStrokePathNV;
    public final long CoverFillPathInstancedNV;
    public final long CoverStrokePathInstancedNV;
    public final long StencilThenCoverFillPathNV;
    public final long StencilThenCoverStrokePathNV;
    public final long StencilThenCoverFillPathInstancedNV;
    public final long StencilThenCoverStrokePathInstancedNV;
    public final long PathGlyphIndexRangeNV;
    public final long ProgramPathFragmentInputGenNV;
    public final long GetPathParameterivNV;
    public final long GetPathParameterfvNV;
    public final long GetPathCommandsNV;
    public final long GetPathCoordsNV;
    public final long GetPathDashArrayNV;
    public final long GetPathMetricsNV;
    public final long GetPathMetricRangeNV;
    public final long GetPathSpacingNV;
    public final long GetPathColorGenivNV;
    public final long GetPathColorGenfvNV;
    public final long GetPathTexGenivNV;
    public final long GetPathTexGenfvNV;
    public final long IsPointInFillPathNV;
    public final long IsPointInStrokePathNV;
    public final long GetPathLengthNV;
    public final long PointAlongPathNV;
    public final long MatrixLoad3x2fNV;
    public final long MatrixLoad3x3fNV;
    public final long MatrixLoadTranspose3x3fNV;
    public final long MatrixMult3x2fNV;
    public final long MatrixMult3x3fNV;
    public final long MatrixMultTranspose3x3fNV;
    public final long GetProgramResourcefvNV;

    protected NVPathRendering() {
        throw new UnsupportedOperationException();
    }

    public NVPathRendering(FunctionProvider provider) {
        this.PathCommandsNV = provider.getFunctionAddress("glPathCommandsNV");
        this.PathCoordsNV = provider.getFunctionAddress("glPathCoordsNV");
        this.PathSubCommandsNV = provider.getFunctionAddress("glPathSubCommandsNV");
        this.PathSubCoordsNV = provider.getFunctionAddress("glPathSubCoordsNV");
        this.PathStringNV = provider.getFunctionAddress("glPathStringNV");
        this.PathGlyphsNV = provider.getFunctionAddress("glPathGlyphsNV");
        this.PathGlyphRangeNV = provider.getFunctionAddress("glPathGlyphRangeNV");
        this.PathGlyphIndexArrayNV = provider.getFunctionAddress("glPathGlyphIndexArrayNV");
        this.PathMemoryGlyphIndexArrayNV = provider.getFunctionAddress("glPathMemoryGlyphIndexArrayNV");
        this.CopyPathNV = provider.getFunctionAddress("glCopyPathNV");
        this.WeightPathsNV = provider.getFunctionAddress("glWeightPathsNV");
        this.InterpolatePathsNV = provider.getFunctionAddress("glInterpolatePathsNV");
        this.TransformPathNV = provider.getFunctionAddress("glTransformPathNV");
        this.PathParameterivNV = provider.getFunctionAddress("glPathParameterivNV");
        this.PathParameteriNV = provider.getFunctionAddress("glPathParameteriNV");
        this.PathParameterfvNV = provider.getFunctionAddress("glPathParameterfvNV");
        this.PathParameterfNV = provider.getFunctionAddress("glPathParameterfNV");
        this.PathDashArrayNV = provider.getFunctionAddress("glPathDashArrayNV");
        this.GenPathsNV = provider.getFunctionAddress("glGenPathsNV");
        this.DeletePathsNV = provider.getFunctionAddress("glDeletePathsNV");
        this.IsPathNV = provider.getFunctionAddress("glIsPathNV");
        this.PathStencilFuncNV = provider.getFunctionAddress("glPathStencilFuncNV");
        this.PathStencilDepthOffsetNV = provider.getFunctionAddress("glPathStencilDepthOffsetNV");
        this.StencilFillPathNV = provider.getFunctionAddress("glStencilFillPathNV");
        this.StencilStrokePathNV = provider.getFunctionAddress("glStencilStrokePathNV");
        this.StencilFillPathInstancedNV = provider.getFunctionAddress("glStencilFillPathInstancedNV");
        this.StencilStrokePathInstancedNV = provider.getFunctionAddress("glStencilStrokePathInstancedNV");
        this.PathCoverDepthFuncNV = provider.getFunctionAddress("glPathCoverDepthFuncNV");
        this.PathColorGenNV = provider.getFunctionAddress("glPathColorGenNV");
        this.PathTexGenNV = provider.getFunctionAddress("glPathTexGenNV");
        this.PathFogGenNV = provider.getFunctionAddress("glPathFogGenNV");
        this.CoverFillPathNV = provider.getFunctionAddress("glCoverFillPathNV");
        this.CoverStrokePathNV = provider.getFunctionAddress("glCoverStrokePathNV");
        this.CoverFillPathInstancedNV = provider.getFunctionAddress("glCoverFillPathInstancedNV");
        this.CoverStrokePathInstancedNV = provider.getFunctionAddress("glCoverStrokePathInstancedNV");
        this.StencilThenCoverFillPathNV = provider.getFunctionAddress("glStencilThenCoverFillPathNV");
        this.StencilThenCoverStrokePathNV = provider.getFunctionAddress("glStencilThenCoverStrokePathNV");
        this.StencilThenCoverFillPathInstancedNV = provider.getFunctionAddress("glStencilThenCoverFillPathInstancedNV");
        this.StencilThenCoverStrokePathInstancedNV = provider.getFunctionAddress("glStencilThenCoverStrokePathInstancedNV");
        this.PathGlyphIndexRangeNV = provider.getFunctionAddress("glPathGlyphIndexRangeNV");
        this.ProgramPathFragmentInputGenNV = provider.getFunctionAddress("glProgramPathFragmentInputGenNV");
        this.GetPathParameterivNV = provider.getFunctionAddress("glGetPathParameterivNV");
        this.GetPathParameterfvNV = provider.getFunctionAddress("glGetPathParameterfvNV");
        this.GetPathCommandsNV = provider.getFunctionAddress("glGetPathCommandsNV");
        this.GetPathCoordsNV = provider.getFunctionAddress("glGetPathCoordsNV");
        this.GetPathDashArrayNV = provider.getFunctionAddress("glGetPathDashArrayNV");
        this.GetPathMetricsNV = provider.getFunctionAddress("glGetPathMetricsNV");
        this.GetPathMetricRangeNV = provider.getFunctionAddress("glGetPathMetricRangeNV");
        this.GetPathSpacingNV = provider.getFunctionAddress("glGetPathSpacingNV");
        this.GetPathColorGenivNV = provider.getFunctionAddress("glGetPathColorGenivNV");
        this.GetPathColorGenfvNV = provider.getFunctionAddress("glGetPathColorGenfvNV");
        this.GetPathTexGenivNV = provider.getFunctionAddress("glGetPathTexGenivNV");
        this.GetPathTexGenfvNV = provider.getFunctionAddress("glGetPathTexGenfvNV");
        this.IsPointInFillPathNV = provider.getFunctionAddress("glIsPointInFillPathNV");
        this.IsPointInStrokePathNV = provider.getFunctionAddress("glIsPointInStrokePathNV");
        this.GetPathLengthNV = provider.getFunctionAddress("glGetPathLengthNV");
        this.PointAlongPathNV = provider.getFunctionAddress("glPointAlongPathNV");
        this.MatrixLoad3x2fNV = provider.getFunctionAddress("glMatrixLoad3x2fNV");
        this.MatrixLoad3x3fNV = provider.getFunctionAddress("glMatrixLoad3x3fNV");
        this.MatrixLoadTranspose3x3fNV = provider.getFunctionAddress("glMatrixLoadTranspose3x3fNV");
        this.MatrixMult3x2fNV = provider.getFunctionAddress("glMatrixMult3x2fNV");
        this.MatrixMult3x3fNV = provider.getFunctionAddress("glMatrixMult3x3fNV");
        this.MatrixMultTranspose3x3fNV = provider.getFunctionAddress("glMatrixMultTranspose3x3fNV");
        this.GetProgramResourcefvNV = provider.getFunctionAddress("glGetProgramResourcefvNV");
    }

    public static NVPathRendering getInstance() {
        return NVPathRendering.getInstance(GL.getCapabilities());
    }

    public static NVPathRendering getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVPathRendering);
    }

    static NVPathRendering create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_path_rendering")) {
            return null;
        }
        NVPathRendering funcs = new NVPathRendering(provider);
        boolean supported = Checks.checkFunctions(funcs.PathCommandsNV, funcs.PathCoordsNV, funcs.PathSubCommandsNV, funcs.PathSubCoordsNV, funcs.PathStringNV, funcs.PathGlyphsNV, funcs.PathGlyphRangeNV, funcs.CopyPathNV, funcs.InterpolatePathsNV, funcs.TransformPathNV, funcs.PathParameterivNV, funcs.PathParameteriNV, funcs.PathParameterfvNV, funcs.PathParameterfNV, funcs.PathDashArrayNV, funcs.GenPathsNV, funcs.DeletePathsNV, funcs.IsPathNV, funcs.PathStencilFuncNV, funcs.PathStencilDepthOffsetNV, funcs.StencilFillPathNV, funcs.StencilStrokePathNV, funcs.StencilFillPathInstancedNV, funcs.StencilStrokePathInstancedNV, funcs.PathCoverDepthFuncNV, funcs.CoverFillPathNV, funcs.CoverStrokePathNV, funcs.CoverFillPathInstancedNV, funcs.CoverStrokePathInstancedNV, funcs.GetPathParameterivNV, funcs.GetPathParameterfvNV, funcs.GetPathCommandsNV, funcs.GetPathCoordsNV, funcs.GetPathDashArrayNV, funcs.GetPathMetricsNV, funcs.GetPathMetricRangeNV, funcs.GetPathSpacingNV, funcs.IsPointInFillPathNV, funcs.IsPointInStrokePathNV, funcs.GetPathLengthNV, funcs.PointAlongPathNV);
        return GL.checkExtension("GL_NV_path_rendering", funcs, supported);
    }

    public static void nglPathCommandsNV(int path, int numCommands, long commands, int numCoords, int coordType, long coords) {
        long __functionAddress = NVPathRendering.getInstance().PathCommandsNV;
        JNI.callIIPIIPV(__functionAddress, path, numCommands, commands, numCoords, coordType, coords);
    }

    public static void glPathCommandsNV(int path, int numCommands, ByteBuffer commands, int numCoords, int coordType, ByteBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)commands, numCommands);
            Checks.checkBuffer((Buffer)coords, numCoords << GLChecks.typeToByteShift(coordType));
        }
        NVPathRendering.nglPathCommandsNV(path, numCommands, MemoryUtil.memAddress(commands), numCoords, coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathCommandsNV(int path, ByteBuffer commands, int coordType, ByteBuffer coords) {
        NVPathRendering.nglPathCommandsNV(path, commands.remaining(), MemoryUtil.memAddress(commands), coords.remaining() >> GLChecks.typeToByteShift(coordType), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathCommandsNV(int path, ByteBuffer commands, int coordType, ShortBuffer coords) {
        NVPathRendering.nglPathCommandsNV(path, commands.remaining(), MemoryUtil.memAddress(commands), coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathCommandsNV(int path, ByteBuffer commands, int coordType, FloatBuffer coords) {
        NVPathRendering.nglPathCommandsNV(path, commands.remaining(), MemoryUtil.memAddress(commands), coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void nglPathCoordsNV(int path, int numCoords, int coordType, long coords) {
        long __functionAddress = NVPathRendering.getInstance().PathCoordsNV;
        JNI.callIIIPV(__functionAddress, path, numCoords, coordType, coords);
    }

    public static void glPathCoordsNV(int path, int numCoords, int coordType, ByteBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, numCoords << GLChecks.typeToByteShift(coordType));
        }
        NVPathRendering.nglPathCoordsNV(path, numCoords, coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathCoordsNV(int path, int coordType, ByteBuffer coords) {
        NVPathRendering.nglPathCoordsNV(path, coords.remaining() >> GLChecks.typeToByteShift(coordType), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathCoordsNV(int path, int coordType, ShortBuffer coords) {
        NVPathRendering.nglPathCoordsNV(path, coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathCoordsNV(int path, int coordType, FloatBuffer coords) {
        NVPathRendering.nglPathCoordsNV(path, coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void nglPathSubCommandsNV(int path, int commandStart, int commandsToDelete, int numCommands, long commands, int numCoords, int coordType, long coords) {
        long __functionAddress = NVPathRendering.getInstance().PathSubCommandsNV;
        JNI.callIIIIPIIPV(__functionAddress, path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords);
    }

    public static void glPathSubCommandsNV(int path, int commandStart, int commandsToDelete, int numCommands, ByteBuffer commands, int numCoords, int coordType, ByteBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)commands, numCommands);
            Checks.checkBuffer((Buffer)coords, numCoords << GLChecks.typeToByteShift(coordType));
        }
        NVPathRendering.nglPathSubCommandsNV(path, commandStart, commandsToDelete, numCommands, MemoryUtil.memAddress(commands), numCoords, coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathSubCommandsNV(int path, int commandStart, int commandsToDelete, ByteBuffer commands, int coordType, ByteBuffer coords) {
        NVPathRendering.nglPathSubCommandsNV(path, commandStart, commandsToDelete, commands.remaining(), MemoryUtil.memAddress(commands), coords.remaining() >> GLChecks.typeToByteShift(coordType), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathSubCommandsNV(int path, int commandStart, int commandsToDelete, ByteBuffer commands, int coordType, ShortBuffer coords) {
        NVPathRendering.nglPathSubCommandsNV(path, commandStart, commandsToDelete, commands.remaining(), MemoryUtil.memAddress(commands), coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathSubCommandsNV(int path, int commandStart, int commandsToDelete, ByteBuffer commands, int coordType, FloatBuffer coords) {
        NVPathRendering.nglPathSubCommandsNV(path, commandStart, commandsToDelete, commands.remaining(), MemoryUtil.memAddress(commands), coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void nglPathSubCoordsNV(int path, int coordStart, int numCoords, int coordType, long coords) {
        long __functionAddress = NVPathRendering.getInstance().PathSubCoordsNV;
        JNI.callIIIIPV(__functionAddress, path, coordStart, numCoords, coordType, coords);
    }

    public static void glPathSubCoordsNV(int path, int coordStart, int numCoords, int coordType, ByteBuffer coords) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coords, numCoords << GLChecks.typeToByteShift(coordType));
        }
        NVPathRendering.nglPathSubCoordsNV(path, coordStart, numCoords, coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathSubCoordsNV(int path, int coordStart, int coordType, ByteBuffer coords) {
        NVPathRendering.nglPathSubCoordsNV(path, coordStart, coords.remaining() >> GLChecks.typeToByteShift(coordType), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathSubCoordsNV(int path, int coordStart, int coordType, ShortBuffer coords) {
        NVPathRendering.nglPathSubCoordsNV(path, coordStart, coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void glPathSubCoordsNV(int path, int coordStart, int coordType, FloatBuffer coords) {
        NVPathRendering.nglPathSubCoordsNV(path, coordStart, coords.remaining(), coordType, MemoryUtil.memAddress(coords));
    }

    public static void nglPathStringNV(int path, int format, int length, long pathString) {
        long __functionAddress = NVPathRendering.getInstance().PathStringNV;
        JNI.callIIIPV(__functionAddress, path, format, length, pathString);
    }

    public static void glPathStringNV(int path, int format, int length, ByteBuffer pathString) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pathString, length);
        }
        NVPathRendering.nglPathStringNV(path, format, length, MemoryUtil.memAddress(pathString));
    }

    public static void glPathStringNV(int path, int format, ByteBuffer pathString) {
        NVPathRendering.nglPathStringNV(path, format, pathString.remaining(), MemoryUtil.memAddress(pathString));
    }

    public static void nglPathGlyphsNV(int firstPathName, int fontTarget, long fontName, int fontStyle, int numGlyphs, int type, long charcodes, int handleMissingGlyphs, int pathParameterTemplate, float emScale) {
        long __functionAddress = NVPathRendering.getInstance().PathGlyphsNV;
        JNI.callIIPIIIPIIFV(__functionAddress, firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale);
    }

    public static void glPathGlyphsNV(int firstPathName, int fontTarget, ByteBuffer fontName, int fontStyle, int numGlyphs, int type, ByteBuffer charcodes, int handleMissingGlyphs, int pathParameterTemplate, float emScale) {
        if (Checks.CHECKS) {
            Checks.checkNT1(fontName);
            Checks.checkBuffer((Buffer)charcodes, numGlyphs * NVPathRendering.charcodeTypeToBytes(type));
        }
        NVPathRendering.nglPathGlyphsNV(firstPathName, fontTarget, MemoryUtil.memAddress(fontName), fontStyle, numGlyphs, type, MemoryUtil.memAddress(charcodes), handleMissingGlyphs, pathParameterTemplate, emScale);
    }

    public static void glPathGlyphsNV(int firstPathName, int fontTarget, ByteBuffer fontName, int fontStyle, int type, ByteBuffer charcodes, int handleMissingGlyphs, int pathParameterTemplate, float emScale) {
        if (Checks.CHECKS) {
            Checks.checkNT1(fontName);
        }
        NVPathRendering.nglPathGlyphsNV(firstPathName, fontTarget, MemoryUtil.memAddress(fontName), fontStyle, charcodes.remaining() / NVPathRendering.charcodeTypeToBytes(type), type, MemoryUtil.memAddress(charcodes), handleMissingGlyphs, pathParameterTemplate, emScale);
    }

    public static void nglPathGlyphRangeNV(int firstPathName, int fontTarget, long fontName, int fontStyle, int firstGlyph, int numGlyphs, int handleMissingGlyphs, int pathParameterTemplate, float emScale) {
        long __functionAddress = NVPathRendering.getInstance().PathGlyphRangeNV;
        JNI.callIIPIIIIIFV(__functionAddress, firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale);
    }

    public static void glPathGlyphRangeNV(int firstPathName, int fontTarget, ByteBuffer fontName, int fontStyle, int firstGlyph, int numGlyphs, int handleMissingGlyphs, int pathParameterTemplate, float emScale) {
        if (Checks.CHECKS) {
            Checks.checkNT1(fontName);
        }
        NVPathRendering.nglPathGlyphRangeNV(firstPathName, fontTarget, MemoryUtil.memAddress(fontName), fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale);
    }

    public static int nglPathGlyphIndexArrayNV(int firstPathName, int fontTarget, long fontName, int fontStyle, int firstGlyphIndex, int numGlyphs, int pathParameterTemplate, float emScale) {
        long __functionAddress = NVPathRendering.getInstance().PathGlyphIndexArrayNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callIIPIIIIFI(__functionAddress, firstPathName, fontTarget, fontName, fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    }

    public static int glPathGlyphIndexArrayNV(int firstPathName, int fontTarget, ByteBuffer fontName, int fontStyle, int firstGlyphIndex, int numGlyphs, int pathParameterTemplate, float emScale) {
        if (Checks.CHECKS) {
            Checks.checkNT1(fontName);
        }
        return NVPathRendering.nglPathGlyphIndexArrayNV(firstPathName, fontTarget, MemoryUtil.memAddress(fontName), fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    }

    public static int nglPathMemoryGlyphIndexArrayNV(int firstPathName, int fontTarget, long fontSize, long fontData, int faceIndex, int firstGlyphIndex, int numGlyphs, int pathParameterTemplate, float emScale) {
        long __functionAddress = NVPathRendering.getInstance().PathMemoryGlyphIndexArrayNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callIIPPIIIIFI(__functionAddress, firstPathName, fontTarget, fontSize, fontData, faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    }

    public static int glPathMemoryGlyphIndexArrayNV(int firstPathName, int fontTarget, long fontSize, ByteBuffer fontData, int faceIndex, int firstGlyphIndex, int numGlyphs, int pathParameterTemplate, float emScale) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)fontData, fontSize);
        }
        return NVPathRendering.nglPathMemoryGlyphIndexArrayNV(firstPathName, fontTarget, fontSize, MemoryUtil.memAddress(fontData), faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    }

    public static int glPathMemoryGlyphIndexArrayNV(int firstPathName, int fontTarget, ByteBuffer fontData, int faceIndex, int firstGlyphIndex, int numGlyphs, int pathParameterTemplate, float emScale) {
        return NVPathRendering.nglPathMemoryGlyphIndexArrayNV(firstPathName, fontTarget, fontData.remaining(), MemoryUtil.memAddress(fontData), faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    }

    public static void glCopyPathNV(int resultPath, int srcPath) {
        long __functionAddress = NVPathRendering.getInstance().CopyPathNV;
        JNI.callIIV(__functionAddress, resultPath, srcPath);
    }

    public static void nglWeightPathsNV(int resultPath, int numPaths, long paths, long weights) {
        long __functionAddress = NVPathRendering.getInstance().WeightPathsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPPV(__functionAddress, resultPath, numPaths, paths, weights);
    }

    public static void glWeightPathsNV(int resultPath, int numPaths, ByteBuffer paths, ByteBuffer weights) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths << 2);
            Checks.checkBuffer((Buffer)weights, numPaths << 2);
        }
        NVPathRendering.nglWeightPathsNV(resultPath, numPaths, MemoryUtil.memAddress(paths), MemoryUtil.memAddress(weights));
    }

    public static void glWeightPathsNV(int resultPath, IntBuffer paths, FloatBuffer weights) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)weights, paths.remaining());
        }
        NVPathRendering.nglWeightPathsNV(resultPath, paths.remaining(), MemoryUtil.memAddress(paths), MemoryUtil.memAddress(weights));
    }

    public static void glInterpolatePathsNV(int resultPath, int pathA, int pathB, float weight) {
        long __functionAddress = NVPathRendering.getInstance().InterpolatePathsNV;
        JNI.callIIIFV(__functionAddress, resultPath, pathA, pathB, weight);
    }

    public static void nglTransformPathNV(int resultPath, int srcPath, int transformType, long transformValues) {
        long __functionAddress = NVPathRendering.getInstance().TransformPathNV;
        JNI.callIIIPV(__functionAddress, resultPath, srcPath, transformType, transformValues);
    }

    public static void glTransformPathNV(int resultPath, int srcPath, int transformType, ByteBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, NVPathRendering.transformTypeToElements(transformType) << 2);
        }
        NVPathRendering.nglTransformPathNV(resultPath, srcPath, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glTransformPathNV(int resultPath, int srcPath, int transformType, FloatBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, NVPathRendering.transformTypeToElements(transformType));
        }
        NVPathRendering.nglTransformPathNV(resultPath, srcPath, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void nglPathParameterivNV(int path, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().PathParameterivNV;
        JNI.callIIPV(__functionAddress, path, pname, value);
    }

    public static void glPathParameterivNV(int path, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglPathParameterivNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static void glPathParameterivNV(int path, int pname, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglPathParameterivNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static void glPathParameteriNV(int path, int pname, int value) {
        long __functionAddress = NVPathRendering.getInstance().PathParameteriNV;
        JNI.callIIIV(__functionAddress, path, pname, value);
    }

    public static void nglPathParameterfvNV(int path, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().PathParameterfvNV;
        JNI.callIIPV(__functionAddress, path, pname, value);
    }

    public static void glPathParameterfvNV(int path, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglPathParameterfvNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static void glPathParameterfvNV(int path, int pname, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglPathParameterfvNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static void glPathParameterfNV(int path, int pname, float value) {
        long __functionAddress = NVPathRendering.getInstance().PathParameterfNV;
        JNI.callIIFV(__functionAddress, path, pname, value);
    }

    public static void nglPathDashArrayNV(int path, int dashCount, long dashArray) {
        long __functionAddress = NVPathRendering.getInstance().PathDashArrayNV;
        JNI.callIIPV(__functionAddress, path, dashCount, dashArray);
    }

    public static void glPathDashArrayNV(int path, int dashCount, ByteBuffer dashArray) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)dashArray, dashCount << 2);
        }
        NVPathRendering.nglPathDashArrayNV(path, dashCount, MemoryUtil.memAddress(dashArray));
    }

    public static void glPathDashArrayNV(int path, FloatBuffer dashArray) {
        NVPathRendering.nglPathDashArrayNV(path, dashArray.remaining(), MemoryUtil.memAddress(dashArray));
    }

    public static int glGenPathsNV(int range) {
        long __functionAddress = NVPathRendering.getInstance().GenPathsNV;
        return JNI.callII(__functionAddress, range);
    }

    public static void glDeletePathsNV(int path, int range) {
        long __functionAddress = NVPathRendering.getInstance().DeletePathsNV;
        JNI.callIIV(__functionAddress, path, range);
    }

    public static boolean glIsPathNV(int path) {
        long __functionAddress = NVPathRendering.getInstance().IsPathNV;
        return JNI.callIZ(__functionAddress, path);
    }

    public static void glPathStencilFuncNV(int func, int ref, int mask) {
        long __functionAddress = NVPathRendering.getInstance().PathStencilFuncNV;
        JNI.callIIIV(__functionAddress, func, ref, mask);
    }

    public static void glPathStencilDepthOffsetNV(float factor, float units) {
        long __functionAddress = NVPathRendering.getInstance().PathStencilDepthOffsetNV;
        JNI.callFFV(__functionAddress, factor, units);
    }

    public static void glStencilFillPathNV(int path, int fillMode, int mask) {
        long __functionAddress = NVPathRendering.getInstance().StencilFillPathNV;
        JNI.callIIIV(__functionAddress, path, fillMode, mask);
    }

    public static void glStencilStrokePathNV(int path, int reference, int mask) {
        long __functionAddress = NVPathRendering.getInstance().StencilStrokePathNV;
        JNI.callIIIV(__functionAddress, path, reference, mask);
    }

    public static void nglStencilFillPathInstancedNV(int numPaths, int pathNameType, long paths, int pathBase, int fillMode, int mask, int transformType, long transformValues) {
        long __functionAddress = NVPathRendering.getInstance().StencilFillPathInstancedNV;
        JNI.callIIPIIIIPV(__functionAddress, numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues);
    }

    public static void glStencilFillPathInstancedNV(int numPaths, int pathNameType, ByteBuffer paths, int pathBase, int fillMode, int mask, int transformType, ByteBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType) << 2);
        }
        NVPathRendering.nglStencilFillPathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, fillMode, mask, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glStencilFillPathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int fillMode, int mask, int transformType, FloatBuffer transformValues) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType));
        }
        NVPathRendering.nglStencilFillPathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, fillMode, mask, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void nglStencilStrokePathInstancedNV(int numPaths, int pathNameType, long paths, int pathBase, int reference, int mask, int transformType, long transformValues) {
        long __functionAddress = NVPathRendering.getInstance().StencilStrokePathInstancedNV;
        JNI.callIIPIIIIPV(__functionAddress, numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues);
    }

    public static void glStencilStrokePathInstancedNV(int numPaths, int pathNameType, ByteBuffer paths, int pathBase, int reference, int mask, int transformType, ByteBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType) << 2);
        }
        NVPathRendering.nglStencilStrokePathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, reference, mask, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glStencilStrokePathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int reference, int mask, int transformType, FloatBuffer transformValues) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType));
        }
        NVPathRendering.nglStencilStrokePathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, reference, mask, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glPathCoverDepthFuncNV(int zfunc) {
        long __functionAddress = NVPathRendering.getInstance().PathCoverDepthFuncNV;
        JNI.callIV(__functionAddress, zfunc);
    }

    public static void nglPathColorGenNV(int color, int genMode, int colorFormat, long coeffs) {
        long __functionAddress = NVPathRendering.getInstance().PathColorGenNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, color, genMode, colorFormat, coeffs);
    }

    public static void glPathColorGenNV(int color, int genMode, int colorFormat, ByteBuffer coeffs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coeffs, NVPathRendering.genModeToElements(genMode) * NVPathRendering.colorFormatToComponents(colorFormat) << 2);
        }
        NVPathRendering.nglPathColorGenNV(color, genMode, colorFormat, MemoryUtil.memAddress(coeffs));
    }

    public static void glPathColorGenNV(int color, int genMode, int colorFormat, FloatBuffer coeffs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coeffs, NVPathRendering.genModeToElements(genMode) * NVPathRendering.colorFormatToComponents(colorFormat));
        }
        NVPathRendering.nglPathColorGenNV(color, genMode, colorFormat, MemoryUtil.memAddress(coeffs));
    }

    public static void nglPathTexGenNV(int texCoordSet, int genMode, int components, long coeffs) {
        long __functionAddress = NVPathRendering.getInstance().PathTexGenNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, texCoordSet, genMode, components, coeffs);
    }

    public static void glPathTexGenNV(int texCoordSet, int genMode, int components, ByteBuffer coeffs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coeffs, NVPathRendering.genModeToElements(genMode) * components << 2);
        }
        NVPathRendering.nglPathTexGenNV(texCoordSet, genMode, components, MemoryUtil.memAddress(coeffs));
    }

    public static void glPathTexGenNV(int texCoordSet, int genMode, int components, FloatBuffer coeffs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coeffs, NVPathRendering.genModeToElements(genMode) * components);
        }
        NVPathRendering.nglPathTexGenNV(texCoordSet, genMode, components, MemoryUtil.memAddress(coeffs));
    }

    public static void glPathFogGenNV(int genMode) {
        long __functionAddress = NVPathRendering.getInstance().PathFogGenNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIV(__functionAddress, genMode);
    }

    public static void glCoverFillPathNV(int path, int coverMode) {
        long __functionAddress = NVPathRendering.getInstance().CoverFillPathNV;
        JNI.callIIV(__functionAddress, path, coverMode);
    }

    public static void glCoverStrokePathNV(int path, int coverMode) {
        long __functionAddress = NVPathRendering.getInstance().CoverStrokePathNV;
        JNI.callIIV(__functionAddress, path, coverMode);
    }

    public static void nglCoverFillPathInstancedNV(int numPaths, int pathNameType, long paths, int pathBase, int coverMode, int transformType, long transformValues) {
        long __functionAddress = NVPathRendering.getInstance().CoverFillPathInstancedNV;
        JNI.callIIPIIIPV(__functionAddress, numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
    }

    public static void glCoverFillPathInstancedNV(int numPaths, int pathNameType, ByteBuffer paths, int pathBase, int coverMode, int transformType, ByteBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType) << 2);
        }
        NVPathRendering.nglCoverFillPathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glCoverFillPathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int coverMode, int transformType, FloatBuffer transformValues) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType));
        }
        NVPathRendering.nglCoverFillPathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void nglCoverStrokePathInstancedNV(int numPaths, int pathNameType, long paths, int pathBase, int coverMode, int transformType, long transformValues) {
        long __functionAddress = NVPathRendering.getInstance().CoverStrokePathInstancedNV;
        JNI.callIIPIIIPV(__functionAddress, numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
    }

    public static void glCoverStrokePathInstancedNV(int numPaths, int pathNameType, ByteBuffer paths, int pathBase, int coverMode, int transformType, ByteBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType) << 2);
        }
        NVPathRendering.nglCoverStrokePathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glCoverStrokePathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int coverMode, int transformType, FloatBuffer transformValues) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType));
        }
        NVPathRendering.nglCoverStrokePathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glStencilThenCoverFillPathNV(int path, int fillMode, int mask, int coverMode) {
        long __functionAddress = NVPathRendering.getInstance().StencilThenCoverFillPathNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIV(__functionAddress, path, fillMode, mask, coverMode);
    }

    public static void glStencilThenCoverStrokePathNV(int path, int reference, int mask, int coverMode) {
        long __functionAddress = NVPathRendering.getInstance().StencilThenCoverStrokePathNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIV(__functionAddress, path, reference, mask, coverMode);
    }

    public static void nglStencilThenCoverFillPathInstancedNV(int numPaths, int pathNameType, long paths, int pathBase, int fillMode, int mask, int coverMode, int transformType, long transformValues) {
        long __functionAddress = NVPathRendering.getInstance().StencilThenCoverFillPathInstancedNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPIIIIIPV(__functionAddress, numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode, transformType, transformValues);
    }

    public static void glStencilThenCoverFillPathInstancedNV(int numPaths, int pathNameType, ByteBuffer paths, int pathBase, int fillMode, int mask, int coverMode, int transformType, ByteBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType) << 2);
        }
        NVPathRendering.nglStencilThenCoverFillPathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, fillMode, mask, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glStencilThenCoverFillPathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int fillMode, int mask, int coverMode, int transformType, FloatBuffer transformValues) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType));
        }
        NVPathRendering.nglStencilThenCoverFillPathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, fillMode, mask, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void nglStencilThenCoverStrokePathInstancedNV(int numPaths, int pathNameType, long paths, int pathBase, int reference, int mask, int coverMode, int transformType, long transformValues) {
        long __functionAddress = NVPathRendering.getInstance().StencilThenCoverStrokePathInstancedNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPIIIIIPV(__functionAddress, numPaths, pathNameType, paths, pathBase, reference, mask, coverMode, transformType, transformValues);
    }

    public static void glStencilThenCoverStrokePathInstancedNV(int numPaths, int pathNameType, ByteBuffer paths, int pathBase, int reference, int mask, int coverMode, int transformType, ByteBuffer transformValues) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType) << 2);
        }
        NVPathRendering.nglStencilThenCoverStrokePathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, reference, mask, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static void glStencilThenCoverStrokePathInstancedNV(int pathNameType, ByteBuffer paths, int pathBase, int reference, int mask, int coverMode, int transformType, FloatBuffer transformValues) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)transformValues, numPaths * NVPathRendering.transformTypeToElements(transformType));
        }
        NVPathRendering.nglStencilThenCoverStrokePathInstancedNV(numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, reference, mask, coverMode, transformType, MemoryUtil.memAddress(transformValues));
    }

    public static int nglPathGlyphIndexRangeNV(int fontTarget, long fontName, int fontStyle, int pathParameterTemplate, float emScale, int baseAndCount) {
        long __functionAddress = NVPathRendering.getInstance().PathGlyphIndexRangeNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callIPIIFII(__functionAddress, fontTarget, fontName, fontStyle, pathParameterTemplate, emScale, baseAndCount);
    }

    public static int glPathGlyphIndexRangeNV(int fontTarget, ByteBuffer fontName, int fontStyle, int pathParameterTemplate, float emScale, int baseAndCount) {
        if (Checks.CHECKS) {
            Checks.checkNT1(fontName);
        }
        return NVPathRendering.nglPathGlyphIndexRangeNV(fontTarget, MemoryUtil.memAddress(fontName), fontStyle, pathParameterTemplate, emScale, baseAndCount);
    }

    public static void nglProgramPathFragmentInputGenNV(int program, int location, int genMode, int components, long coeffs) {
        long __functionAddress = NVPathRendering.getInstance().ProgramPathFragmentInputGenNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIPV(__functionAddress, program, location, genMode, components, coeffs);
    }

    public static void glProgramPathFragmentInputGenNV(int program, int location, int genMode, int components, ByteBuffer coeffs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coeffs, NVPathRendering.genModeToElements(genMode) * components << 2);
        }
        NVPathRendering.nglProgramPathFragmentInputGenNV(program, location, genMode, components, MemoryUtil.memAddress(coeffs));
    }

    public static void glProgramPathFragmentInputGenNV(int program, int location, int genMode, int components, FloatBuffer coeffs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)coeffs, NVPathRendering.genModeToElements(genMode) * components);
        }
        NVPathRendering.nglProgramPathFragmentInputGenNV(program, location, genMode, components, MemoryUtil.memAddress(coeffs));
    }

    public static void nglGetPathParameterivNV(int path, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().GetPathParameterivNV;
        JNI.callIIPV(__functionAddress, path, pname, value);
    }

    public static void glGetPathParameterivNV(int path, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglGetPathParameterivNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static void glGetPathParameterivNV(int path, int pname, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglGetPathParameterivNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static int glGetPathParameteriNV(int path, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        NVPathRendering.nglGetPathParameterivNV(path, pname, __buffer.address(value));
        return __buffer.intValue(value);
    }

    public static void nglGetPathParameterfvNV(int path, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().GetPathParameterfvNV;
        JNI.callIIPV(__functionAddress, path, pname, value);
    }

    public static void glGetPathParameterfvNV(int path, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglGetPathParameterfvNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static void glGetPathParameterfvNV(int path, int pname, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglGetPathParameterfvNV(path, pname, MemoryUtil.memAddress(value));
    }

    public static float glGetPathParameterfNV(int path, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        NVPathRendering.nglGetPathParameterfvNV(path, pname, __buffer.address(value));
        return __buffer.floatValue(value);
    }

    public static void nglGetPathCommandsNV(int path, long commands) {
        long __functionAddress = NVPathRendering.getInstance().GetPathCommandsNV;
        JNI.callIPV(__functionAddress, path, commands);
    }

    public static void glGetPathCommandsNV(int path, ByteBuffer commands) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)commands, NVPathRendering.glGetPathParameteriNV(path, 37021));
        }
        NVPathRendering.nglGetPathCommandsNV(path, MemoryUtil.memAddress(commands));
    }

    public static void nglGetPathCoordsNV(int path, long coords) {
        long __functionAddress = NVPathRendering.getInstance().GetPathCoordsNV;
        JNI.callIPV(__functionAddress, path, coords);
    }

    public static void glGetPathCoordsNV(int path, ByteBuffer coords) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)coords, NVPathRendering.glGetPathParameteriNV(path, 37022) << 2);
        }
        NVPathRendering.nglGetPathCoordsNV(path, MemoryUtil.memAddress(coords));
    }

    public static void glGetPathCoordsNV(int path, FloatBuffer coords) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)coords, NVPathRendering.glGetPathParameteriNV(path, 37022));
        }
        NVPathRendering.nglGetPathCoordsNV(path, MemoryUtil.memAddress(coords));
    }

    public static void nglGetPathDashArrayNV(int path, long dashArray) {
        long __functionAddress = NVPathRendering.getInstance().GetPathDashArrayNV;
        JNI.callIPV(__functionAddress, path, dashArray);
    }

    public static void glGetPathDashArrayNV(int path, ByteBuffer dashArray) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)dashArray, NVPathRendering.glGetPathParameteriNV(path, 37023) << 2);
        }
        NVPathRendering.nglGetPathDashArrayNV(path, MemoryUtil.memAddress(dashArray));
    }

    public static void glGetPathDashArrayNV(int path, FloatBuffer dashArray) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)dashArray, NVPathRendering.glGetPathParameteriNV(path, 37023));
        }
        NVPathRendering.nglGetPathDashArrayNV(path, MemoryUtil.memAddress(dashArray));
    }

    public static void nglGetPathMetricsNV(int metricQueryMask, int numPaths, int pathNameType, long paths, int pathBase, int stride, long metrics) {
        long __functionAddress = NVPathRendering.getInstance().GetPathMetricsNV;
        JNI.callIIIPIIPV(__functionAddress, metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics);
    }

    public static void glGetPathMetricsNV(int metricQueryMask, int numPaths, int pathNameType, ByteBuffer paths, int pathBase, int stride, ByteBuffer metrics) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)metrics, numPaths * (stride == 0 ? Integer.bitCount(metricQueryMask) : stride >> 2) << 2);
        }
        NVPathRendering.nglGetPathMetricsNV(metricQueryMask, numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, stride, MemoryUtil.memAddress(metrics));
    }

    public static void glGetPathMetricsNV(int metricQueryMask, int pathNameType, ByteBuffer paths, int pathBase, int stride, FloatBuffer metrics) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)metrics, numPaths * (stride == 0 ? Integer.bitCount(metricQueryMask) : stride >> 2));
        }
        NVPathRendering.nglGetPathMetricsNV(metricQueryMask, numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, stride, MemoryUtil.memAddress(metrics));
    }

    public static void nglGetPathMetricRangeNV(int metricQueryMask, int firstPathName, int numPaths, int stride, long metrics) {
        long __functionAddress = NVPathRendering.getInstance().GetPathMetricRangeNV;
        JNI.callIIIIPV(__functionAddress, metricQueryMask, firstPathName, numPaths, stride, metrics);
    }

    public static void glGetPathMetricRangeNV(int metricQueryMask, int firstPathName, int numPaths, int stride, ByteBuffer metrics) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)metrics, numPaths * (stride == 0 ? Integer.bitCount(metricQueryMask) : stride >> 2) << 2);
        }
        NVPathRendering.nglGetPathMetricRangeNV(metricQueryMask, firstPathName, numPaths, stride, MemoryUtil.memAddress(metrics));
    }

    public static void glGetPathMetricRangeNV(int metricQueryMask, int firstPathName, int numPaths, int stride, FloatBuffer metrics) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)metrics, numPaths * (stride == 0 ? Integer.bitCount(metricQueryMask) : stride >> 2));
        }
        NVPathRendering.nglGetPathMetricRangeNV(metricQueryMask, firstPathName, numPaths, stride, MemoryUtil.memAddress(metrics));
    }

    public static void nglGetPathSpacingNV(int pathListMode, int numPaths, int pathNameType, long paths, int pathBase, float advanceScale, float kerningScale, int transformType, long returnedSpacing) {
        long __functionAddress = NVPathRendering.getInstance().GetPathSpacingNV;
        JNI.callIIIPIFFIPV(__functionAddress, pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing);
    }

    public static void glGetPathSpacingNV(int pathListMode, int numPaths, int pathNameType, ByteBuffer paths, int pathBase, float advanceScale, float kerningScale, int transformType, ByteBuffer returnedSpacing) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)paths, numPaths * NVPathRendering.pathNameTypeToBytes(pathNameType));
            Checks.checkBuffer((Buffer)returnedSpacing, (numPaths - 1) * (transformType == 37006 ? 1 : 2) << 2);
        }
        NVPathRendering.nglGetPathSpacingNV(pathListMode, numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, advanceScale, kerningScale, transformType, MemoryUtil.memAddress(returnedSpacing));
    }

    public static void glGetPathSpacingNV(int pathListMode, int pathNameType, ByteBuffer paths, int pathBase, float advanceScale, float kerningScale, int transformType, FloatBuffer returnedSpacing) {
        int numPaths = paths.remaining() / NVPathRendering.pathNameTypeToBytes(pathNameType);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)returnedSpacing, (numPaths - 1) * (transformType == 37006 ? 1 : 2));
        }
        NVPathRendering.nglGetPathSpacingNV(pathListMode, numPaths, pathNameType, MemoryUtil.memAddress(paths), pathBase, advanceScale, kerningScale, transformType, MemoryUtil.memAddress(returnedSpacing));
    }

    public static void nglGetPathColorGenivNV(int color, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().GetPathColorGenivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, color, pname, value);
    }

    public static void glGetPathColorGenivNV(int color, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglGetPathColorGenivNV(color, pname, MemoryUtil.memAddress(value));
    }

    public static void glGetPathColorGenivNV(int color, int pname, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglGetPathColorGenivNV(color, pname, MemoryUtil.memAddress(value));
    }

    public static int glGetPathColorGeniNV(int color, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        NVPathRendering.nglGetPathColorGenivNV(color, pname, __buffer.address(value));
        return __buffer.intValue(value);
    }

    public static void nglGetPathColorGenfvNV(int color, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().GetPathColorGenfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, color, pname, value);
    }

    public static void glGetPathColorGenfvNV(int color, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglGetPathColorGenfvNV(color, pname, MemoryUtil.memAddress(value));
    }

    public static void glGetPathColorGenfvNV(int color, int pname, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglGetPathColorGenfvNV(color, pname, MemoryUtil.memAddress(value));
    }

    public static float glGetPathColorGenfNV(int color, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        NVPathRendering.nglGetPathColorGenfvNV(color, pname, __buffer.address(value));
        return __buffer.floatValue(value);
    }

    public static void nglGetPathTexGenivNV(int texCoordSet, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().GetPathTexGenivNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, texCoordSet, pname, value);
    }

    public static void glGetPathTexGenivNV(int texCoordSet, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglGetPathTexGenivNV(texCoordSet, pname, MemoryUtil.memAddress(value));
    }

    public static void glGetPathTexGenivNV(int texCoordSet, int pname, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglGetPathTexGenivNV(texCoordSet, pname, MemoryUtil.memAddress(value));
    }

    public static int glGetPathTexGeniNV(int texCoordSet, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        NVPathRendering.nglGetPathTexGenivNV(texCoordSet, pname, __buffer.address(value));
        return __buffer.intValue(value);
    }

    public static void nglGetPathTexGenfvNV(int texCoordSet, int pname, long value) {
        long __functionAddress = NVPathRendering.getInstance().GetPathTexGenfvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, texCoordSet, pname, value);
    }

    public static void glGetPathTexGenfvNV(int texCoordSet, int pname, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        NVPathRendering.nglGetPathTexGenfvNV(texCoordSet, pname, MemoryUtil.memAddress(value));
    }

    public static void glGetPathTexGenfvNV(int texCoordSet, int pname, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        NVPathRendering.nglGetPathTexGenfvNV(texCoordSet, pname, MemoryUtil.memAddress(value));
    }

    public static float glGetPathTexGenfNV(int texCoordSet, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        NVPathRendering.nglGetPathTexGenfvNV(texCoordSet, pname, __buffer.address(value));
        return __buffer.floatValue(value);
    }

    public static boolean glIsPointInFillPathNV(int path, int mask, float x, float y) {
        long __functionAddress = NVPathRendering.getInstance().IsPointInFillPathNV;
        return JNI.callIIFFZ(__functionAddress, path, mask, x, y);
    }

    public static boolean glIsPointInStrokePathNV(int path, float x, float y) {
        long __functionAddress = NVPathRendering.getInstance().IsPointInStrokePathNV;
        return JNI.callIFFZ(__functionAddress, path, x, y);
    }

    public static float glGetPathLengthNV(int path, int startSegment, int numSegments) {
        long __functionAddress = NVPathRendering.getInstance().GetPathLengthNV;
        return JNI.callIIIF(__functionAddress, path, startSegment, numSegments);
    }

    public static boolean nglPointAlongPathNV(int path, int startSegment, int numSegments, float distance, long x, long y, long tangentX, long tangentY) {
        long __functionAddress = NVPathRendering.getInstance().PointAlongPathNV;
        return JNI.callIIIFPPPPZ(__functionAddress, path, startSegment, numSegments, distance, x, y, tangentX, tangentY);
    }

    public static boolean glPointAlongPathNV(int path, int startSegment, int numSegments, float distance, ByteBuffer x, ByteBuffer y, ByteBuffer tangentX, ByteBuffer tangentY) {
        if (Checks.CHECKS) {
            if (x != null) {
                Checks.checkBuffer((Buffer)x, 4);
            }
            if (y != null) {
                Checks.checkBuffer((Buffer)y, 4);
            }
            if (tangentX != null) {
                Checks.checkBuffer((Buffer)tangentX, 4);
            }
            if (tangentY != null) {
                Checks.checkBuffer((Buffer)tangentY, 4);
            }
        }
        return NVPathRendering.nglPointAlongPathNV(path, startSegment, numSegments, distance, MemoryUtil.memAddressSafe(x), MemoryUtil.memAddressSafe(y), MemoryUtil.memAddressSafe(tangentX), MemoryUtil.memAddressSafe(tangentY));
    }

    public static boolean glPointAlongPathNV(int path, int startSegment, int numSegments, float distance, FloatBuffer x, FloatBuffer y, FloatBuffer tangentX, FloatBuffer tangentY) {
        if (Checks.CHECKS) {
            if (x != null) {
                Checks.checkBuffer((Buffer)x, 1);
            }
            if (y != null) {
                Checks.checkBuffer((Buffer)y, 1);
            }
            if (tangentX != null) {
                Checks.checkBuffer((Buffer)tangentX, 1);
            }
            if (tangentY != null) {
                Checks.checkBuffer((Buffer)tangentY, 1);
            }
        }
        return NVPathRendering.nglPointAlongPathNV(path, startSegment, numSegments, distance, MemoryUtil.memAddressSafe(x), MemoryUtil.memAddressSafe(y), MemoryUtil.memAddressSafe(tangentX), MemoryUtil.memAddressSafe(tangentY));
    }

    public static void nglMatrixLoad3x2fNV(int matrixMode, long m) {
        long __functionAddress = NVPathRendering.getInstance().MatrixLoad3x2fNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoad3x2fNV(int matrixMode, ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 24);
        }
        NVPathRendering.nglMatrixLoad3x2fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void glMatrixLoad3x2fNV(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 6);
        }
        NVPathRendering.nglMatrixLoad3x2fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixLoad3x3fNV(int matrixMode, long m) {
        long __functionAddress = NVPathRendering.getInstance().MatrixLoad3x3fNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoad3x3fNV(int matrixMode, ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 36);
        }
        NVPathRendering.nglMatrixLoad3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void glMatrixLoad3x3fNV(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 9);
        }
        NVPathRendering.nglMatrixLoad3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixLoadTranspose3x3fNV(int matrixMode, long m) {
        long __functionAddress = NVPathRendering.getInstance().MatrixLoadTranspose3x3fNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixLoadTranspose3x3fNV(int matrixMode, ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 36);
        }
        NVPathRendering.nglMatrixLoadTranspose3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void glMatrixLoadTranspose3x3fNV(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 9);
        }
        NVPathRendering.nglMatrixLoadTranspose3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixMult3x2fNV(int matrixMode, long m) {
        long __functionAddress = NVPathRendering.getInstance().MatrixMult3x2fNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMult3x2fNV(int matrixMode, ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 24);
        }
        NVPathRendering.nglMatrixMult3x2fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void glMatrixMult3x2fNV(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 6);
        }
        NVPathRendering.nglMatrixMult3x2fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixMult3x3fNV(int matrixMode, long m) {
        long __functionAddress = NVPathRendering.getInstance().MatrixMult3x3fNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMult3x3fNV(int matrixMode, ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 36);
        }
        NVPathRendering.nglMatrixMult3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void glMatrixMult3x3fNV(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 9);
        }
        NVPathRendering.nglMatrixMult3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglMatrixMultTranspose3x3fNV(int matrixMode, long m) {
        long __functionAddress = NVPathRendering.getInstance().MatrixMultTranspose3x3fNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPV(__functionAddress, matrixMode, m);
    }

    public static void glMatrixMultTranspose3x3fNV(int matrixMode, ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 36);
        }
        NVPathRendering.nglMatrixMultTranspose3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void glMatrixMultTranspose3x3fNV(int matrixMode, FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 9);
        }
        NVPathRendering.nglMatrixMultTranspose3x3fNV(matrixMode, MemoryUtil.memAddress(m));
    }

    public static void nglGetProgramResourcefvNV(int program, int programInterface, int index, int propCount, long props, int bufSize, long length, long params) {
        long __functionAddress = NVPathRendering.getInstance().GetProgramResourcefvNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIPIPPV(__functionAddress, program, programInterface, index, propCount, props, bufSize, length, params);
    }

    public static void glGetProgramResourcefvNV(int program, int programInterface, int index, int propCount, ByteBuffer props, int bufSize, ByteBuffer length, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)props, propCount << 2);
            Checks.checkBuffer((Buffer)params, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        NVPathRendering.nglGetProgramResourcefvNV(program, programInterface, index, propCount, MemoryUtil.memAddress(props), bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static void glGetProgramResourcefvNV(int program, int programInterface, int index, IntBuffer props, IntBuffer length, FloatBuffer params) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        NVPathRendering.nglGetProgramResourcefvNV(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), params.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static FloatBuffer glGetProgramResourcefvNV(int program, int programInterface, int index, IntBuffer props, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        FloatBuffer params = BufferUtils.createFloatBuffer(bufSize);
        NVPathRendering.nglGetProgramResourcefvNV(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), bufSize, __buffer.address(length), MemoryUtil.memAddress(params));
        params.limit(__buffer.intValue(length));
        return params.slice();
    }

    private static int charcodeTypeToBytes(int type) {
        switch (type) {
            case 5121: 
            case 37018: {
                return 1;
            }
            case 5123: 
            case 5127: 
            case 37019: {
                return 2;
            }
            case 5128: {
                return 3;
            }
            case 5125: 
            case 5129: {
                return 4;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported charcode type: 0x%X", type));
    }

    private static int pathNameTypeToBytes(int type) {
        switch (type) {
            case 5120: 
            case 5121: 
            case 37018: {
                return 1;
            }
            case 5122: 
            case 5123: 
            case 5127: 
            case 37019: {
                return 2;
            }
            case 5128: {
                return 3;
            }
            case 5124: 
            case 5125: 
            case 5129: {
                return 4;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported path name type: 0x%X", type));
    }

    private static int transformTypeToElements(int type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 37006: 
            case 37007: {
                return 1;
            }
            case 37008: {
                return 2;
            }
            case 37009: {
                return 3;
            }
            case 37010: 
            case 37014: {
                return 6;
            }
            case 37012: 
            case 37016: {
                return 12;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported transform type: 0x%X", type));
    }

    private static int colorFormatToComponents(int colorFormat) {
        switch (colorFormat) {
            case 6406: 
            case 6409: 
            case 32841: {
                return 1;
            }
            case 6410: {
                return 2;
            }
            case 6407: {
                return 3;
            }
            case 6408: {
                return 4;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported colorFormat specified: 0x%X", colorFormat));
    }

    private static int genModeToElements(int genMode) {
        switch (genMode) {
            case 0: {
                return 0;
            }
            case 34166: {
                return 1;
            }
            case 9217: 
            case 37002: {
                return 3;
            }
            case 9216: {
                return 4;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported genMode specified: 0x%X", genMode));
    }
}

