/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVPointSprite {
    public static final int GL_POINT_SPRITE_NV = 34913;
    public static final int GL_COORD_REPLACE_NV = 34914;
    public static final int GL_POINT_SPRITE_R_MODE_NV = 34915;
    public final long PointParameteriNV;
    public final long PointParameterivNV;

    protected NVPointSprite() {
        throw new UnsupportedOperationException();
    }

    public NVPointSprite(FunctionProvider provider) {
        this.PointParameteriNV = provider.getFunctionAddress("glPointParameteriNV");
        this.PointParameterivNV = provider.getFunctionAddress("glPointParameterivNV");
    }

    public static NVPointSprite getInstance() {
        return NVPointSprite.getInstance(GL.getCapabilities());
    }

    public static NVPointSprite getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVPointSprite);
    }

    static NVPointSprite create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_point_sprite")) {
            return null;
        }
        NVPointSprite funcs = new NVPointSprite(provider);
        boolean supported = Checks.checkFunctions(funcs.PointParameteriNV, funcs.PointParameterivNV);
        return GL.checkExtension("GL_NV_point_sprite", funcs, supported);
    }

    public static void glPointParameteriNV(int pname, int param) {
        long __functionAddress = NVPointSprite.getInstance().PointParameteriNV;
        JNI.callIIV(__functionAddress, pname, param);
    }

    public static void nglPointParameterivNV(int pname, long params) {
        long __functionAddress = NVPointSprite.getInstance().PointParameterivNV;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glPointParameterivNV(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        NVPointSprite.nglPointParameterivNV(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameterivNV(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVPointSprite.nglPointParameterivNV(pname, MemoryUtil.memAddress(params));
    }
}

