/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLAMDGPUAssociation {
    public static final int WGL_GPU_VENDOR_AMD = 7936;
    public static final int WGL_GPU_RENDERER_STRING_AMD = 7937;
    public static final int WGL_GPU_OPENGL_VERSION_STRING_AMD = 7938;
    public static final int WGL_GPU_FASTEST_TARGET_GPUS_AMD = 8610;
    public static final int WGL_GPU_RAM_AMD = 8611;
    public static final int WGL_GPU_CLOCK_AMD = 8612;
    public static final int WGL_GPU_NUM_PIPES_AMD = 8613;
    public static final int WGL_GPU_NUM_SIMD_AMD = 8614;
    public static final int WGL_GPU_NUM_RB_AMD = 8615;
    public static final int WGL_GPU_NUM_SPI_AMD = 8616;
    public final long GetGPUIDsAMD;
    public final long GetGPUInfoAMD;
    public final long GetContextGPUIDAMD;
    public final long CreateAssociatedContextAMD;
    public final long CreateAssociatedContextAttribsAMD;
    public final long DeleteAssociatedContextAMD;
    public final long MakeAssociatedContextCurrentAMD;
    public final long GetCurrentAssociatedContextAMD;
    public final long BlitContextFramebufferAMD;

    protected WGLAMDGPUAssociation() {
        throw new UnsupportedOperationException();
    }

    public WGLAMDGPUAssociation(FunctionProvider provider) {
        this.GetGPUIDsAMD = provider.getFunctionAddress("wglGetGPUIDsAMD");
        this.GetGPUInfoAMD = provider.getFunctionAddress("wglGetGPUInfoAMD");
        this.GetContextGPUIDAMD = provider.getFunctionAddress("wglGetContextGPUIDAMD");
        this.CreateAssociatedContextAMD = provider.getFunctionAddress("wglCreateAssociatedContextAMD");
        this.CreateAssociatedContextAttribsAMD = provider.getFunctionAddress("wglCreateAssociatedContextAttribsAMD");
        this.DeleteAssociatedContextAMD = provider.getFunctionAddress("wglDeleteAssociatedContextAMD");
        this.MakeAssociatedContextCurrentAMD = provider.getFunctionAddress("wglMakeAssociatedContextCurrentAMD");
        this.GetCurrentAssociatedContextAMD = provider.getFunctionAddress("wglGetCurrentAssociatedContextAMD");
        this.BlitContextFramebufferAMD = provider.getFunctionAddress("wglBlitContextFramebufferAMD");
    }

    public static WGLAMDGPUAssociation getInstance() {
        return WGLAMDGPUAssociation.getInstance(GL.getCapabilities());
    }

    public static WGLAMDGPUAssociation getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGLAMDGPUAssociation);
    }

    static WGLAMDGPUAssociation create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_AMD_gpu_association")) {
            return null;
        }
        WGLAMDGPUAssociation funcs = new WGLAMDGPUAssociation(provider);
        boolean supported = Checks.checkFunctions(funcs.GetGPUIDsAMD, funcs.GetGPUInfoAMD, funcs.GetContextGPUIDAMD, funcs.CreateAssociatedContextAMD, funcs.CreateAssociatedContextAttribsAMD, funcs.DeleteAssociatedContextAMD, funcs.MakeAssociatedContextCurrentAMD, funcs.GetCurrentAssociatedContextAMD, ext.contains("GL_EXT_framebuffer_blit") ? funcs.BlitContextFramebufferAMD : -1L);
        return GL.checkExtension("WGL_AMD_gpu_association", funcs, supported);
    }

    public static int nwglGetGPUIDsAMD(int maxCount, long ids) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().GetGPUIDsAMD;
        return JNI.callIPI(__functionAddress, maxCount, ids);
    }

    public static int wglGetGPUIDsAMD(int maxCount, ByteBuffer ids) {
        if (Checks.CHECKS && ids != null) {
            Checks.checkBuffer((Buffer)ids, maxCount << 2);
        }
        return WGLAMDGPUAssociation.nwglGetGPUIDsAMD(maxCount, MemoryUtil.memAddressSafe(ids));
    }

    public static int wglGetGPUIDsAMD(IntBuffer ids) {
        return WGLAMDGPUAssociation.nwglGetGPUIDsAMD(ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids));
    }

    public static int nwglGetGPUInfoAMD(int id, int property, int dataType, int size, long data) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().GetGPUInfoAMD;
        return JNI.callIIIIPI(__functionAddress, id, property, dataType, size, data);
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, int size, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, size << GLChecks.typeToByteShift(dataType));
        }
        return WGLAMDGPUAssociation.nwglGetGPUInfoAMD(id, property, dataType, size, MemoryUtil.memAddress(data));
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, ByteBuffer data) {
        return WGLAMDGPUAssociation.nwglGetGPUInfoAMD(id, property, dataType, data.remaining() >> GLChecks.typeToByteShift(dataType), MemoryUtil.memAddress(data));
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, IntBuffer data) {
        return WGLAMDGPUAssociation.nwglGetGPUInfoAMD(id, property, dataType, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, FloatBuffer data) {
        return WGLAMDGPUAssociation.nwglGetGPUInfoAMD(id, property, dataType, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static int wglGetContextGPUIDAMD(long hglrc) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().GetContextGPUIDAMD;
        if (Checks.CHECKS) {
            Checks.checkPointer(hglrc);
        }
        return JNI.callPI(__functionAddress, hglrc);
    }

    public static long wglCreateAssociatedContextAMD(int id) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().CreateAssociatedContextAMD;
        return JNI.callIP(__functionAddress, id);
    }

    public static long nwglCreateAssociatedContextAttribsAMD(int id, long shareContext, long attribList) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().CreateAssociatedContextAttribsAMD;
        return JNI.callIPPP(__functionAddress, id, shareContext, attribList);
    }

    public static long wglCreateAssociatedContextAttribsAMD(int id, long shareContext, ByteBuffer attribList) {
        if (Checks.CHECKS && attribList != null) {
            Checks.checkNT4(attribList);
        }
        return WGLAMDGPUAssociation.nwglCreateAssociatedContextAttribsAMD(id, shareContext, MemoryUtil.memAddressSafe(attribList));
    }

    public static long wglCreateAssociatedContextAttribsAMD(int id, long shareContext, IntBuffer attribList) {
        if (Checks.CHECKS && attribList != null) {
            Checks.checkNT(attribList);
        }
        return WGLAMDGPUAssociation.nwglCreateAssociatedContextAttribsAMD(id, shareContext, MemoryUtil.memAddressSafe(attribList));
    }

    public static int wglDeleteAssociatedContextAMD(long hglrc) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().DeleteAssociatedContextAMD;
        if (Checks.CHECKS) {
            Checks.checkPointer(hglrc);
        }
        return JNI.callPI(__functionAddress, hglrc);
    }

    public static int wglMakeAssociatedContextCurrentAMD(long hglrc) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().MakeAssociatedContextCurrentAMD;
        if (Checks.CHECKS) {
            Checks.checkPointer(hglrc);
        }
        return JNI.callPI(__functionAddress, hglrc);
    }

    public static long wglGetCurrentAssociatedContextAMD() {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().GetCurrentAssociatedContextAMD;
        return JNI.callP(__functionAddress);
    }

    public static void wglBlitContextFramebufferAMD(long dstCtx, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = WGLAMDGPUAssociation.getInstance().BlitContextFramebufferAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dstCtx);
        }
        JNI.callPIIIIIIIIIIV(__functionAddress, dstCtx, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
}

