/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ANGLEInstancedArrays {
    public static final int GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE = 35070;
    public final long DrawArraysInstancedANGLE;
    public final long DrawElementsInstancedANGLE;
    public final long VertexAttribDivisorANGLE;

    protected ANGLEInstancedArrays() {
        throw new UnsupportedOperationException();
    }

    public ANGLEInstancedArrays(FunctionProvider provider) {
        this.DrawArraysInstancedANGLE = provider.getFunctionAddress("glDrawArraysInstancedANGLE");
        this.DrawElementsInstancedANGLE = provider.getFunctionAddress("glDrawElementsInstancedANGLE");
        this.VertexAttribDivisorANGLE = provider.getFunctionAddress("glVertexAttribDivisorANGLE");
    }

    public static ANGLEInstancedArrays getInstance() {
        return ANGLEInstancedArrays.getInstance(GLES.getCapabilities());
    }

    public static ANGLEInstancedArrays getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__ANGLEInstancedArrays);
    }

    static ANGLEInstancedArrays create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ANGLE_instanced_arrays")) {
            return null;
        }
        ANGLEInstancedArrays funcs = new ANGLEInstancedArrays(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedANGLE, funcs.DrawElementsInstancedANGLE, funcs.VertexAttribDivisorANGLE);
        return GLES.checkExtension("GL_ANGLE_instanced_arrays", funcs, supported);
    }

    public static void glDrawArraysInstancedANGLE(int mode, int first, int count, int primcount) {
        long __functionAddress = ANGLEInstancedArrays.getInstance().DrawArraysInstancedANGLE;
        JNI.callIIIIV(__functionAddress, mode, first, count, primcount);
    }

    public static void nglDrawElementsInstancedANGLE(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = ANGLEInstancedArrays.getInstance().DrawElementsInstancedANGLE;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, int count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, count, type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, int count, int type, long indicesOffset, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, count, type, indicesOffset, primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedANGLE(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        ANGLEInstancedArrays.nglDrawElementsInstancedANGLE(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glVertexAttribDivisorANGLE(int index, int divisor) {
        long __functionAddress = ANGLEInstancedArrays.getInstance().VertexAttribDivisorANGLE;
        JNI.callIIV(__functionAddress, index, divisor);
    }
}

