/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTBaseInstance {
    public final long DrawArraysInstancedBaseInstanceEXT;
    public final long DrawElementsInstancedBaseInstanceEXT;
    public final long DrawElementsInstancedBaseVertexBaseInstanceEXT;

    protected EXTBaseInstance() {
        throw new UnsupportedOperationException();
    }

    public EXTBaseInstance(FunctionProvider provider) {
        this.DrawArraysInstancedBaseInstanceEXT = provider.getFunctionAddress("glDrawArraysInstancedBaseInstanceEXT");
        this.DrawElementsInstancedBaseInstanceEXT = provider.getFunctionAddress("glDrawElementsInstancedBaseInstanceEXT");
        this.DrawElementsInstancedBaseVertexBaseInstanceEXT = provider.getFunctionAddress("glDrawElementsInstancedBaseVertexBaseInstanceEXT");
    }

    public static EXTBaseInstance getInstance() {
        return EXTBaseInstance.getInstance(GLES.getCapabilities());
    }

    public static EXTBaseInstance getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTBaseInstance);
    }

    static EXTBaseInstance create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_base_instance")) {
            return null;
        }
        EXTBaseInstance funcs = new EXTBaseInstance(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedBaseInstanceEXT, funcs.DrawElementsInstancedBaseInstanceEXT, funcs.DrawElementsInstancedBaseVertexBaseInstanceEXT);
        return GLES.checkExtension("GL_EXT_base_instance", funcs, supported);
    }

    public static void glDrawArraysInstancedBaseInstanceEXT(int mode, int first, int count, int instancecount, int baseinstance) {
        long __functionAddress = EXTBaseInstance.getInstance().DrawArraysInstancedBaseInstanceEXT;
        JNI.callIIIIIV(__functionAddress, mode, first, count, instancecount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseInstanceEXT(int mode, int count, int type, long indices, int instancecount, int baseinstance) {
        long __functionAddress = EXTBaseInstance.getInstance().DrawElementsInstancedBaseInstanceEXT;
        JNI.callIIIPIIV(__functionAddress, mode, count, type, indices, instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, int count, int type, ByteBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, count, type, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, int count, int type, long indicesOffset, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, count, type, indicesOffset, instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, int type, ByteBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, ByteBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, ShortBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, IntBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, int count, int type, long indices, int instancecount, int basevertex, int baseinstance) {
        long __functionAddress = EXTBaseInstance.getInstance().DrawElementsInstancedBaseVertexBaseInstanceEXT;
        JNI.callIIIPIIIV(__functionAddress, mode, count, type, indices, instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, int count, int type, ByteBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, count, type, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, int count, int type, long indicesOffset, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, count, type, indicesOffset, instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, int type, ByteBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, ByteBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, ShortBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, IntBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }
}

