/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTDrawElementsBaseVertex {
    public final long DrawElementsBaseVertexEXT;
    public final long DrawRangeElementsBaseVertexEXT;
    public final long DrawElementsInstancedBaseVertexEXT;
    public final long MultiDrawElementsBaseVertexEXT;

    protected EXTDrawElementsBaseVertex() {
        throw new UnsupportedOperationException();
    }

    public EXTDrawElementsBaseVertex(FunctionProvider provider) {
        this.DrawElementsBaseVertexEXT = provider.getFunctionAddress("glDrawElementsBaseVertexEXT");
        this.DrawRangeElementsBaseVertexEXT = provider.getFunctionAddress("glDrawRangeElementsBaseVertexEXT");
        this.DrawElementsInstancedBaseVertexEXT = provider.getFunctionAddress("glDrawElementsInstancedBaseVertexEXT");
        this.MultiDrawElementsBaseVertexEXT = provider.getFunctionAddress("glMultiDrawElementsBaseVertexEXT");
    }

    public static EXTDrawElementsBaseVertex getInstance() {
        return EXTDrawElementsBaseVertex.getInstance(GLES.getCapabilities());
    }

    public static EXTDrawElementsBaseVertex getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDrawElementsBaseVertex);
    }

    static EXTDrawElementsBaseVertex create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_draw_elements_base_vertex")) {
            return null;
        }
        EXTDrawElementsBaseVertex funcs = new EXTDrawElementsBaseVertex(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawElementsBaseVertexEXT, ext.contains("GLES30") ? funcs.DrawRangeElementsBaseVertexEXT : -1L, ext.contains("GLES30") ? funcs.DrawElementsInstancedBaseVertexEXT : -1L, ext.contains("GL_EXT_multi_draw_arrays") ? funcs.MultiDrawElementsBaseVertexEXT : -1L);
        return GLES.checkExtension("GL_EXT_draw_elements_base_vertex", funcs, supported);
    }

    public static void nglDrawElementsBaseVertexEXT(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = EXTDrawElementsBaseVertex.getInstance().DrawElementsBaseVertexEXT;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, count, type, indicesOffset, basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(int mode, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = EXTDrawElementsBaseVertex.getInstance().DrawRangeElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIPIV(__functionAddress, mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, count, type, indicesOffset, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawElementsInstancedBaseVertexEXT(int mode, int count, int type, long indices, int instancecount, int basevertex) {
        long __functionAddress = EXTDrawElementsBaseVertex.getInstance().DrawElementsInstancedBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPIIV(__functionAddress, mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, int count, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, count, type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, int count, int type, long indicesOffset, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, count, type, indicesOffset, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, int type, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, ByteBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, ShortBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(int mode, IntBuffer indices, int instancecount, int basevertex) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void nglMultiDrawElementsBaseVertexEXT(int mode, long count, int type, long indices, int primcount, long basevertex) {
        long __functionAddress = EXTDrawElementsBaseVertex.getInstance().MultiDrawElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPIPIPV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glMultiDrawElementsBaseVertexEXT(int mode, ByteBuffer count, int type, ByteBuffer indices, int primcount, ByteBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, primcount << 2);
            Checks.checkBuffer((Buffer)indices, primcount << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)basevertex, primcount << 2);
        }
        EXTDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), primcount, MemoryUtil.memAddress(basevertex));
    }

    public static void glMultiDrawElementsBaseVertexEXT(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
            Checks.checkBuffer((Buffer)basevertex, count.remaining());
        }
        EXTDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }
}

