/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class OESTexture3D {
    public static final int GL_TEXTURE_3D_OES = 32879;
    public static final int GL_TEXTURE_WRAP_R_OES = 32882;
    public static final int GL_MAX_3D_TEXTURE_SIZE_OES = 32883;
    public static final int GL_TEXTURE_BINDING_3D_OES = 32874;
    public final long TexImage3DOES;
    public final long TexSubImage3DOES;
    public final long CopyTexSubImage3DOES;
    public final long CompressedTexImage3DOES;
    public final long CompressedTexSubImage3DOES;
    public final long FramebufferTexture3DOES;

    protected OESTexture3D() {
        throw new UnsupportedOperationException();
    }

    public OESTexture3D(FunctionProvider provider) {
        this.TexImage3DOES = provider.getFunctionAddress("glTexImage3DOES");
        this.TexSubImage3DOES = provider.getFunctionAddress("glTexSubImage3DOES");
        this.CopyTexSubImage3DOES = provider.getFunctionAddress("glCopyTexSubImage3DOES");
        this.CompressedTexImage3DOES = provider.getFunctionAddress("glCompressedTexImage3DOES");
        this.CompressedTexSubImage3DOES = provider.getFunctionAddress("glCompressedTexSubImage3DOES");
        this.FramebufferTexture3DOES = provider.getFunctionAddress("glFramebufferTexture3DOES");
    }

    public static OESTexture3D getInstance() {
        return OESTexture3D.getInstance(GLES.getCapabilities());
    }

    public static OESTexture3D getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__OESTexture3D);
    }

    static OESTexture3D create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_OES_texture_3D")) {
            return null;
        }
        OESTexture3D funcs = new OESTexture3D(provider);
        boolean supported = Checks.checkFunctions(funcs.TexImage3DOES, funcs.TexSubImage3DOES, funcs.CopyTexSubImage3DOES, funcs.CompressedTexImage3DOES, funcs.CompressedTexSubImage3DOES, funcs.FramebufferTexture3DOES);
        return GLES.checkExtension("GL_OES_texture_3D", funcs, supported);
    }

    public static void nglTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        long __functionAddress = OESTexture3D.getInstance().TexImage3DOES;
        JNI.callIIIIIIIIIPV(__functionAddress, target, level, internalformat, width, height, depth, border, format, type, pixels);
    }

    public static void glTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        OESTexture3D.nglTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, pixelsOffset);
    }

    public static void glTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void nglTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = OESTexture3D.getInstance().TexSubImage3DOES;
        JNI.callIIIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        OESTexture3D.nglTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixelsOffset);
    }

    public static void glTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glCopyTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = OESTexture3D.getInstance().CopyTexSubImage3DOES;
        JNI.callIIIIIIIIIV(__functionAddress, target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    public static void nglCompressedTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        long __functionAddress = OESTexture3D.getInstance().CompressedTexImage3DOES;
        JNI.callIIIIIIIIPV(__functionAddress, target, level, internalformat, width, height, depth, border, imageSize, data);
    }

    public static void glCompressedTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            if (data != null) {
                Checks.checkBuffer((Buffer)data, imageSize);
            }
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglCompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, imageSize, MemoryUtil.memAddressSafe(data));
    }

    public static void glCompressedTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        OESTexture3D.nglCompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, imageSize, dataOffset);
    }

    public static void glCompressedTexImage3DOES(int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglCompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, data == null ? 0 : data.remaining(), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = OESTexture3D.getInstance().CompressedTexSubImage3DOES;
        JNI.callIIIIIIIIIIPV(__functionAddress, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglCompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        OESTexture3D.nglCompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataOffset);
    }

    public static void glCompressedTexSubImage3DOES(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        OESTexture3D.nglCompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glFramebufferTexture3DOES(int target, int attachment, int textarget, int texture, int level, int zoffset) {
        long __functionAddress = OESTexture3D.getInstance().FramebufferTexture3DOES;
        JNI.callIIIIIIV(__functionAddress, target, attachment, textarget, texture, level, zoffset);
    }
}

