/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class QCOMDriverControl {
    public final long GetDriverControlsQCOM;
    public final long GetDriverControlStringQCOM;
    public final long EnableDriverControlQCOM;
    public final long DisableDriverControlQCOM;

    protected QCOMDriverControl() {
        throw new UnsupportedOperationException();
    }

    public QCOMDriverControl(FunctionProvider provider) {
        this.GetDriverControlsQCOM = provider.getFunctionAddress("glGetDriverControlsQCOM");
        this.GetDriverControlStringQCOM = provider.getFunctionAddress("glGetDriverControlStringQCOM");
        this.EnableDriverControlQCOM = provider.getFunctionAddress("glEnableDriverControlQCOM");
        this.DisableDriverControlQCOM = provider.getFunctionAddress("glDisableDriverControlQCOM");
    }

    public static QCOMDriverControl getInstance() {
        return QCOMDriverControl.getInstance(GLES.getCapabilities());
    }

    public static QCOMDriverControl getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__QCOMDriverControl);
    }

    static QCOMDriverControl create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_QCOM_driver_control")) {
            return null;
        }
        QCOMDriverControl funcs = new QCOMDriverControl(provider);
        boolean supported = Checks.checkFunctions(funcs.GetDriverControlsQCOM, funcs.GetDriverControlStringQCOM, funcs.EnableDriverControlQCOM, funcs.DisableDriverControlQCOM);
        return GLES.checkExtension("GL_QCOM_driver_control", funcs, supported);
    }

    public static void nglGetDriverControlsQCOM(long num, int size, long driverControls) {
        long __functionAddress = QCOMDriverControl.getInstance().GetDriverControlsQCOM;
        JNI.callPIPV(__functionAddress, num, size, driverControls);
    }

    public static void glGetDriverControlsQCOM(ByteBuffer num, int size, ByteBuffer driverControls) {
        if (Checks.CHECKS) {
            if (num != null) {
                Checks.checkBuffer((Buffer)num, 4);
            }
            if (driverControls != null) {
                Checks.checkBuffer((Buffer)driverControls, size << 2);
            }
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.memAddressSafe(num), size, MemoryUtil.memAddressSafe(driverControls));
    }

    public static void glGetDriverControlsQCOM(IntBuffer num, IntBuffer driverControls) {
        if (Checks.CHECKS && num != null) {
            Checks.checkBuffer((Buffer)num, 1);
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.memAddressSafe(num), driverControls == null ? 0 : driverControls.remaining(), MemoryUtil.memAddressSafe(driverControls));
    }

    public static void nglGetDriverControlStringQCOM(int driverControl, int bufSize, long length, long driverControlString) {
        long __functionAddress = QCOMDriverControl.getInstance().GetDriverControlStringQCOM;
        JNI.callIIPPV(__functionAddress, driverControl, bufSize, length, driverControlString);
    }

    public static void glGetDriverControlStringQCOM(int driverControl, int bufSize, ByteBuffer length, ByteBuffer driverControlString) {
        if (Checks.CHECKS) {
            if (driverControlString != null) {
                Checks.checkBuffer((Buffer)driverControlString, bufSize);
            }
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(driverControlString));
    }

    public static void glGetDriverControlStringQCOM(int driverControl, IntBuffer length, ByteBuffer driverControlString) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, driverControlString == null ? 0 : driverControlString.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(driverControlString));
    }

    public static String glGetDriverControlStringQCOM(int driverControl, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int driverControlString = __buffer.bufferParam(bufSize);
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, bufSize, __buffer.address(length), __buffer.address(driverControlString));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), driverControlString);
    }

    public static void glEnableDriverControlQCOM(int driverControl) {
        long __functionAddress = QCOMDriverControl.getInstance().EnableDriverControlQCOM;
        JNI.callIV(__functionAddress, driverControl);
    }

    public static void glDisableDriverControlQCOM(int driverControl) {
        long __functionAddress = QCOMDriverControl.getInstance().DisableDriverControlQCOM;
        JNI.callIV(__functionAddress, driverControl);
    }
}

