/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRTextureHeader;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRGLTextureData
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HEADER;
    public static final int TEXID;

    OVRGLTextureData(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRGLTextureData(long struct) {
        this(struct, null);
    }

    public OVRGLTextureData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRTextureHeader Header() {
        return OVRGLTextureData.nHeader(this.address());
    }

    public int TexId() {
        return OVRGLTextureData.nTexId(this.address());
    }

    public OVRGLTextureData Header(OVRTextureHeader value) {
        OVRGLTextureData.nHeader(this.address(), value);
        return this;
    }

    public OVRGLTextureData TexId(int value) {
        OVRGLTextureData.nTexId(this.address(), value);
        return this;
    }

    public OVRGLTextureData set(OVRTextureHeader Header2, int TexId) {
        this.Header(Header2);
        this.TexId(TexId);
        return this;
    }

    public OVRGLTextureData nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRGLTextureData set(OVRGLTextureData src) {
        return this.nset(src.address());
    }

    public OVRGLTextureData set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRGLTextureData malloc() {
        return new OVRGLTextureData(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRGLTextureData calloc() {
        return new OVRGLTextureData(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRGLTextureData create() {
        return new OVRGLTextureData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRTextureHeader nHeader(long struct) {
        return new OVRTextureHeader(struct + (long)HEADER);
    }

    public static int nTexId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXID);
    }

    public static void nHeader(long struct, OVRTextureHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRTextureHeader.SIZEOF);
    }

    public static void nTexId(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEXID, value);
    }

    static {
        Struct.Layout layout = OVRGLTextureData.__struct(OVRGLTextureData.__member(OVRTextureHeader.SIZEOF, OVRTextureHeader.__ALIGNMENT), OVRGLTextureData.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HEADER = layout.offsetof(0);
        TEXID = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRGLTextureData, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRGLTextureData newInstance(long address) {
            return new OVRGLTextureData(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRTextureHeader Header() {
            return OVRGLTextureData.nHeader(this.address());
        }

        public int TexId() {
            return OVRGLTextureData.nTexId(this.address());
        }

        public Buffer Header(OVRTextureHeader value) {
            OVRGLTextureData.nHeader(this.address(), value);
            return this;
        }

        public Buffer TexId(int value) {
            OVRGLTextureData.nTexId(this.address(), value);
            return this;
        }
    }
}

