/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRVector2i;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRRecti
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int POS;
    public static final int SIZE;

    OVRRecti(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRRecti(long struct) {
        this(struct, null);
    }

    public OVRRecti(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRVector2i Pos() {
        return OVRRecti.nPos(this.address());
    }

    public OVRSizei Size() {
        return OVRRecti.nSize(this.address());
    }

    public OVRRecti Pos(OVRVector2i value) {
        OVRRecti.nPos(this.address(), value);
        return this;
    }

    public OVRRecti Size(OVRSizei value) {
        OVRRecti.nSize(this.address(), value);
        return this;
    }

    public OVRRecti set(OVRVector2i Pos2, OVRSizei Size2) {
        this.Pos(Pos2);
        this.Size(Size2);
        return this;
    }

    public OVRRecti nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRRecti set(OVRRecti src) {
        return this.nset(src.address());
    }

    public OVRRecti set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRRecti malloc() {
        return new OVRRecti(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRRecti calloc() {
        return new OVRRecti(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRRecti create() {
        return new OVRRecti(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRVector2i nPos(long struct) {
        return new OVRVector2i(struct + (long)POS);
    }

    public static OVRSizei nSize(long struct) {
        return new OVRSizei(struct + (long)SIZE);
    }

    public static void nPos(long struct, OVRVector2i value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POS, OVRVector2i.SIZEOF);
    }

    public static void nSize(long struct, OVRSizei value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SIZE, OVRSizei.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRRecti.__struct(OVRRecti.__member(OVRVector2i.SIZEOF, OVRVector2i.__ALIGNMENT), OVRRecti.__member(OVRSizei.SIZEOF, OVRSizei.__ALIGNMENT));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        POS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRRecti, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRRecti newInstance(long address) {
            return new OVRRecti(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRVector2i Pos() {
            return OVRRecti.nPos(this.address());
        }

        public OVRSizei Size() {
            return OVRRecti.nSize(this.address());
        }

        public Buffer Pos(OVRVector2i value) {
            OVRRecti.nPos(this.address(), value);
            return this;
        }

        public Buffer Size(OVRSizei value) {
            OVRRecti.nSize(this.address(), value);
            return this;
        }
    }
}

