/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTPackedchar;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTPackRange
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int FONT_SIZE;
    public static final int FIRST_UNICODE_CODEPOINT_IN_RANGE;
    public static final int ARRAY_OF_UNICODE_CODEPOINTS;
    public static final int NUM_CHARS;
    public static final int CHARDATA_FOR_RANGE;

    STBTTPackRange(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBTTPackRange(long struct) {
        this(struct, null);
    }

    public STBTTPackRange(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float font_size() {
        return STBTTPackRange.nfont_size(this.address());
    }

    public int first_unicode_codepoint_in_range() {
        return STBTTPackRange.nfirst_unicode_codepoint_in_range(this.address());
    }

    public IntBuffer array_of_unicode_codepoints(int capacity) {
        return STBTTPackRange.narray_of_unicode_codepoints(this.address(), capacity);
    }

    public int num_chars() {
        return STBTTPackRange.nnum_chars(this.address());
    }

    public STBTTPackedchar chardata_for_range() {
        return STBTTPackRange.nchardata_for_rangeStruct(this.address());
    }

    public static STBTTPackRange malloc() {
        return new STBTTPackRange(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTPackRange calloc() {
        return new STBTTPackRange(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTPackRange create() {
        return new STBTTPackRange(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static float nfont_size(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FONT_SIZE);
    }

    public static int nfirst_unicode_codepoint_in_range(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRST_UNICODE_CODEPOINT_IN_RANGE);
    }

    public static IntBuffer narray_of_unicode_codepoints(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)ARRAY_OF_UNICODE_CODEPOINTS), capacity);
    }

    public static int nnum_chars(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_CHARS);
    }

    public static STBTTPackedchar nchardata_for_rangeStruct(long struct) {
        return new STBTTPackedchar(MemoryUtil.memGetAddress(struct + (long)CHARDATA_FOR_RANGE));
    }

    static {
        Struct.Layout layout = STBTTPackRange.__struct(STBTTPackRange.__member(4), STBTTPackRange.__member(4), STBTTPackRange.__member(Pointer.POINTER_SIZE), STBTTPackRange.__member(4), STBTTPackRange.__member(Pointer.POINTER_SIZE), STBTTPackRange.__padding(2, true));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        FONT_SIZE = layout.offsetof(0);
        FIRST_UNICODE_CODEPOINT_IN_RANGE = layout.offsetof(1);
        ARRAY_OF_UNICODE_CODEPOINTS = layout.offsetof(2);
        NUM_CHARS = layout.offsetof(3);
        CHARDATA_FOR_RANGE = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<STBTTPackRange, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBTTPackRange newInstance(long address) {
            return new STBTTPackRange(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float font_size() {
            return STBTTPackRange.nfont_size(this.address());
        }

        public int first_unicode_codepoint_in_range() {
            return STBTTPackRange.nfirst_unicode_codepoint_in_range(this.address());
        }

        public IntBuffer array_of_unicode_codepoints(int capacity) {
            return STBTTPackRange.narray_of_unicode_codepoints(this.address(), capacity);
        }

        public int num_chars() {
            return STBTTPackRange.nnum_chars(this.address());
        }

        public STBTTPackedchar chardata_for_range() {
            return STBTTPackRange.nchardata_for_rangeStruct(this.address());
        }
    }
}

