/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTPackedchar
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X0;
    public static final int Y0;
    public static final int X1;
    public static final int Y1;
    public static final int XOFF;
    public static final int YOFF;
    public static final int XADVANCE;
    public static final int XOFF2;
    public static final int YOFF2;

    STBTTPackedchar(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBTTPackedchar(long struct) {
        this(struct, null);
    }

    public STBTTPackedchar(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x0() {
        return STBTTPackedchar.nx0(this.address());
    }

    public short y0() {
        return STBTTPackedchar.ny0(this.address());
    }

    public short x1() {
        return STBTTPackedchar.nx1(this.address());
    }

    public short y1() {
        return STBTTPackedchar.ny1(this.address());
    }

    public float xoff() {
        return STBTTPackedchar.nxoff(this.address());
    }

    public float yoff() {
        return STBTTPackedchar.nyoff(this.address());
    }

    public float xadvance() {
        return STBTTPackedchar.nxadvance(this.address());
    }

    public float xoff2() {
        return STBTTPackedchar.nxoff2(this.address());
    }

    public float yoff2() {
        return STBTTPackedchar.nyoff2(this.address());
    }

    public static STBTTPackedchar malloc() {
        return new STBTTPackedchar(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTPackedchar calloc() {
        return new STBTTPackedchar(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTPackedchar create() {
        return new STBTTPackedchar(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static short nx0(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X0);
    }

    public static short ny0(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y0);
    }

    public static short nx1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X1);
    }

    public static short ny1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y1);
    }

    public static float nxoff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XOFF);
    }

    public static float nyoff(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YOFF);
    }

    public static float nxadvance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XADVANCE);
    }

    public static float nxoff2(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XOFF2);
    }

    public static float nyoff2(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YOFF2);
    }

    static {
        Struct.Layout layout = STBTTPackedchar.__struct(STBTTPackedchar.__member(2), STBTTPackedchar.__member(2), STBTTPackedchar.__member(2), STBTTPackedchar.__member(2), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4), STBTTPackedchar.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        X1 = layout.offsetof(2);
        Y1 = layout.offsetof(3);
        XOFF = layout.offsetof(4);
        YOFF = layout.offsetof(5);
        XADVANCE = layout.offsetof(6);
        XOFF2 = layout.offsetof(7);
        YOFF2 = layout.offsetof(8);
    }

    public static final class Buffer
    extends StructBuffer<STBTTPackedchar, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBTTPackedchar newInstance(long address) {
            return new STBTTPackedchar(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public short x0() {
            return STBTTPackedchar.nx0(this.address());
        }

        public short y0() {
            return STBTTPackedchar.ny0(this.address());
        }

        public short x1() {
            return STBTTPackedchar.nx1(this.address());
        }

        public short y1() {
            return STBTTPackedchar.ny1(this.address());
        }

        public float xoff() {
            return STBTTPackedchar.nxoff(this.address());
        }

        public float yoff() {
            return STBTTPackedchar.nyoff(this.address());
        }

        public float xadvance() {
            return STBTTPackedchar.nxadvance(this.address());
        }

        public float xoff2() {
            return STBTTPackedchar.nxoff2(this.address());
        }

        public float yoff2() {
            return STBTTPackedchar.nyoff2(this.address());
        }
    }
}

