/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryTextUtil;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;
import sun.reflect.FieldAccessor;

final class MemoryAccess {
    private MemoryAccess() {
    }

    static MemoryAccessor getInstance() {
        MemoryAccessor accessor;
        try {
            accessor = (MemoryAccessor)Class.forName("org.lwjgl.system.MemoryAccess$MemoryAccessorUnsafe").newInstance();
        }
        catch (Throwable t0) {
            try {
                accessor = new MemoryAccessorReflect();
            }
            catch (Throwable t1) {
                APIUtil.apiLog("[MemoryAccessor] Unsupported JVM detected, this will likely result in low performance. Please inform LWJGL developers.");
                accessor = new MemoryAccessorJNI();
            }
        }
        return accessor;
    }

    private static native void memset(long var0, int var2, long var3);

    private static native void memcpy(long var0, long var2, long var4);

    private static native byte getByte(long var0);

    private static native short getShort(long var0);

    private static native int getInt(long var0);

    private static native long getLong(long var0);

    private static native float getFloat(long var0);

    private static native double getDouble(long var0);

    private static native long getAddress(long var0);

    private static native void putByte(long var0, byte var2);

    private static native void putShort(long var0, short var2);

    private static native void putInt(long var0, int var2);

    private static native void putLong(long var0, long var2);

    private static native void putFloat(long var0, float var2);

    private static native void putDouble(long var0, double var2);

    private static native void putAddress(long var0, long var2);

    static native int getPointerSize();

    static native long getDirectBufferAddress(Buffer var0);

    static native ByteBuffer newDirectByteBuffer(long var0, int var2);

    static Field getDeclaredField(Class<?> root, String fieldName) throws NoSuchFieldException {
        Class<?> type = root;
        while (true) {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                if ((type = type.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(fieldName + " does not exist in " + root.getSimpleName() + " or any of its superclasses.");
            }
            break;
        }
    }

    static Field getField(Buffer buffer, Object value) throws NoSuchFieldException {
        Class<?> type = buffer.getClass();
        do {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !field.getType().isAssignableFrom(value.getClass())) continue;
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(buffer);
                    if (fieldValue != value) continue;
                    return field;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        } while ((type = type.getSuperclass()) != null);
        throw new NoSuchFieldException(String.format("The specified value does not exist as a field in %s or any of its superclasses.", buffer.getClass().getSimpleName()));
    }

    static FieldAccessor getFieldAccessor(Field field) {
        try {
            Method getFieldAccessor = Field.class.getDeclaredMethod("getFieldAccessor", Object.class);
            getFieldAccessor.setAccessible(true);
            return (FieldAccessor)getFieldAccessor.invoke((Object)field, new Object[]{null});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Library.initialize();
    }

    private static final class MemoryAccessorUnsafe
    extends MemoryAccessorJava {
        private static final long BULK_OP_THRESHOLD = 0x100000L;
        private static final Unsafe UNSAFE;
        private static final long ADDRESS;
        private static final long CAPACITY;
        private static final long PARENT_BYTE;
        private static final long PARENT_SHORT;
        private static final long PARENT_CHAR;
        private static final long PARENT_INT;
        private static final long PARENT_LONG;
        private static final long PARENT_FLOAT;
        private static final long PARENT_DOUBLE;

        MemoryAccessorUnsafe() {
        }

        @Override
        int getPageSize() {
            return UNSAFE.pageSize();
        }

        @Override
        public long memAddress0(Buffer buffer) {
            return UNSAFE.getLong(buffer, ADDRESS);
        }

        @Override
        ByteBuffer memByteBuffer(long address, int capacity) {
            try {
                ByteBuffer buffer = (ByteBuffer)UNSAFE.allocateInstance(BYTE_BUFFER.getClass());
                buffer.order(ByteOrder.nativeOrder());
                return this.memSetupBuffer(buffer, address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        ShortBuffer memShortBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((ShortBuffer)UNSAFE.allocateInstance(SHORT_BUFFER.getClass()), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        CharBuffer memCharBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((CharBuffer)UNSAFE.allocateInstance(CHAR_BUFFER.getClass()), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        IntBuffer memIntBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((IntBuffer)UNSAFE.allocateInstance(INT_BUFFER.getClass()), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        LongBuffer memLongBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((LongBuffer)UNSAFE.allocateInstance(LONG_BUFFER.getClass()), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        FloatBuffer memFloatBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((FloatBuffer)UNSAFE.allocateInstance(FLOAT_BUFFER.getClass()), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        DoubleBuffer memDoubleBuffer(long address, int capacity) {
            try {
                return this.memSetupBuffer((DoubleBuffer)UNSAFE.allocateInstance(DOUBLE_BUFFER.getClass()), address, capacity);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        private static <T extends Buffer> T setup(T buffer, long address, int capacity, long parentField) {
            UNSAFE.putLong(buffer, ADDRESS, address);
            UNSAFE.putInt(buffer, CAPACITY, capacity);
            UNSAFE.putObject(buffer, parentField, null);
            buffer.clear();
            return buffer;
        }

        @Override
        public ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
            if (Checks.DEBUG && ((DirectBuffer)((Object)buffer)).cleaner() != null) {
                throw new IllegalArgumentException("Instances created through ByteBuffer.allocateDirect cannot be modified.");
            }
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_BYTE);
        }

        @Override
        ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_SHORT);
        }

        @Override
        CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_CHAR);
        }

        @Override
        IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_INT);
        }

        @Override
        LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_LONG);
        }

        @Override
        FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_FLOAT);
        }

        @Override
        DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return MemoryAccessorUnsafe.setup(buffer, address, capacity, PARENT_DOUBLE);
        }

        @Override
        void memSet(long dst, int value, int bytes) {
            while (true) {
                long batchSize = 0x100000L < (long)bytes ? 0x100000L : (long)bytes;
                UNSAFE.setMemory(dst, batchSize, (byte)(value & 0xFF));
                bytes = (int)((long)bytes - 0x100000L);
                if (bytes < 0) break;
                dst += 0x100000L;
            }
        }

        @Override
        void memCopy(long src, long dst, int bytes) {
            while (true) {
                long batchSize = 0x100000L < (long)bytes ? 0x100000L : (long)bytes;
                UNSAFE.copyMemory(src, dst, batchSize);
                bytes = (int)((long)bytes - 0x100000L);
                if (bytes < 0) break;
                src += 0x100000L;
                dst += 0x100000L;
            }
        }

        @Override
        byte memGetByte(long ptr) {
            return UNSAFE.getByte(ptr);
        }

        @Override
        short memGetShort(long ptr) {
            return UNSAFE.getShort(ptr);
        }

        @Override
        int memGetInt(long ptr) {
            return UNSAFE.getInt(ptr);
        }

        @Override
        long memGetLong(long ptr) {
            return UNSAFE.getLong(ptr);
        }

        @Override
        float memGetFloat(long ptr) {
            return UNSAFE.getFloat(ptr);
        }

        @Override
        double memGetDouble(long ptr) {
            return UNSAFE.getDouble(ptr);
        }

        @Override
        long memGetAddress(long ptr) {
            return UNSAFE.getAddress(ptr);
        }

        @Override
        void memPutByte(long ptr, byte value) {
            UNSAFE.putByte(ptr, value);
        }

        @Override
        void memPutShort(long ptr, short value) {
            UNSAFE.putShort(ptr, value);
        }

        @Override
        void memPutInt(long ptr, int value) {
            UNSAFE.putInt(ptr, value);
        }

        @Override
        void memPutLong(long ptr, long value) {
            UNSAFE.putLong(ptr, value);
        }

        @Override
        void memPutFloat(long ptr, float value) {
            UNSAFE.putFloat(ptr, value);
        }

        @Override
        void memPutDouble(long ptr, double value) {
            UNSAFE.putDouble(ptr, value);
        }

        @Override
        void memPutAddress(long ptr, long value) {
            UNSAFE.putAddress(ptr, value);
        }

        @Override
        MemoryTextUtil getTextUtil() {
            return new MemoryTextUtil(){

                @Override
                int encodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                    return this.encodeASCII(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
                }

                private int encodeASCII(CharSequence text, boolean nullTerminated, long target) {
                    int p;
                    int len = text.length();
                    for (p = 0; p < len; ++p) {
                        MemoryAccessorUnsafe.this.memPutByte(target + (long)p, (byte)text.charAt(p));
                    }
                    if (nullTerminated) {
                        MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)0);
                    }
                    return p;
                }

                @Override
                int encodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                    return this.encodeUTF8(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
                }

                private int encodeUTF8(CharSequence text, boolean nullTerminated, long target) {
                    int c;
                    int i;
                    int len = text.length();
                    int p = 0;
                    for (i = 0; i < len && (c = text.charAt(i)) < 128; ++i) {
                        MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)c);
                    }
                    while (i < len) {
                        if ((c = text.charAt(i++)) < 128) {
                            MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)c);
                            continue;
                        }
                        int cp = c;
                        if (c < 2048) {
                            MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)(0xC0 | cp >> 6));
                        } else {
                            if (!Character.isHighSurrogate((char)c)) {
                                MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)(0xE0 | cp >> 12));
                            } else {
                                cp = Character.toCodePoint((char)c, text.charAt(i++));
                                MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)(0xF0 | cp >> 18));
                                MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)(0x80 | cp >> 12 & 0x3F));
                            }
                            MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)(0x80 | cp >> 6 & 0x3F));
                        }
                        MemoryAccessorUnsafe.this.memPutByte(target + (long)p++, (byte)(0x80 | cp & 0x3F));
                    }
                    if (nullTerminated) {
                        MemoryAccessorUnsafe.this.memPutByte(target + (long)p, (byte)0);
                    }
                    return p;
                }

                @Override
                int encodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                    return this.encodeUTF16(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
                }

                private int encodeUTF16(CharSequence text, boolean nullTerminated, long target) {
                    int p = 0;
                    int len = text.length();
                    int i = 0;
                    while (i < len) {
                        MemoryAccessorUnsafe.this.memPutShort(target + (long)p, (short)text.charAt(i));
                        ++i;
                        p += 2;
                    }
                    if (nullTerminated) {
                        MemoryAccessorUnsafe.this.memPutShort(target + (long)p, (short)0);
                        p += 2;
                    }
                    return p;
                }
            };
        }

        private static Unsafe getUnsafeInstance() {
            Field[] fields;
            for (Field field : fields = Unsafe.class.getDeclaredFields()) {
                int modifiers;
                if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }

        static {
            ByteBuffer parent = BYTE_BUFFER;
            if (!(parent instanceof DirectBuffer)) {
                throw new UnsupportedOperationException();
            }
            try {
                UNSAFE = MemoryAccessorUnsafe.getUnsafeInstance();
                ADDRESS = UNSAFE.objectFieldOffset(MemoryAccess.getDeclaredField(Buffer.class, "address"));
                CAPACITY = UNSAFE.objectFieldOffset(MemoryAccess.getDeclaredField(Buffer.class, "capacity"));
                PARENT_BYTE = UNSAFE.objectFieldOffset(MemoryAccess.getField(BYTE_BUFFER.slice(), parent));
                PARENT_SHORT = UNSAFE.objectFieldOffset(MemoryAccess.getField(SHORT_BUFFER, parent));
                PARENT_CHAR = UNSAFE.objectFieldOffset(MemoryAccess.getField(CHAR_BUFFER, parent));
                PARENT_INT = UNSAFE.objectFieldOffset(MemoryAccess.getField(INT_BUFFER, parent));
                PARENT_LONG = UNSAFE.objectFieldOffset(MemoryAccess.getField(LONG_BUFFER, parent));
                PARENT_FLOAT = UNSAFE.objectFieldOffset(MemoryAccess.getField(FLOAT_BUFFER, parent));
                PARENT_DOUBLE = UNSAFE.objectFieldOffset(MemoryAccess.getField(DOUBLE_BUFFER, parent));
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    private static final class MemoryAccessorReflect
    extends MemoryAccessorJava {
        private static final FieldAccessor ADDRESS;
        private static final FieldAccessor CAPACITY;
        private static final FieldAccessor PARENT_BYTE;
        private static final FieldAccessor PARENT_SHORT;
        private static final FieldAccessor PARENT_CHAR;
        private static final FieldAccessor PARENT_INT;
        private static final FieldAccessor PARENT_LONG;
        private static final FieldAccessor PARENT_FLOAT;
        private static final FieldAccessor PARENT_DOUBLE;

        MemoryAccessorReflect() {
        }

        @Override
        public long memAddress0(Buffer buffer) {
            return ((DirectBuffer)((Object)buffer)).address();
        }

        private static <T extends Buffer> T setup(T buffer, long address, int capacity, FieldAccessor parentField) {
            try {
                ADDRESS.setLong(buffer, address);
                CAPACITY.setInt(buffer, capacity);
                parentField.set(buffer, null);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
            buffer.clear();
            return buffer;
        }

        @Override
        ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
            if (Checks.DEBUG && ((DirectBuffer)((Object)buffer)).cleaner() != null) {
                throw new IllegalArgumentException("Instances created through ByteBuffer.allocateDirect cannot be modified.");
            }
            return MemoryAccessorReflect.setup(buffer, address, capacity, PARENT_BYTE);
        }

        @Override
        ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
            return MemoryAccessorReflect.setup(buffer, address, capacity, PARENT_SHORT);
        }

        @Override
        CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
            return MemoryAccessorReflect.setup(buffer, address, capacity, PARENT_CHAR);
        }

        @Override
        IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
            return MemoryAccessorReflect.setup(buffer, address, capacity, PARENT_INT);
        }

        @Override
        LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
            return MemoryAccessorReflect.setup(buffer, address, capacity, PARENT_LONG);
        }

        @Override
        FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
            return MemoryAccessorReflect.setup(buffer, address, capacity, PARENT_FLOAT);
        }

        @Override
        DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return MemoryAccessorReflect.setup(buffer, address, capacity, PARENT_DOUBLE);
        }

        static {
            ByteBuffer parent = BYTE_BUFFER;
            if (!(parent instanceof DirectBuffer)) {
                throw new UnsupportedOperationException();
            }
            try {
                ADDRESS = MemoryAccess.getFieldAccessor(MemoryAccess.getDeclaredField(Buffer.class, "address"));
                CAPACITY = MemoryAccess.getFieldAccessor(MemoryAccess.getDeclaredField(Buffer.class, "capacity"));
                PARENT_BYTE = MemoryAccess.getFieldAccessor(MemoryAccess.getField(parent.slice(), parent));
                PARENT_SHORT = MemoryAccess.getFieldAccessor(MemoryAccess.getField(SHORT_BUFFER, parent));
                PARENT_CHAR = MemoryAccess.getFieldAccessor(MemoryAccess.getField(CHAR_BUFFER, parent));
                PARENT_INT = MemoryAccess.getFieldAccessor(MemoryAccess.getField(INT_BUFFER, parent));
                PARENT_LONG = MemoryAccess.getFieldAccessor(MemoryAccess.getField(LONG_BUFFER, parent));
                PARENT_FLOAT = MemoryAccess.getFieldAccessor(MemoryAccess.getField(FLOAT_BUFFER, parent));
                PARENT_DOUBLE = MemoryAccess.getFieldAccessor(MemoryAccess.getField(DOUBLE_BUFFER, parent));
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    static abstract class MemoryAccessorJava
    extends MemoryAccessor {
        protected static final ByteBuffer BYTE_BUFFER = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
        protected static final ShortBuffer SHORT_BUFFER = BYTE_BUFFER.asShortBuffer();
        protected static final CharBuffer CHAR_BUFFER = BYTE_BUFFER.asCharBuffer();
        protected static final IntBuffer INT_BUFFER = BYTE_BUFFER.asIntBuffer();
        protected static final LongBuffer LONG_BUFFER = BYTE_BUFFER.asLongBuffer();
        protected static final FloatBuffer FLOAT_BUFFER = BYTE_BUFFER.asFloatBuffer();
        protected static final DoubleBuffer DOUBLE_BUFFER = BYTE_BUFFER.asDoubleBuffer();

        MemoryAccessorJava() {
        }

        @Override
        ByteBuffer memByteBuffer(long address, int capacity) {
            return this.memSetupBuffer(BYTE_BUFFER.slice().order(ByteOrder.nativeOrder()), address, capacity);
        }

        @Override
        ShortBuffer memShortBuffer(long address, int capacity) {
            return this.memSetupBuffer(SHORT_BUFFER.slice(), address, capacity);
        }

        @Override
        CharBuffer memCharBuffer(long address, int capacity) {
            return this.memSetupBuffer(CHAR_BUFFER.slice(), address, capacity);
        }

        @Override
        IntBuffer memIntBuffer(long address, int capacity) {
            return this.memSetupBuffer(INT_BUFFER.slice(), address, capacity);
        }

        @Override
        LongBuffer memLongBuffer(long address, int capacity) {
            return this.memSetupBuffer(LONG_BUFFER.slice(), address, capacity);
        }

        @Override
        FloatBuffer memFloatBuffer(long address, int capacity) {
            return this.memSetupBuffer(FLOAT_BUFFER.slice(), address, capacity);
        }

        @Override
        DoubleBuffer memDoubleBuffer(long address, int capacity) {
            return this.memSetupBuffer(DOUBLE_BUFFER.slice(), address, capacity);
        }
    }

    private static final class MemoryAccessorJNI
    extends MemoryAccessor {
        private MemoryAccessorJNI() {
        }

        @Override
        long memAddress0(Buffer buffer) {
            return MemoryAccess.getDirectBufferAddress(buffer);
        }

        @Override
        ByteBuffer memByteBuffer(long address, int capacity) {
            return MemoryAccess.newDirectByteBuffer(address, capacity).order(ByteOrder.nativeOrder());
        }

        @Override
        ShortBuffer memShortBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 1).asShortBuffer();
        }

        @Override
        CharBuffer memCharBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 1).asCharBuffer();
        }

        @Override
        IntBuffer memIntBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 2).asIntBuffer();
        }

        @Override
        LongBuffer memLongBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 3).asLongBuffer();
        }

        @Override
        FloatBuffer memFloatBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 2).asFloatBuffer();
        }

        @Override
        DoubleBuffer memDoubleBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 3).asDoubleBuffer();
        }

        @Override
        ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
            return this.memByteBuffer(address, capacity);
        }

        @Override
        ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
            return this.memShortBuffer(address, capacity);
        }

        @Override
        CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
            return this.memCharBuffer(address, capacity);
        }

        @Override
        IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
            return this.memIntBuffer(address, capacity);
        }

        @Override
        LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
            return this.memLongBuffer(address, capacity);
        }

        @Override
        FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
            return this.memFloatBuffer(address, capacity);
        }

        @Override
        DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return this.memDoubleBuffer(address, capacity);
        }
    }

    static abstract class MemoryAccessor {
        MemoryAccessor() {
        }

        int getPageSize() {
            return 4096;
        }

        int getCacheLineSize() {
            return 64;
        }

        abstract long memAddress0(Buffer var1);

        abstract ByteBuffer memByteBuffer(long var1, int var3);

        abstract ShortBuffer memShortBuffer(long var1, int var3);

        abstract CharBuffer memCharBuffer(long var1, int var3);

        abstract IntBuffer memIntBuffer(long var1, int var3);

        abstract LongBuffer memLongBuffer(long var1, int var3);

        abstract FloatBuffer memFloatBuffer(long var1, int var3);

        abstract DoubleBuffer memDoubleBuffer(long var1, int var3);

        abstract ByteBuffer memSetupBuffer(ByteBuffer var1, long var2, int var4);

        abstract ShortBuffer memSetupBuffer(ShortBuffer var1, long var2, int var4);

        abstract CharBuffer memSetupBuffer(CharBuffer var1, long var2, int var4);

        abstract IntBuffer memSetupBuffer(IntBuffer var1, long var2, int var4);

        abstract LongBuffer memSetupBuffer(LongBuffer var1, long var2, int var4);

        abstract FloatBuffer memSetupBuffer(FloatBuffer var1, long var2, int var4);

        abstract DoubleBuffer memSetupBuffer(DoubleBuffer var1, long var2, int var4);

        void memSet(long dst, int value, int bytes) {
            MemoryAccess.memset(dst, value, bytes);
        }

        void memCopy(long src, long dst, int bytes) {
            MemoryAccess.memcpy(dst, src, bytes);
        }

        byte memGetByte(long ptr) {
            return MemoryAccess.getByte(ptr);
        }

        short memGetShort(long ptr) {
            return MemoryAccess.getShort(ptr);
        }

        int memGetInt(long ptr) {
            return MemoryAccess.getInt(ptr);
        }

        long memGetLong(long ptr) {
            return MemoryAccess.getLong(ptr);
        }

        float memGetFloat(long ptr) {
            return MemoryAccess.getFloat(ptr);
        }

        double memGetDouble(long ptr) {
            return MemoryAccess.getDouble(ptr);
        }

        long memGetAddress(long ptr) {
            return MemoryAccess.getAddress(ptr);
        }

        void memPutByte(long ptr, byte value) {
            MemoryAccess.putByte(ptr, value);
        }

        void memPutShort(long ptr, short value) {
            MemoryAccess.putShort(ptr, value);
        }

        void memPutInt(long ptr, int value) {
            MemoryAccess.putInt(ptr, value);
        }

        void memPutLong(long ptr, long value) {
            MemoryAccess.putLong(ptr, value);
        }

        void memPutFloat(long ptr, float value) {
            MemoryAccess.putFloat(ptr, value);
        }

        void memPutDouble(long ptr, double value) {
            MemoryAccess.putDouble(ptr, value);
        }

        void memPutAddress(long ptr, long value) {
            MemoryAccess.putAddress(ptr, value);
        }

        MemoryTextUtil getTextUtil() {
            return new MemoryTextUtil();
        }
    }
}

