/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryAccess;
import org.lwjgl.system.MemoryManage;
import org.lwjgl.system.MemoryTextUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.StructBuffer;

public final class MemoryUtil {
    public static final long NULL = 0L;
    static final MemoryAccess.MemoryAccessor ACCESSOR;
    static final MemoryTextUtil TEXT_UTIL;
    private static final MemoryAllocator ALLOCATOR_IMPL;
    private static final MemoryAllocator ALLOCATOR;
    public static final int PAGE_SIZE;
    public static final int CACHE_LINE_SIZE;

    private MemoryUtil() {
    }

    public static MemoryAllocator getAllocator() {
        return ALLOCATOR_IMPL;
    }

    public static long nmemAlloc(long size) {
        return ALLOCATOR.malloc(size);
    }

    public static ByteBuffer memAlloc(int size) {
        return MemoryUtil.memByteBuffer(MemoryUtil.nmemAlloc(size), size);
    }

    public static ShortBuffer memAllocShort(int size) {
        return MemoryUtil.memShortBuffer(MemoryUtil.nmemAlloc(size << 1), size);
    }

    public static IntBuffer memAllocInt(int size) {
        return MemoryUtil.memIntBuffer(MemoryUtil.nmemAlloc(size << 2), size);
    }

    public static FloatBuffer memAllocFloat(int size) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.nmemAlloc(size << 2), size);
    }

    public static LongBuffer memAllocLong(int size) {
        return MemoryUtil.memLongBuffer(MemoryUtil.nmemAlloc(size << 3), size);
    }

    public static DoubleBuffer memAllocDouble(int size) {
        return MemoryUtil.memDoubleBuffer(MemoryUtil.nmemAlloc(size << 3), size);
    }

    public static PointerBuffer memAllocPointer(int size) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.nmemAlloc(size << Pointer.POINTER_SHIFT), size);
    }

    public static void nmemFree(long ptr) {
        ALLOCATOR.free(ptr);
    }

    public static void memFree(Buffer ptr) {
        MemoryUtil.nmemFree(MemoryUtil.memAddress0Safe(ptr));
    }

    public static void memFree(PointerBuffer ptr) {
        MemoryUtil.nmemFree(MemoryUtil.memAddress0Safe(ptr));
    }

    public static void memFree(StructBuffer<?, ?> ptr) {
        MemoryUtil.nmemFree(MemoryUtil.memAddress0Safe(ptr));
    }

    public static long nmemCalloc(long num, long size) {
        return ALLOCATOR.calloc(num, size);
    }

    public static ByteBuffer memCalloc(int num, int size) {
        return MemoryUtil.memByteBuffer(MemoryUtil.nmemCalloc(num, size), num * size);
    }

    public static ByteBuffer memCalloc(int num) {
        return MemoryUtil.memByteBuffer(MemoryUtil.nmemCalloc(num, 1L), num);
    }

    public static ShortBuffer memCallocShort(int num) {
        return MemoryUtil.memShortBuffer(MemoryUtil.nmemCalloc(num, 2L), num);
    }

    public static IntBuffer memCallocInt(int num) {
        return MemoryUtil.memIntBuffer(MemoryUtil.nmemCalloc(num, 4L), num);
    }

    public static FloatBuffer memCallocFloat(int num) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.nmemCalloc(num, 4L), num);
    }

    public static LongBuffer memCallocLong(int num) {
        return MemoryUtil.memLongBuffer(MemoryUtil.nmemCalloc(num, 8L), num);
    }

    public static DoubleBuffer memCallocDouble(int num) {
        return MemoryUtil.memDoubleBuffer(MemoryUtil.nmemCalloc(num, 8L), num);
    }

    public static PointerBuffer memCallocPointer(int num) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.nmemCalloc(num, Pointer.POINTER_SIZE), num);
    }

    public static long nmemRealloc(long ptr, long size) {
        return ALLOCATOR.realloc(ptr, size);
    }

    public static ByteBuffer memRealloc(ByteBuffer ptr, int size) {
        if (ptr == null) {
            return MemoryUtil.memByteBuffer(MemoryUtil.nmemRealloc(0L, size), size);
        }
        int position = Math.min(ptr.position(), size);
        ByteBuffer buffer = MemoryUtil.memSetupBuffer(ptr, MemoryUtil.nmemRealloc(MemoryUtil.memAddress0(ptr), size), size);
        if (buffer != null) {
            buffer.position(position);
        }
        return buffer;
    }

    public static ShortBuffer memRealloc(ShortBuffer ptr, int size) {
        if (ptr == null) {
            return MemoryUtil.memShortBuffer(MemoryUtil.nmemRealloc(0L, size << 1), size);
        }
        int position = Math.min(ptr.position(), size);
        ShortBuffer buffer = MemoryUtil.memSetupBuffer(ptr, MemoryUtil.nmemRealloc(MemoryUtil.memAddress0(ptr), size << 1), size);
        if (buffer != null) {
            buffer.position(position);
        }
        return buffer;
    }

    public static IntBuffer memRealloc(IntBuffer ptr, int size) {
        if (ptr == null) {
            return MemoryUtil.memIntBuffer(MemoryUtil.nmemRealloc(0L, size << 2), size);
        }
        int position = Math.min(ptr.position(), size);
        IntBuffer buffer = MemoryUtil.memSetupBuffer(ptr, MemoryUtil.nmemRealloc(MemoryUtil.memAddress0(ptr), size << 2), size);
        if (buffer != null) {
            buffer.position(position);
        }
        return buffer;
    }

    public static FloatBuffer memRealloc(FloatBuffer ptr, int size) {
        if (ptr == null) {
            return MemoryUtil.memFloatBuffer(MemoryUtil.nmemRealloc(0L, size << 2), size);
        }
        int position = Math.min(ptr.position(), size);
        FloatBuffer buffer = MemoryUtil.memSetupBuffer(ptr, MemoryUtil.nmemRealloc(MemoryUtil.memAddress0(ptr), size << 2), size);
        if (buffer != null) {
            buffer.position(position);
        }
        return buffer;
    }

    public static LongBuffer memRealloc(LongBuffer ptr, int size) {
        if (ptr == null) {
            return MemoryUtil.memLongBuffer(MemoryUtil.nmemRealloc(0L, size << 3), size);
        }
        int position = Math.min(ptr.position(), size);
        LongBuffer buffer = MemoryUtil.memSetupBuffer(ptr, MemoryUtil.nmemRealloc(MemoryUtil.memAddress0(ptr), size << 3), size);
        if (buffer != null) {
            buffer.position(position);
        }
        return buffer;
    }

    public static DoubleBuffer memRealloc(DoubleBuffer ptr, int size) {
        if (ptr == null) {
            return MemoryUtil.memDoubleBuffer(MemoryUtil.nmemRealloc(0L, size << 3), size);
        }
        int position = Math.min(ptr.position(), size);
        DoubleBuffer buffer = MemoryUtil.memSetupBuffer(ptr, MemoryUtil.nmemRealloc(MemoryUtil.memAddress0(ptr), size << 3), size);
        if (buffer != null) {
            buffer.position(position);
        }
        return buffer;
    }

    public static PointerBuffer memRealloc(PointerBuffer ptr, int size) {
        if (ptr == null) {
            return MemoryUtil.memPointerBuffer(MemoryUtil.nmemRealloc(0L, size << Pointer.POINTER_SHIFT), size);
        }
        int position = Math.min(ptr.position(), size);
        PointerBuffer buffer = MemoryUtil.memSetupBuffer(ptr, MemoryUtil.nmemRealloc(MemoryUtil.memAddress0(ptr), size << Pointer.POINTER_SHIFT), size);
        if (buffer != null) {
            buffer.position(position);
        }
        return buffer;
    }

    public static long nmemAlignedAlloc(long alignment, long size) {
        return ALLOCATOR.aligned_alloc(alignment, size);
    }

    public static ByteBuffer memAlignedAlloc(int alignment, int size) {
        return MemoryUtil.memByteBuffer(ALLOCATOR.aligned_alloc(alignment, size), size);
    }

    public static void nmemAlignedFree(long ptr) {
        ALLOCATOR.aligned_free(ptr);
    }

    public static void memAlignedFree(ByteBuffer ptr) {
        MemoryUtil.nmemAlignedFree(MemoryUtil.memAddress0Safe(ptr));
    }

    public static void memReport(MemoryAllocationReport report) {
        MemoryManage.DebugAllocator.report(report);
    }

    public static void memReport(MemoryAllocationReport report, MemoryAllocationReport.Aggregate groupByStackTrace, boolean groupByThread) {
        MemoryManage.DebugAllocator.report(report, groupByStackTrace, groupByThread);
    }

    public static long memAddress0(Buffer buffer) {
        return ACCESSOR.memAddress0(buffer);
    }

    public static long memAddress0Safe(Buffer buffer) {
        return buffer == null ? 0L : ACCESSOR.memAddress0(buffer);
    }

    public static long memAddress0(PointerBuffer buffer) {
        return buffer.address0();
    }

    public static long memAddress0Safe(PointerBuffer buffer) {
        return buffer == null ? 0L : buffer.address0();
    }

    public static long memAddress0(StructBuffer<?, ?> buffer) {
        return buffer.address0();
    }

    public static long memAddress0Safe(StructBuffer<?, ?> buffer) {
        return buffer == null ? 0L : buffer.address0();
    }

    public static long memAddress(ByteBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ByteBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)position;
    }

    public static long memAddress(ShortBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ShortBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 1);
    }

    public static long memAddress(CharBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(CharBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 1);
    }

    public static long memAddress(IntBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(IntBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 2);
    }

    public static long memAddress(FloatBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(FloatBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 2);
    }

    public static long memAddress(LongBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(LongBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 3);
    }

    public static long memAddress(DoubleBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(DoubleBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 3);
    }

    public static long memAddress(PointerBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(PointerBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << Pointer.POINTER_SHIFT);
    }

    public static long memAddress(StructBuffer<?, ?> buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(StructBuffer<?, ?> buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position * buffer.sizeof());
    }

    public static long memAddressSafe(ByteBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(ByteBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(ShortBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(ShortBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(CharBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(CharBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(IntBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(IntBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(FloatBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(FloatBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(LongBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(LongBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(DoubleBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(DoubleBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(PointerBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(PointerBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(StructBuffer<?, ?> buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(StructBuffer<?, ?> buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static ByteBuffer memByteBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memByteBuffer(address, capacity);
    }

    public static ByteBuffer memByteBufferNT1(long address) {
        return MemoryUtil.memByteBufferNT1(address, Integer.MAX_VALUE);
    }

    public static ByteBuffer memByteBufferNT1(long address, int maxLength) {
        if (address == 0L) {
            return null;
        }
        ByteBuffer string = ACCESSOR.memByteBuffer(address, maxLength);
        return MemoryUtil.memSetupBuffer(string, address, MemoryUtil.memStrLen1(string, 0));
    }

    public static ByteBuffer memByteBufferNT2(long address) {
        return MemoryUtil.memByteBufferNT2(address, Integer.MAX_VALUE);
    }

    public static ByteBuffer memByteBufferNT2(long address, int maxLength) {
        if (address == 0L) {
            return null;
        }
        ByteBuffer string = ACCESSOR.memByteBuffer(address, maxLength);
        return MemoryUtil.memSetupBuffer(string, address, MemoryUtil.memStrLen2(string, 0) << 1);
    }

    public static ShortBuffer memShortBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        if (Checks.DEBUG && (address & 1L) != 0L) {
            throw new IllegalArgumentException("Unaligned memory address");
        }
        return ACCESSOR.memShortBuffer(address, capacity);
    }

    public static CharBuffer memCharBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        if (Checks.DEBUG && (address & 1L) != 0L) {
            throw new IllegalArgumentException("Unaligned memory address");
        }
        return ACCESSOR.memCharBuffer(address, capacity);
    }

    public static IntBuffer memIntBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        if (Checks.DEBUG && (address & 3L) != 0L) {
            throw new IllegalArgumentException("Unaligned memory address");
        }
        return ACCESSOR.memIntBuffer(address, capacity);
    }

    public static LongBuffer memLongBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        if (Checks.DEBUG && (address & 7L) != 0L) {
            throw new IllegalArgumentException("Unaligned memory address");
        }
        return ACCESSOR.memLongBuffer(address, capacity);
    }

    public static FloatBuffer memFloatBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        if (Checks.DEBUG && (address & 3L) != 0L) {
            throw new IllegalArgumentException("Unaligned memory address");
        }
        return ACCESSOR.memFloatBuffer(address, capacity);
    }

    public static DoubleBuffer memDoubleBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        if (Checks.DEBUG && (address & 7L) != 0L) {
            throw new IllegalArgumentException("Unaligned memory address");
        }
        return ACCESSOR.memDoubleBuffer(address, capacity);
    }

    public static PointerBuffer memPointerBuffer(long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return PointerBuffer.create(address, capacity);
    }

    public static ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memSetupBuffer(buffer, address, capacity);
    }

    public static ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memSetupBuffer(buffer, address, capacity);
    }

    public static CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memSetupBuffer(buffer, address, capacity);
    }

    public static IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memSetupBuffer(buffer, address, capacity);
    }

    public static LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memSetupBuffer(buffer, address, capacity);
    }

    public static FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memSetupBuffer(buffer, address, capacity);
    }

    public static DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return ACCESSOR.memSetupBuffer(buffer, address, capacity);
    }

    public static PointerBuffer memSetupBuffer(PointerBuffer buffer, long address, int capacity) {
        if (address == 0L) {
            return null;
        }
        return PointerBuffer.setup(buffer, address, capacity);
    }

    public static ByteBuffer memSlice(ByteBuffer buffer) {
        return buffer.slice().order(buffer.order());
    }

    public static ByteBuffer memSlice(ByteBuffer buffer, int capacity) {
        return MemoryUtil.memSlice(buffer, 0, capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer memSlice(ByteBuffer buffer, int offset, int capacity) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(position + offset);
            buffer.limit(position + offset + capacity);
            ByteBuffer byteBuffer = MemoryUtil.memSlice(buffer);
            return byteBuffer;
        }
        finally {
            buffer.position(position);
            buffer.limit(limit);
        }
    }

    public static void memSet(long ptr, int value, int bytes) {
        if (Checks.DEBUG && (ptr == 0L || bytes < 0)) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memSet(ptr, value, bytes);
    }

    public static void memCopy(long src, long dst, int bytes) {
        if (Checks.DEBUG && (src == 0L || dst == 0L || bytes < 0)) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memCopy(src, dst, bytes);
    }

    public static boolean memGetBoolean(long ptr) {
        return ACCESSOR.memGetByte(ptr) != 0;
    }

    public static byte memGetByte(long ptr) {
        return ACCESSOR.memGetByte(ptr);
    }

    public static short memGetShort(long ptr) {
        return ACCESSOR.memGetShort(ptr);
    }

    public static int memGetInt(long ptr) {
        return ACCESSOR.memGetInt(ptr);
    }

    public static long memGetLong(long ptr) {
        return ACCESSOR.memGetLong(ptr);
    }

    public static float memGetFloat(long ptr) {
        return ACCESSOR.memGetFloat(ptr);
    }

    public static double memGetDouble(long ptr) {
        return ACCESSOR.memGetDouble(ptr);
    }

    public static long memGetAddress(long ptr) {
        return ACCESSOR.memGetAddress(ptr);
    }

    public static void memPutByte(long ptr, byte value) {
        ACCESSOR.memPutByte(ptr, value);
    }

    public static void memPutShort(long ptr, short value) {
        ACCESSOR.memPutShort(ptr, value);
    }

    public static void memPutInt(long ptr, int value) {
        ACCESSOR.memPutInt(ptr, value);
    }

    public static void memPutLong(long ptr, long value) {
        ACCESSOR.memPutLong(ptr, value);
    }

    public static void memPutFloat(long ptr, float value) {
        ACCESSOR.memPutFloat(ptr, value);
    }

    public static void memPutDouble(long ptr, double value) {
        ACCESSOR.memPutDouble(ptr, value);
    }

    public static void memPutAddress(long ptr, long value) {
        ACCESSOR.memPutAddress(ptr, value);
    }

    public static native <T> T memGlobalRefToObject(long var0);

    public static native long memNewGlobalRef(Object var0);

    public static native void memDeleteGlobalRef(long var0);

    public static native long memNewWeakGlobalRef(Object var0);

    public static native void memDeleteWeakGlobalRef(long var0);

    public static ByteBuffer memEncodeASCII(CharSequence text) {
        return MemoryUtil.memEncodeASCII(text, BufferAllocator.NIO);
    }

    public static ByteBuffer memEncodeASCII(CharSequence text, BufferAllocator allocator) {
        return MemoryUtil.memEncodeASCII(text, true, allocator);
    }

    public static ByteBuffer memEncodeASCII(CharSequence text, boolean nullTerminated) {
        return MemoryUtil.memEncodeASCII(text, nullTerminated, BufferAllocator.NIO);
    }

    public static ByteBuffer memEncodeASCII(CharSequence text, boolean nullTerminated, BufferAllocator allocator) {
        if (text == null) {
            return null;
        }
        ByteBuffer target = allocator.allocate(text.length() + (nullTerminated ? 1 : 0));
        MemoryUtil.memEncodeASCII(text, nullTerminated, target);
        return target;
    }

    public static int memEncodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memEncodeASCII(text, nullTerminated, target, target.position());
    }

    public static int memEncodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        return TEXT_UTIL.encodeASCII(text, nullTerminated, target, offset);
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text) {
        return MemoryUtil.memEncodeUTF8(text, BufferAllocator.NIO);
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text, BufferAllocator allocator) {
        return MemoryUtil.memEncodeUTF8(text, true, allocator);
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text, boolean nullTerminated) {
        return MemoryUtil.memEncodeUTF8(text, nullTerminated, BufferAllocator.NIO);
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text, boolean nullTerminated, BufferAllocator allocator) {
        if (text == null) {
            return null;
        }
        ByteBuffer target = allocator.allocate(MemoryUtil.memEncodedLengthUTF8(text) + (nullTerminated ? 1 : 0));
        MemoryUtil.memEncodeUTF8(text, nullTerminated, target);
        return target;
    }

    public static int memEncodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memEncodeUTF8(text, nullTerminated, target, target.position());
    }

    public static int memEncodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        return TEXT_UTIL.encodeUTF8(text, nullTerminated, target, offset);
    }

    public static int memEncodedLengthUTF8(CharSequence value) {
        return MemoryTextUtil.encodeUTF8Length(value);
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text) {
        return MemoryUtil.memEncodeUTF16(text, BufferAllocator.NIO);
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text, BufferAllocator allocator) {
        return MemoryUtil.memEncodeUTF16(text, true, allocator);
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text, boolean nullTerminated) {
        return MemoryUtil.memEncodeUTF16(text, nullTerminated, BufferAllocator.NIO);
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text, boolean nullTerminated, BufferAllocator allocator) {
        if (text == null) {
            return null;
        }
        ByteBuffer target = allocator.allocate(text.length() + (nullTerminated ? 1 : 0) << 1);
        MemoryUtil.memEncodeUTF16(text, nullTerminated, target);
        return target;
    }

    public static int memEncodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        return MemoryUtil.memEncodeUTF16(text, nullTerminated, target, target.position());
    }

    public static int memEncodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        return TEXT_UTIL.encodeUTF16(text, nullTerminated, target, offset);
    }

    public static int memStrLen1(ByteBuffer buffer) {
        return MemoryUtil.memStrLen1(buffer, buffer.position());
    }

    public static int memStrLen1(ByteBuffer buffer, int from) {
        int to;
        for (to = from; to < buffer.limit() && buffer.get(to) != 0; ++to) {
        }
        return to - from;
    }

    public static int memStrLen2(ByteBuffer buffer) {
        return MemoryUtil.memStrLen2(buffer, buffer.position());
    }

    public static int memStrLen2(ByteBuffer buffer, int from) {
        int to;
        for (to = from; to < buffer.limit() && (buffer.get(to) != 0 || to >= buffer.limit() - 1 || buffer.get(to + 1) != 0); to += 2) {
        }
        return to - from >> 1;
    }

    public static String memDecodeASCII(long address) {
        return address == 0L ? null : MemoryUtil.memDecodeASCII(MemoryUtil.memByteBufferNT1(address));
    }

    public static String memDecodeASCII(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.memDecodeASCII(buffer, buffer.remaining());
    }

    public static String memDecodeASCII(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeASCII(buffer, length, buffer.position());
    }

    public static String memDecodeASCII(ByteBuffer buffer, int length, int offset) {
        return MemoryTextUtil.decodeASCII(buffer, length, offset);
    }

    public static String memDecodeUTF8(long address) {
        return address == 0L ? null : MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBufferNT1(address));
    }

    public static String memDecodeUTF8(ByteBuffer buffer) {
        return MemoryUtil.memDecodeUTF8(buffer, buffer.remaining());
    }

    public static String memDecodeUTF8(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeUTF8(buffer, length, buffer.position());
    }

    public static String memDecodeUTF8(ByteBuffer buffer, int length, int offset) {
        return MemoryTextUtil.decodeUTF8(buffer, length, offset);
    }

    public static String memDecodeUTF16(long address) {
        return address == 0L ? null : MemoryUtil.memDecodeUTF16(MemoryUtil.memByteBufferNT2(address));
    }

    public static String memDecodeUTF16(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.memDecodeUTF16(buffer, buffer.remaining() >> 1);
    }

    public static String memDecodeUTF16(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeUTF16(buffer, length, buffer.position());
    }

    public static String memDecodeUTF16(ByteBuffer buffer, int length, int offset) {
        return MemoryTextUtil.decodeUTF16(buffer, length, offset);
    }

    static {
        Library.initialize();
        ACCESSOR = MemoryAccess.getInstance();
        TEXT_UTIL = ACCESSOR.getTextUtil();
        PAGE_SIZE = ACCESSOR.getPageSize();
        CACHE_LINE_SIZE = ACCESSOR.getCacheLineSize();
        APIUtil.apiLog("MemoryUtil accessor: " + ACCESSOR.getClass().getSimpleName());
        ALLOCATOR_IMPL = MemoryManage.getInstance();
        ALLOCATOR = (Boolean)Configuration.DEBUG_MEMORY_ALLOCATOR.get() != false ? new MemoryManage.DebugAllocator(ALLOCATOR_IMPL) : ALLOCATOR_IMPL;
        APIUtil.apiLog("MemoryUtil allocator: " + ALLOCATOR.getClass().getSimpleName());
    }

    public static interface MemoryAllocationReport {
        public void invoke(long var1, long var3, String var5, StackTraceElement ... var6);

        public static enum Aggregate {
            ALL,
            GROUP_BY_METHOD,
            GROUP_BY_STACKTRACE;

        }
    }

    public static enum BufferAllocator {
        NIO{

            @Override
            public ByteBuffer allocate(int size) {
                return BufferUtils.createByteBuffer(size);
            }
        }
        ,
        MALLOC{

            @Override
            public ByteBuffer allocate(int size) {
                return MemoryUtil.memAlloc(size);
            }
        };


        public abstract ByteBuffer allocate(int var1);
    }

    public static interface MemoryAllocator {
        public long malloc(long var1);

        public long calloc(long var1, long var3);

        public long realloc(long var1, long var3);

        public void free(long var1);

        public long aligned_alloc(long var1, long var3);

        public void aligned_free(long var1);
    }
}

