/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.Checks;

public interface Retainable {
    public void retain();

    public void release();

    public static abstract class Default
    implements Retainable {
        private int refCount = 1;

        @Override
        public void retain() {
            if (Checks.DEBUG && this.refCount == 0) {
                throw new IllegalStateException("This object has been released already.");
            }
            ++this.refCount;
        }

        @Override
        public void release() {
            if (Checks.DEBUG && this.refCount == 0) {
                throw new IllegalStateException("This object has been released already.");
            }
            if (--this.refCount == 0) {
                this.destroy();
            }
        }

        protected abstract void destroy();
    }
}

