/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FFIType
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int TYPE;
    public static final int ELEMENTS;

    FFIType(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public FFIType(long struct) {
        this(struct, null);
    }

    public FFIType(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long size() {
        return FFIType.nsize(this.address());
    }

    public short alignment() {
        return FFIType.nalignment(this.address());
    }

    public short type() {
        return FFIType.ntype(this.address());
    }

    public PointerBuffer elements(int capacity) {
        return FFIType.nelements(this.address(), capacity);
    }

    public FFIType size(long value) {
        FFIType.nsize(this.address(), value);
        return this;
    }

    public FFIType alignment(short value) {
        FFIType.nalignment(this.address(), value);
        return this;
    }

    public FFIType type(short value) {
        FFIType.ntype(this.address(), value);
        return this;
    }

    public FFIType elements(PointerBuffer value) {
        FFIType.nelements(this.address(), value);
        return this;
    }

    public FFIType set(long size, short alignment, short type, PointerBuffer elements) {
        this.size(size);
        this.alignment(alignment);
        this.type(type);
        this.elements(elements);
        return this;
    }

    public FFIType nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public FFIType set(FFIType src) {
        return this.nset(src.address());
    }

    public FFIType set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static FFIType malloc() {
        return new FFIType(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static FFIType calloc() {
        return new FFIType(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static FFIType create() {
        return new FFIType(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static short nalignment(long struct) {
        return MemoryUtil.memGetShort(struct + (long)ALIGNMENT);
    }

    public static short ntype(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TYPE);
    }

    public static PointerBuffer nelements(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)ELEMENTS), capacity);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    public static void nalignment(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)ALIGNMENT, value);
    }

    public static void ntype(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)TYPE, value);
    }

    public static void nelements(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ELEMENTS, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = FFIType.__struct(FFIType.__member(Pointer.POINTER_SIZE), FFIType.__member(2), FFIType.__member(2), FFIType.__member(Pointer.POINTER_SIZE));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        ELEMENTS = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<FFIType, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected FFIType newInstance(long address) {
            return new FFIType(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long size() {
            return FFIType.nsize(this.address());
        }

        public short alignment() {
            return FFIType.nalignment(this.address());
        }

        public short type() {
            return FFIType.ntype(this.address());
        }

        public PointerBuffer elements(int capacity) {
            return FFIType.nelements(this.address(), capacity);
        }

        public Buffer size(long value) {
            FFIType.nsize(this.address(), value);
            return this;
        }

        public Buffer alignment(short value) {
            FFIType.nalignment(this.address(), value);
            return this;
        }

        public Buffer type(short value) {
            FFIType.ntype(this.address(), value);
            return this;
        }

        public Buffer elements(PointerBuffer value) {
            FFIType.nelements(this.address(), value);
            return this;
        }
    }
}

