/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.xxhash;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XXH32State
extends Struct {
    public static final int SIZEOF = XXH32State.offsets();

    private static native int offsets();

    XXH32State(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public XXH32State(long struct) {
        this(struct, null);
    }

    public XXH32State(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static XXH32State malloc() {
        return new XXH32State(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static XXH32State calloc() {
        return new XXH32State(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static XXH32State create() {
        return new XXH32State(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static final class Buffer
    extends StructBuffer<XXH32State, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected XXH32State newInstance(long address) {
            return new XXH32State(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }
    }
}

