/*
 * Decompiled with CFR 0.152.
 */
package com.invrs.tov;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.invrs.tov.Assets;
import com.invrs.tov.Credits;
import com.invrs.tov.HomeScreen;
import com.invrs.tov.Introduction;
import com.invrs.tov.MenuItem;
import com.invrs.tov.SevenSages;

public class MainMenuScreen
implements Screen {
    final SevenSages game;
    MainMenuInputHandler mainHandler;
    OrthographicCamera camera;
    private Music theme;
    private Texture titleScreen;
    private Sprite black;
    private float darkness;
    private float volume;
    private Sprite background;
    private Sprite title;
    private Sprite pointer;
    private Sprite backcloud1;
    private Sprite backcloud2;
    private Sprite frontcloud1;
    private Sprite frontcloud2;
    private Sound error;
    private float bgAlpha;
    private float titleAlpha;
    private float cloudAlpha;
    private float bc1X;
    private float bc2X;
    private float fc1X;
    private float fc2X;
    private int pointerFocus;
    private int menuFocus;
    private boolean menuShowing;
    private boolean alphaSetter;
    private boolean settingsChanged;
    private boolean setMusicVolume;
    private boolean setFxVolume;
    private float stateTime;
    private boolean startingGame;
    private boolean showingCredits;
    private MenuItem newGame;
    private MenuItem loadGame;
    private MenuItem options;
    private MenuItem credits;
    private MenuItem quit;
    private MenuItem startYes;
    private MenuItem startNo;
    private MenuItem backLoadGame;
    private MenuItem slot1;
    private MenuItem slot2;
    private MenuItem slot3;
    private MenuItem slot4;
    private MenuItem backOptions;
    private MenuItem fullScreen;
    private MenuItem music;
    private MenuItem soundFx;

    public MainMenuScreen(SevenSages gam) {
        this.game = gam;
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, (float)this.game.settings.screenWidth, (float)this.game.settings.screenHeight);
        this.mainHandler = new MainMenuInputHandler();
        Gdx.input.setInputProcessor((InputProcessor)this.mainHandler);
        this.menuShowing = false;
        this.alphaSetter = false;
        this.menuFocus = 0;
        this.pointerFocus = 1;
        this.stateTime = 0.0f;
        this.volume = 1.0f;
        this.settingsChanged = false;
        this.startingGame = false;
        this.theme = (Music)Assets.manager.get("audio/Mount Helsus.mp3", Music.class);
        this.theme.setLooping(true);
        this.theme.play();
        this.error = (Sound)Assets.manager.get("audio/error1.wav", Sound.class);
        this.titleScreen = (Texture)Assets.manager.get("images/darktitlescreen.png", Texture.class);
        TextureRegion bgImage = new TextureRegion(this.titleScreen, 0, 0, 480, 300);
        TextureRegion titleImage = new TextureRegion(this.titleScreen, 0, 300, 230, 96);
        TextureRegion backcloud = new TextureRegion(this.titleScreen, 0, 396, 464, 117);
        TextureRegion cloudImage = new TextureRegion(this.titleScreen, 0, 513, 457, 97);
        TextureRegion pointerImage = new TextureRegion(this.titleScreen, 480, 0, 5, 7);
        this.background = new Sprite(bgImage);
        this.background.setPosition(0.0f, 0.0f);
        this.background.setSize((float)this.game.settings.screenWidth, (float)this.game.settings.screenHeight);
        this.title = new Sprite(titleImage);
        this.title.setPosition((float)this.game.settings.centerX - this.game.settings.x(690.0f) / 2.0f, (float)this.game.settings.screenHeight - (float)this.game.settings.screenHeight * 0.46f);
        this.title.setSize(this.game.settings.x(690.0f), this.game.settings.y(288.0f));
        this.pointer = new Sprite(pointerImage);
        this.pointer.setPosition((float)this.game.settings.centerX - this.game.settings.x(105.0f), (float)this.game.settings.centerY - this.game.settings.y(284.0f));
        this.pointer.setSize(this.game.settings.x(15.0f), this.game.settings.y(21.0f));
        this.black = new Sprite((Texture)Assets.manager.get("images/black.png", Texture.class));
        this.black.setSize((float)this.game.settings.screenWidth, (float)this.game.settings.screenHeight);
        this.darkness = 0.0f;
        this.black.setAlpha(0.0f);
        this.bc1X = (float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f;
        this.bc2X = (float)this.game.settings.screenWidth + ((float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f);
        this.fc1X = (float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f;
        this.fc2X = (float)this.game.settings.screenWidth + ((float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f);
        this.backcloud1 = new Sprite(backcloud);
        this.backcloud1.setPosition(this.bc1X, (float)this.game.settings.screenHeight - ((float)this.game.settings.screenHeight * 0.03f + this.game.settings.y(384.0f)));
        this.backcloud1.setSize(this.game.settings.x(1392.0f), this.game.settings.y(351.0f));
        this.backcloud2 = new Sprite(backcloud);
        this.backcloud2.setPosition(this.bc2X, (float)this.game.settings.screenHeight - ((float)this.game.settings.screenHeight * 0.03f + this.game.settings.y(384.0f)));
        this.backcloud2.setSize(this.game.settings.x(1392.0f), this.game.settings.y(351.0f));
        this.frontcloud1 = new Sprite(cloudImage);
        this.frontcloud1.setPosition(this.fc1X, (float)this.game.settings.screenHeight - ((float)this.game.settings.screenHeight * 0.45f + this.game.settings.y(291.0f)));
        this.frontcloud1.setSize(this.game.settings.x(1371.0f), this.game.settings.y(291.0f));
        this.frontcloud2 = new Sprite(cloudImage);
        this.frontcloud2.setPosition(this.fc2X, (float)this.game.settings.screenHeight - ((float)this.game.settings.screenHeight * 0.45f + this.game.settings.y(291.0f)));
        this.frontcloud2.setSize(this.game.settings.x(1371.0f), this.game.settings.y(291.0f));
        this.bgAlpha = 0.0f;
        this.titleAlpha = 0.0f;
        this.cloudAlpha = 0.0f;
        this.background.setAlpha(this.bgAlpha);
        this.title.setAlpha(this.titleAlpha);
        this.backcloud1.setAlpha(this.cloudAlpha);
        this.frontcloud1.setAlpha(this.cloudAlpha);
        this.frontcloud2.setAlpha(this.cloudAlpha);
        this.game.font1.getData().setScale(this.game.settings.x(0.6f), this.game.settings.y(0.5f));
        this.newGame = new MenuItem(this.game.batch, this.game.font1, "NEW GAME", (float)this.game.settings.centerX - this.game.settings.x(70.0f), (float)this.game.settings.centerY - this.game.settings.y(250.0f));
        this.loadGame = new MenuItem(this.game.batch, this.game.font1, "LOAD GAME", (float)this.game.settings.centerX - this.game.settings.x(70.0f), (float)this.game.settings.centerY - this.game.settings.y(280.0f));
        this.options = new MenuItem(this.game.batch, this.game.font1, "OPTIONS", (float)this.game.settings.centerX - this.game.settings.x(70.0f), (float)this.game.settings.centerY - this.game.settings.y(310.0f));
        this.credits = new MenuItem(this.game.batch, this.game.font1, "CREDITS", (float)this.game.settings.centerX - this.game.settings.x(70.0f), (float)this.game.settings.centerY - this.game.settings.y(340.0f));
        this.quit = new MenuItem(this.game.batch, this.game.font1, "QUIT", (float)this.game.settings.centerX - this.game.settings.x(70.0f), (float)this.game.settings.centerY - this.game.settings.y(370.0f));
        this.startYes = new MenuItem(this.game.batch, this.game.font1, "YES", this.game.settings.centerX, (float)this.game.settings.centerY - this.game.settings.y(280.0f));
        this.startNo = new MenuItem(this.game.batch, this.game.font1, "NO", this.game.settings.centerX, (float)this.game.settings.centerY - this.game.settings.y(310.0f));
        this.backLoadGame = new MenuItem(this.game.batch, this.game.font1, "BACK", (float)this.game.settings.centerX - this.game.settings.x(70.0f), (float)this.game.settings.centerY - this.game.settings.y(250.0f));
        this.slot1 = new MenuItem(this.game.batch, this.game.font1, this.game.settings.timeStamp[0], (float)this.game.settings.centerX - this.game.settings.x(50.0f), (float)this.game.settings.centerY - this.game.settings.y(280.0f));
        this.slot2 = new MenuItem(this.game.batch, this.game.font1, this.game.settings.timeStamp[1], (float)this.game.settings.centerX - this.game.settings.x(50.0f), (float)this.game.settings.centerY - this.game.settings.y(310.0f));
        this.slot3 = new MenuItem(this.game.batch, this.game.font1, this.game.settings.timeStamp[2], (float)this.game.settings.centerX - this.game.settings.x(50.0f), (float)this.game.settings.centerY - this.game.settings.y(340.0f));
        this.slot4 = new MenuItem(this.game.batch, this.game.font1, this.game.settings.timeStamp[3], (float)this.game.settings.centerX - this.game.settings.x(50.0f), (float)this.game.settings.centerY - this.game.settings.y(370.0f));
        this.backOptions = new MenuItem(this.game.batch, this.game.font1, "BACK", (float)this.game.settings.centerX - this.game.settings.x(100.0f), (float)this.game.settings.centerY - this.game.settings.y(190.0f));
        this.fullScreen = new MenuItem(this.game.batch, this.game.font1, "FULLSCREEN: " + this.game.settings.fullscreenOnOff, (float)this.game.settings.centerX - this.game.settings.x(100.0f), (float)this.game.settings.centerY - this.game.settings.y(250.0f));
        this.music = new MenuItem(this.game.batch, this.game.font1, "MUSIC: " + this.game.settings.musicVolume, (float)this.game.settings.centerX - this.game.settings.x(100.0f), (float)this.game.settings.centerY - this.game.settings.y(280.0f));
        this.soundFx = new MenuItem(this.game.batch, this.game.font1, "SOUND FX: " + this.game.settings.fxVolume, (float)this.game.settings.centerX - this.game.settings.x(100.0f), (float)this.game.settings.centerY - this.game.settings.y(310.0f));
    }

    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.stateTime += Gdx.graphics.getDeltaTime();
        this.theme.setVolume((float)this.game.settings.musicVolume / 100.0f);
        if (!this.menuShowing) {
            if (this.stateTime > 1.0f && this.stateTime < 6.0f) {
                this.bgAlpha += 0.004f;
                if (this.bgAlpha >= 1.0f) {
                    this.bgAlpha = 1.0f;
                }
                this.background.setAlpha(this.bgAlpha);
            }
            if (this.stateTime > 5.5f && this.stateTime < 8.0f) {
                this.titleAlpha += 0.008f;
                if (this.titleAlpha >= 1.0f) {
                    this.titleAlpha = 1.0f;
                }
                this.title.setAlpha(this.titleAlpha);
            }
            if (this.stateTime > 1.5f && this.stateTime < 6.0f) {
                this.cloudAlpha += 0.004f;
                if (this.cloudAlpha >= 1.0f) {
                    this.cloudAlpha = 1.0f;
                }
                this.backcloud1.setAlpha(this.cloudAlpha);
                this.frontcloud1.setAlpha(this.cloudAlpha);
                this.frontcloud2.setAlpha(this.cloudAlpha);
            }
        }
        this.bc1X -= this.game.settings.x(0.016f);
        this.bc2X -= this.game.settings.x(0.016f);
        this.backcloud1.setX(this.bc1X);
        this.backcloud2.setX(this.bc2X);
        if (this.bc1X <= (float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f - (float)this.game.settings.screenWidth) {
            this.bc1X = (float)this.game.settings.screenWidth + ((float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f);
        }
        if (this.bc2X <= (float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f - (float)this.game.settings.screenWidth) {
            this.bc2X = (float)this.game.settings.screenWidth + ((float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f);
        }
        this.fc1X -= this.game.settings.x(0.24000001f);
        this.fc2X -= this.game.settings.x(0.24000001f);
        this.frontcloud1.setX(this.fc1X);
        this.frontcloud2.setX(this.fc2X);
        if (this.fc1X <= (float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f - (float)this.game.settings.screenWidth) {
            this.fc1X = (float)this.game.settings.screenWidth + ((float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f);
        }
        if (this.fc2X <= (float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f - (float)this.game.settings.screenWidth) {
            this.fc2X = (float)this.game.settings.screenWidth + ((float)this.game.settings.centerX - this.game.settings.x(1371.0f) / 2.0f);
        }
        if (this.startingGame) {
            this.darkness = (float)((double)this.darkness + 0.011200000531971455);
            if (this.darkness >= 1.0f) {
                this.darkness = 1.0f;
            }
            this.black.setAlpha(this.darkness);
            if ((double)this.volume >= 0.05) {
                this.volume -= 0.004f;
            } else if ((double)this.volume < 0.05) {
                this.volume -= 8.0000004E-4f;
            }
            if (this.volume <= 0.0f) {
                this.volume = 0.0f;
            }
            this.theme.setVolume(this.volume * (float)this.game.settings.musicVolume / 100.0f);
            if (this.volume == 0.0f) {
                this.theme.stop();
                if (this.game.settings.loadedGame) {
                    this.game.setScreen(new HomeScreen(this.game));
                } else {
                    this.game.settings.resetState();
                    this.game.setScreen(new Introduction(this.game));
                }
                this.dispose();
            }
        }
        if (this.showingCredits) {
            this.darkness = (float)((double)this.darkness + 0.011200000531971455);
            if (this.darkness >= 1.0f) {
                this.darkness = 1.0f;
            }
            this.black.setAlpha(this.darkness);
            if ((double)this.volume >= 0.05) {
                this.volume -= 0.004f;
            } else if ((double)this.volume < 0.05) {
                this.volume -= 8.0000004E-4f;
            }
            if (this.volume <= 0.0f) {
                this.volume = 0.0f;
            }
            this.theme.setVolume(this.volume * (float)this.game.settings.musicVolume / 100.0f);
            if (this.volume == 0.0f) {
                this.theme.stop();
                this.game.setScreen(new Credits(this.game));
                this.dispose();
            }
        }
        if (this.stateTime > 8.4f) {
            this.menuShowing = true;
            this.alphaSetter = true;
        }
        if (this.alphaSetter) {
            this.bgAlpha += 0.032f;
            if (this.bgAlpha >= 1.0f) {
                this.bgAlpha = 1.0f;
            }
            this.background.setAlpha(this.bgAlpha);
            this.titleAlpha += 0.032f;
            if (this.titleAlpha >= 1.0f) {
                this.titleAlpha = 1.0f;
            }
            this.title.setAlpha(this.titleAlpha);
            this.cloudAlpha += 0.032f;
            if (this.cloudAlpha >= 1.0f) {
                this.cloudAlpha = 1.0f;
            }
            this.backcloud1.setAlpha(this.cloudAlpha);
            this.frontcloud1.setAlpha(this.cloudAlpha);
            this.frontcloud2.setAlpha(this.cloudAlpha);
            if (this.titleAlpha == 1.0f) {
                this.alphaSetter = false;
            }
        }
        this.game.batch.begin();
        this.background.draw((Batch)this.game.batch);
        this.backcloud1.draw((Batch)this.game.batch);
        this.backcloud2.draw((Batch)this.game.batch);
        this.frontcloud1.draw((Batch)this.game.batch);
        this.frontcloud2.draw((Batch)this.game.batch);
        this.title.draw((Batch)this.game.batch);
        if (this.menuShowing) {
            this.pointer.draw((Batch)this.game.batch);
            this.showMenu(this.menuFocus);
        }
        this.game.batch.end();
    }

    public void showMenu(int menuNum) {
        if (menuNum == 0) {
            this.newGame.draw();
            this.loadGame.draw();
            this.options.draw();
            this.credits.draw();
            this.quit.draw();
            if (this.showingCredits) {
                this.black.draw((Batch)this.game.batch);
            }
        }
        if (menuNum == 1) {
            this.game.font1.draw((Batch)this.game.batch, (CharSequence)"START NEW GAME?", (float)this.game.settings.centerX - this.game.settings.x(150.0f), (float)this.game.settings.centerY - this.game.settings.y(240.0f));
            this.startYes.draw();
            this.startNo.draw();
            this.black.draw((Batch)this.game.batch);
        }
        if (menuNum == 2) {
            this.backLoadGame.draw();
            this.slot1.draw();
            this.slot2.draw();
            this.slot3.draw();
            this.slot4.draw();
            this.black.draw((Batch)this.game.batch);
        }
        if (menuNum == 3) {
            this.backOptions.draw();
            this.fullScreen.draw();
            this.music.draw();
            this.soundFx.draw();
        }
    }

    public MenuItem getMenuItem(int focus) {
        MenuItem temp;
        switch (focus) {
            case 1: {
                temp = this.newGame;
                break;
            }
            case 2: {
                temp = this.loadGame;
                break;
            }
            case 3: {
                temp = this.options;
                break;
            }
            case 4: {
                temp = this.credits;
                break;
            }
            case 5: {
                temp = this.quit;
                break;
            }
            case 6: {
                temp = this.startYes;
                break;
            }
            case 7: {
                temp = this.startNo;
                break;
            }
            case 8: {
                temp = this.backLoadGame;
                break;
            }
            case 9: {
                temp = this.slot1;
                break;
            }
            case 10: {
                temp = this.slot2;
                break;
            }
            case 11: {
                temp = this.slot3;
                break;
            }
            case 12: {
                temp = this.slot4;
                break;
            }
            case 13: {
                temp = this.backOptions;
                break;
            }
            case 14: {
                temp = this.fullScreen;
                break;
            }
            case 15: {
                temp = this.music;
                break;
            }
            case 16: {
                temp = this.soundFx;
                break;
            }
            default: {
                return null;
            }
        }
        return temp;
    }

    public void resize(int width, int height) {
    }

    public void show() {
    }

    public void hide() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
    }

    public class MainMenuInputHandler
    extends InputAdapter {
        public boolean keyDown(int keycode) {
            if (!(MainMenuScreen.this.menuShowing || keycode != 62 && keycode != 66 && keycode != 32)) {
                MainMenuScreen.this.menuShowing = true;
                MainMenuScreen.this.alphaSetter = true;
            } else if (!MainMenuScreen.this.startingGame && MainMenuScreen.this.menuShowing) {
                if (keycode == 62 || keycode == 66 || keycode == 32) {
                    if (MainMenuScreen.this.pointerFocus == 5) {
                        Gdx.app.exit();
                    } else if (MainMenuScreen.this.pointerFocus == 7 || MainMenuScreen.this.pointerFocus == 8 || MainMenuScreen.this.pointerFocus == 13) {
                        if (MainMenuScreen.this.settingsChanged && MainMenuScreen.this.pointerFocus == 13) {
                            MainMenuScreen.this.game.settings.setSettings();
                            MainMenuScreen.this.settingsChanged = false;
                        }
                        MainMenuScreen.this.menuFocus = 0;
                        MainMenuScreen.this.pointerFocus = 1;
                        MainMenuScreen.this.pointer.setPosition(((MainMenuScreen)MainMenuScreen.this).newGame.pointerX, ((MainMenuScreen)MainMenuScreen.this).newGame.pointerY);
                    } else if (MainMenuScreen.this.pointerFocus == 1) {
                        MainMenuScreen.this.menuFocus = 1;
                        MainMenuScreen.this.pointerFocus = 6;
                        MainMenuScreen.this.pointer.setPosition(((MainMenuScreen)MainMenuScreen.this).startYes.pointerX, ((MainMenuScreen)MainMenuScreen.this).startYes.pointerY);
                    } else if (MainMenuScreen.this.pointerFocus == 6) {
                        MainMenuScreen.this.startingGame = true;
                    } else if (MainMenuScreen.this.pointerFocus == 2) {
                        MainMenuScreen.this.menuFocus = 2;
                        MainMenuScreen.this.pointerFocus = 8;
                        MainMenuScreen.this.pointer.setPosition(((MainMenuScreen)MainMenuScreen.this).backLoadGame.pointerX, ((MainMenuScreen)MainMenuScreen.this).backLoadGame.pointerY);
                    } else if (MainMenuScreen.this.pointerFocus > 8 && MainMenuScreen.this.pointerFocus < 13) {
                        if (!MainMenuScreen.this.game.settings.timeStamp[MainMenuScreen.this.pointerFocus - 9].contains("Empty")) {
                            MainMenuScreen.this.game.settings.playerSlot = MainMenuScreen.this.pointerFocus - 9;
                            MainMenuScreen.this.game.settings.loadedGame = true;
                            MainMenuScreen.this.startingGame = true;
                        } else {
                            MainMenuScreen.this.error.play();
                        }
                    } else if (MainMenuScreen.this.pointerFocus == 3) {
                        MainMenuScreen.this.menuFocus = 3;
                        MainMenuScreen.this.pointerFocus = 13;
                        MainMenuScreen.this.pointer.setPosition(((MainMenuScreen)MainMenuScreen.this).backOptions.pointerX, ((MainMenuScreen)MainMenuScreen.this).backOptions.pointerY);
                    } else if (MainMenuScreen.this.pointerFocus == 14) {
                        if (MainMenuScreen.this.game.settings.fullscreen) {
                            MainMenuScreen.this.game.settings.fullscreen = false;
                            MainMenuScreen.this.game.settings.fullscreenOnOff = "OFF";
                            MainMenuScreen.this.game.settings.setWindowed();
                            Gdx.input.setCursorCatched(false);
                        } else {
                            MainMenuScreen.this.game.settings.fullscreen = true;
                            MainMenuScreen.this.game.settings.fullscreenOnOff = "ON";
                            MainMenuScreen.this.game.settings.setFullScreen();
                            Gdx.input.setCursorCatched(true);
                        }
                        MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).text = "FULLSCREEN: " + MainMenuScreen.this.game.settings.fullscreenOnOff;
                        MainMenuScreen.this.settingsChanged = true;
                    } else if (MainMenuScreen.this.pointerFocus == 4) {
                        MainMenuScreen.this.showingCredits = true;
                    }
                }
                if ((keycode == 47 || keycode == 67 || keycode == 111) && MainMenuScreen.this.menuFocus > 0 && MainMenuScreen.this.menuFocus < 4) {
                    if (MainMenuScreen.this.settingsChanged && MainMenuScreen.this.menuFocus == 3) {
                        MainMenuScreen.this.game.settings.setSettings();
                        MainMenuScreen.this.settingsChanged = false;
                    }
                    MainMenuScreen.this.menuFocus = 0;
                    MainMenuScreen.this.pointerFocus = 1;
                    MainMenuScreen.this.pointer.setPosition(((MainMenuScreen)MainMenuScreen.this).newGame.pointerX, ((MainMenuScreen)MainMenuScreen.this).newGame.pointerY);
                }
                if (keycode == 20 && MainMenuScreen.this.menuFocus == 0) {
                    if (MainMenuScreen.this.pointerFocus == 5) {
                        MainMenuScreen.this.pointerFocus = 1;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus + 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (keycode == 19 && MainMenuScreen.this.menuFocus == 0) {
                    if (MainMenuScreen.this.pointerFocus == 1) {
                        MainMenuScreen.this.pointerFocus = 5;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus - 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (keycode == 20 && MainMenuScreen.this.menuFocus == 1) {
                    if (MainMenuScreen.this.pointerFocus == 7) {
                        MainMenuScreen.this.pointerFocus = 6;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus + 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (keycode == 19 && MainMenuScreen.this.menuFocus == 1) {
                    if (MainMenuScreen.this.pointerFocus == 6) {
                        MainMenuScreen.this.pointerFocus = 7;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus - 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (keycode == 20 && MainMenuScreen.this.menuFocus == 2) {
                    if (MainMenuScreen.this.pointerFocus == 12) {
                        MainMenuScreen.this.pointerFocus = 8;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus + 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (keycode == 19 && MainMenuScreen.this.menuFocus == 2) {
                    if (MainMenuScreen.this.pointerFocus == 8) {
                        MainMenuScreen.this.pointerFocus = 12;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus - 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (keycode == 20 && MainMenuScreen.this.menuFocus == 3 && !MainMenuScreen.this.setMusicVolume && !MainMenuScreen.this.setFxVolume) {
                    if (MainMenuScreen.this.pointerFocus == 16) {
                        MainMenuScreen.this.pointerFocus = 13;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus + 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (keycode == 19 && MainMenuScreen.this.menuFocus == 3 && !MainMenuScreen.this.setMusicVolume && !MainMenuScreen.this.setFxVolume) {
                    if (MainMenuScreen.this.pointerFocus == 13) {
                        MainMenuScreen.this.pointerFocus = 16;
                    } else {
                        MainMenuScreen mainMenuScreen = MainMenuScreen.this;
                        mainMenuScreen.pointerFocus = mainMenuScreen.pointerFocus - 1;
                    }
                    MainMenuScreen.this.pointer.setPosition(MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerX, MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).pointerY);
                }
                if (MainMenuScreen.this.menuFocus == 3) {
                    if (keycode == 22) {
                        if (MainMenuScreen.this.pointerFocus == 14) {
                            if (MainMenuScreen.this.game.settings.fullscreen) {
                                MainMenuScreen.this.game.settings.fullscreen = false;
                                MainMenuScreen.this.game.settings.fullscreenOnOff = "OFF";
                                MainMenuScreen.this.game.settings.setWindowed();
                                Gdx.input.setCursorCatched(false);
                            } else {
                                MainMenuScreen.this.game.settings.fullscreen = true;
                                MainMenuScreen.this.game.settings.fullscreenOnOff = "ON";
                                MainMenuScreen.this.game.settings.setFullScreen();
                                Gdx.input.setCursorCatched(true);
                            }
                            MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).text = "FULLSCREEN: " + MainMenuScreen.this.game.settings.fullscreenOnOff;
                            MainMenuScreen.this.settingsChanged = true;
                        } else if (MainMenuScreen.this.pointerFocus == 15) {
                            if (MainMenuScreen.this.game.settings.musicVolume < 100) {
                                MainMenuScreen.this.game.settings.musicVolume += 5;
                            }
                            MainMenuScreen.this.settingsChanged = true;
                            MainMenuScreen.this.music.text("MUSIC: " + MainMenuScreen.this.game.settings.musicVolume);
                        } else if (MainMenuScreen.this.pointerFocus == 16) {
                            if (MainMenuScreen.this.game.settings.fxVolume < 100) {
                                MainMenuScreen.this.game.settings.fxVolume += 5;
                            }
                            MainMenuScreen.this.settingsChanged = true;
                            MainMenuScreen.this.soundFx.text("SOUND FX: " + MainMenuScreen.this.game.settings.fxVolume);
                        }
                    }
                    if (keycode == 21) {
                        if (MainMenuScreen.this.pointerFocus == 14) {
                            if (MainMenuScreen.this.game.settings.fullscreen) {
                                MainMenuScreen.this.game.settings.fullscreen = false;
                                MainMenuScreen.this.game.settings.fullscreenOnOff = "OFF";
                                MainMenuScreen.this.game.settings.setFullScreen();
                                Gdx.input.setCursorCatched(false);
                            } else {
                                MainMenuScreen.this.game.settings.fullscreen = true;
                                MainMenuScreen.this.game.settings.fullscreenOnOff = "ON";
                                MainMenuScreen.this.game.settings.setFullScreen();
                                Gdx.input.setCursorCatched(true);
                            }
                            MainMenuScreen.this.getMenuItem((int)((MainMenuScreen)MainMenuScreen.this).pointerFocus).text = "FULLSCREEN: " + MainMenuScreen.this.game.settings.fullscreenOnOff;
                            MainMenuScreen.this.settingsChanged = true;
                        } else if (MainMenuScreen.this.pointerFocus == 15) {
                            if (MainMenuScreen.this.game.settings.musicVolume > 0) {
                                MainMenuScreen.this.game.settings.musicVolume -= 5;
                            }
                            MainMenuScreen.this.settingsChanged = true;
                            MainMenuScreen.this.music.text("MUSIC: " + MainMenuScreen.this.game.settings.musicVolume);
                        } else if (MainMenuScreen.this.pointerFocus == 16) {
                            if (MainMenuScreen.this.game.settings.fxVolume > 0) {
                                MainMenuScreen.this.game.settings.fxVolume -= 5;
                            }
                            MainMenuScreen.this.settingsChanged = true;
                            MainMenuScreen.this.soundFx.text("SOUND FX: " + MainMenuScreen.this.game.settings.fxVolume);
                        }
                    }
                }
            }
            return false;
        }
    }
}

