/*
 * Decompiled with CFR 0.152.
 */
package com.invrs.tov;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Settings {
    public int screenWidth;
    public int screenHeight;
    public int centerX;
    public int centerY;
    private Graphics.DisplayMode desktopDisplayMode;
    public int playerSlot;
    public int notesTotalPagesT;
    public int notesCurrentPageT;
    public int hoursPlayedT;
    public int minPlayedT;
    public int secPlayedT;
    public float xT;
    public float yT;
    public String[] timeStamp;
    public String[] notePagesT;
    public int[] bookSlotT;
    public int[][] shelfContentsT;
    public boolean lanternonT;
    public boolean[] candlelitT;
    public boolean[] checkpointT;
    public File pref;
    public File keyconfig;
    private File[] saveFile;
    private DocumentBuilder docBuilder;
    private Document settings;
    private Document keyinput;
    private Document[] saveDocument;
    public boolean fullscreen;
    public boolean loadedGame;
    public boolean loadedState;
    public boolean savedState;
    public String fullscreenOnOff;
    public int musicVolume;
    public int fxVolume;
    public float gamma;
    public int keyUp;
    public int keyDown;
    public int keyLeft;
    public int keyRight;
    public int keyExamine;
    public int keyCancel;
    public int keyRun;
    public int keyLantern;
    public int keyBooks;
    public int keySlot1;
    public int keySlot2;
    public int keyNotes;
    public int keyMenu;
    public int keyPause;

    public Settings() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        this.saveDocument = new Document[4];
        this.saveFile = new File[4];
        try {
            this.pref = new File(String.valueOf(System.getenv("APPDATA")) + "/Seven Sages/seven-sages-pref.xml");
            if (!this.pref.getParentFile().exists()) {
                this.pref.getParentFile().mkdirs();
            }
            this.keyconfig = new File(String.valueOf(System.getenv("APPDATA")) + "/Seven Sages/seven-sages-keyconfig.xml");
            if (!this.keyconfig.getParentFile().exists()) {
                this.keyconfig.getParentFile().mkdirs();
            }
            this.saveFile[0] = new File(String.valueOf(System.getenv("APPDATA")) + "/Seven Sages/seven-sages-saveslot1.xml");
            if (!this.saveFile[0].getParentFile().exists()) {
                this.saveFile[0].getParentFile().mkdirs();
            }
            this.saveFile[1] = new File(String.valueOf(System.getenv("APPDATA")) + "/Seven Sages/seven-sages-saveslot2.xml");
            if (!this.saveFile[1].getParentFile().exists()) {
                this.saveFile[1].getParentFile().mkdirs();
            }
            this.saveFile[2] = new File(String.valueOf(System.getenv("APPDATA")) + "/Seven Sages/seven-sages-saveslot3.xml");
            if (!this.saveFile[2].getParentFile().exists()) {
                this.saveFile[2].getParentFile().mkdirs();
            }
            this.saveFile[3] = new File(String.valueOf(System.getenv("APPDATA")) + "/Seven Sages/seven-sages-saveslot4.xml");
            if (!this.saveFile[3].getParentFile().exists()) {
                this.saveFile[3].getParentFile().mkdirs();
            }
            this.docBuilder = docFactory.newDocumentBuilder();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.settings = this.docBuilder.newDocument();
        this.keyinput = this.docBuilder.newDocument();
        this.saveDocument[0] = this.docBuilder.newDocument();
        this.saveDocument[1] = this.docBuilder.newDocument();
        this.saveDocument[2] = this.docBuilder.newDocument();
        this.saveDocument[3] = this.docBuilder.newDocument();
        this.desktopDisplayMode = Gdx.graphics.getDisplayMode();
        this.screenWidth = this.desktopDisplayMode.width;
        this.screenHeight = this.desktopDisplayMode.height;
        this.centerX = this.screenWidth / 2;
        this.centerY = this.screenHeight / 2;
        this.fullscreen = true;
        this.fullscreenOnOff = "ON";
        this.gamma = 0.8f;
        this.musicVolume = 100;
        this.fxVolume = 100;
        this.checkpointT = new boolean[11];
        int i = 0;
        while (i < 11) {
            this.checkpointT[i] = false;
            ++i;
        }
        this.playerSlot = 0;
        this.timeStamp = new String[4];
        this.timeStamp[0] = "Empty";
        this.timeStamp[1] = "Empty";
        this.timeStamp[2] = "Empty";
        this.timeStamp[3] = "Empty";
        this.notePagesT = new String[20];
        this.bookSlotT = new int[3];
        this.shelfContentsT = new int[16][4];
        this.candlelitT = new boolean[7];
        this.loadedGame = false;
        this.keyUp = 19;
        this.keyDown = 20;
        this.keyLeft = 21;
        this.keyRight = 22;
        this.keyExamine = 32;
        this.keyCancel = 47;
        this.keyRun = 29;
        this.keyLantern = 34;
        this.keyBooks = 51;
        this.keySlot1 = 45;
        this.keySlot2 = 33;
        this.keyNotes = 61;
        this.keyMenu = 111;
        this.keyPause = 62;
    }

    public void setFullScreen() {
        Gdx.graphics.setFullscreenMode(this.desktopDisplayMode);
    }

    public void setWindowed() {
        Gdx.graphics.setWindowedMode(this.screenWidth, this.screenHeight);
    }

    public float x(float n) {
        float propX = n * (float)this.screenWidth / 1440.0f;
        return propX;
    }

    public float y(float m) {
        float propY = m * (float)this.screenHeight / 900.0f;
        return propY;
    }

    public float DEx(float n) {
        float deX = n * 1440.0f / (float)this.screenWidth;
        return deX;
    }

    public float DEy(float m) {
        float deY = m * 900.0f / (float)this.screenHeight;
        return deY;
    }

    public void setSettings() {
        try {
            if (!this.pref.exists()) {
                this.pref.createNewFile();
            }
            this.settings = this.docBuilder.newDocument();
            Element rootElement = this.settings.createElement("Settings");
            this.settings.appendChild(rootElement);
            Element fs = this.settings.createElement("fullscreen");
            fs.appendChild(this.settings.createTextNode(Boolean.toString(this.fullscreen)));
            rootElement.appendChild(fs);
            Element fsOnOff = this.settings.createElement("fullscreenOnOff");
            fsOnOff.appendChild(this.settings.createTextNode(this.fullscreenOnOff));
            rootElement.appendChild(fsOnOff);
            Element[] stamp = new Element[4];
            int i = 0;
            while (i < 4) {
                stamp[i] = this.settings.createElement("timestamp-" + i);
                stamp[i].appendChild(this.settings.createTextNode(this.timeStamp[i]));
                rootElement.appendChild(stamp[i]);
                ++i;
            }
            Element gammaElement = this.settings.createElement("gamma");
            gammaElement.appendChild(this.settings.createTextNode(Float.toString(this.gamma)));
            rootElement.appendChild(gammaElement);
            Element musicElement = this.settings.createElement("musicvolume");
            musicElement.appendChild(this.settings.createTextNode(Integer.toString(this.musicVolume)));
            rootElement.appendChild(musicElement);
            Element fxElement = this.settings.createElement("fxvolume");
            fxElement.appendChild(this.settings.createTextNode(Integer.toString(this.fxVolume)));
            rootElement.appendChild(fxElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.settings);
            StreamResult file = new StreamResult(this.pref);
            transformer.transform(source, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setKeyConfig();
    }

    private void setKeyConfig() {
        try {
            if (!this.keyconfig.exists()) {
                this.keyconfig.createNewFile();
            }
            this.keyinput = this.docBuilder.newDocument();
            Element rootElement = this.keyinput.createElement("KeyConfig");
            this.keyinput.appendChild(rootElement);
            Element upElement = this.keyinput.createElement("upkey");
            upElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyUp)));
            rootElement.appendChild(upElement);
            Element downElement = this.keyinput.createElement("downkey");
            downElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyDown)));
            rootElement.appendChild(downElement);
            Element leftElement = this.keyinput.createElement("leftkey");
            leftElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyLeft)));
            rootElement.appendChild(leftElement);
            Element rightElement = this.keyinput.createElement("rightkey");
            rightElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyRight)));
            rootElement.appendChild(rightElement);
            Element examineElement = this.keyinput.createElement("examinekey");
            examineElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyExamine)));
            rootElement.appendChild(examineElement);
            Element cancelElement = this.keyinput.createElement("cancelkey");
            cancelElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyCancel)));
            rootElement.appendChild(cancelElement);
            Element runElement = this.keyinput.createElement("runkey");
            runElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyRun)));
            rootElement.appendChild(runElement);
            Element lanternElement = this.keyinput.createElement("lanternkey");
            lanternElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyLantern)));
            rootElement.appendChild(lanternElement);
            Element booksElement = this.keyinput.createElement("bookskey");
            booksElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyBooks)));
            rootElement.appendChild(booksElement);
            Element slot1Element = this.keyinput.createElement("slot1key");
            slot1Element.appendChild(this.keyinput.createTextNode(Integer.toString(this.keySlot1)));
            rootElement.appendChild(slot1Element);
            Element slot2Element = this.keyinput.createElement("slot2key");
            slot2Element.appendChild(this.keyinput.createTextNode(Integer.toString(this.keySlot2)));
            rootElement.appendChild(slot2Element);
            Element notesElement = this.keyinput.createElement("noteskey");
            notesElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyNotes)));
            rootElement.appendChild(notesElement);
            Element menuElement = this.keyinput.createElement("menukey");
            menuElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyMenu)));
            rootElement.appendChild(menuElement);
            Element pauseElement = this.keyinput.createElement("pausekey");
            pauseElement.appendChild(this.keyinput.createTextNode(Integer.toString(this.keyPause)));
            rootElement.appendChild(pauseElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.keyinput);
            StreamResult file = new StreamResult(this.keyconfig);
            transformer.transform(source, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSettings() {
        Element element;
        Node node;
        int i;
        NodeList nodes;
        if (this.pref.exists()) {
            try {
                this.settings = this.docBuilder.parse(this.pref);
                this.settings.getDocumentElement().normalize();
                nodes = this.settings.getElementsByTagName("Settings");
                i = 0;
                while (i < nodes.getLength()) {
                    node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        element = (Element)node;
                        this.fullscreen = Boolean.parseBoolean(Settings.getValue("fullscreen", element));
                        this.fullscreenOnOff = Settings.getValue("fullscreenOnOff", element);
                        int j = 0;
                        while (j < 4) {
                            this.timeStamp[j] = Settings.getValue("timestamp-" + j, element);
                            ++j;
                        }
                        this.gamma = Float.parseFloat(Settings.getValue("gamma", element));
                        this.musicVolume = Integer.parseInt(Settings.getValue("musicvolume", element));
                        this.fxVolume = Integer.parseInt(Settings.getValue("fxvolume", element));
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.keyconfig.exists()) {
            try {
                this.keyinput = this.docBuilder.parse(this.keyconfig);
                this.keyinput.getDocumentElement().normalize();
                nodes = this.keyinput.getElementsByTagName("KeyConfig");
                i = 0;
                while (i < nodes.getLength()) {
                    node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        element = (Element)node;
                        this.keyUp = Integer.parseInt(Settings.getValue("upkey", element));
                        this.keyDown = Integer.parseInt(Settings.getValue("downkey", element));
                        this.keyLeft = Integer.parseInt(Settings.getValue("leftkey", element));
                        this.keyRight = Integer.parseInt(Settings.getValue("rightkey", element));
                        this.keyExamine = Integer.parseInt(Settings.getValue("examinekey", element));
                        this.keyCancel = Integer.parseInt(Settings.getValue("cancelkey", element));
                        this.keyRun = Integer.parseInt(Settings.getValue("runkey", element));
                        this.keyLantern = Integer.parseInt(Settings.getValue("lanternkey", element));
                        this.keyBooks = Integer.parseInt(Settings.getValue("bookskey", element));
                        this.keySlot1 = Integer.parseInt(Settings.getValue("slot1key", element));
                        this.keySlot2 = Integer.parseInt(Settings.getValue("slot2key", element));
                        this.keyNotes = Integer.parseInt(Settings.getValue("noteskey", element));
                        this.keyMenu = Integer.parseInt(Settings.getValue("menukey", element));
                        this.keyPause = Integer.parseInt(Settings.getValue("pausekey", element));
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String getValue(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag).item(0).getChildNodes();
        Node node = nodes.item(0);
        return node.getNodeValue();
    }

    public void saveGame(int hoursPlayed, int minPlayed, int secPlayed, float x, float y, int notesTotalPages, int notesCurrentPage, String[] notePages, int[] bookSlot, int[][] shelfContents, boolean[] candlelit, boolean lanternon, boolean[] checkpoint) {
        this.timeStamp[this.playerSlot] = String.valueOf(Integer.toString(hoursPlayed)) + "h " + Integer.toString(minPlayed) + "m " + Integer.toString(secPlayed) + "s";
        try {
            if (!this.saveFile[this.playerSlot].exists()) {
                this.saveFile[this.playerSlot].createNewFile();
            }
            this.saveDocument[this.playerSlot] = this.docBuilder.newDocument();
            Element rootElement = this.saveDocument[this.playerSlot].createElement("Data");
            this.saveDocument[this.playerSlot].appendChild(rootElement);
            Element playerProfileElement = this.saveDocument[this.playerSlot].createElement("saveslot");
            playerProfileElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(this.playerSlot)));
            rootElement.appendChild(playerProfileElement);
            Element hoursElement = this.saveDocument[this.playerSlot].createElement("hoursplayed");
            hoursElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(hoursPlayed)));
            rootElement.appendChild(hoursElement);
            Element minElement = this.saveDocument[this.playerSlot].createElement("minplayed");
            minElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(minPlayed)));
            rootElement.appendChild(minElement);
            Element secElement = this.saveDocument[this.playerSlot].createElement("secplayed");
            secElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(secPlayed)));
            rootElement.appendChild(secElement);
            Element xElement = this.saveDocument[this.playerSlot].createElement("positionx");
            xElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Float.toString(x)));
            rootElement.appendChild(xElement);
            Element yElement = this.saveDocument[this.playerSlot].createElement("positiony");
            yElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Float.toString(y)));
            rootElement.appendChild(yElement);
            Element[] pages = new Element[20];
            int i = 0;
            while (i < notesTotalPages) {
                pages[i] = this.saveDocument[this.playerSlot].createElement("page-" + i);
                pages[i].appendChild(this.saveDocument[this.playerSlot].createTextNode(notePages[i]));
                rootElement.appendChild(pages[i]);
                ++i;
            }
            Element totalPagesElement = this.saveDocument[this.playerSlot].createElement("totalnotepages");
            totalPagesElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(notesTotalPages)));
            rootElement.appendChild(totalPagesElement);
            Element currentPageElement = this.saveDocument[this.playerSlot].createElement("currentnotepage");
            currentPageElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(notesCurrentPage)));
            rootElement.appendChild(currentPageElement);
            Element book1Element = this.saveDocument[this.playerSlot].createElement("bookslot1");
            book1Element.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(bookSlot[1])));
            rootElement.appendChild(book1Element);
            Element book2Element = this.saveDocument[this.playerSlot].createElement("bookslot2");
            book2Element.appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(bookSlot[2])));
            rootElement.appendChild(book2Element);
            Element[][] shelfBooks = new Element[16][4];
            int i2 = 1;
            while (i2 <= 15) {
                int j = 0;
                while (j < 4) {
                    shelfBooks[i2][j] = this.saveDocument[this.playerSlot].createElement("book-" + i2 + "-" + j);
                    shelfBooks[i2][j].appendChild(this.saveDocument[this.playerSlot].createTextNode(Integer.toString(shelfContents[i2][j])));
                    rootElement.appendChild(shelfBooks[i2][j]);
                    ++j;
                }
                ++i2;
            }
            Element[] candlesElement = new Element[7];
            int i3 = 0;
            while (i3 < 7) {
                candlesElement[i3] = this.saveDocument[this.playerSlot].createElement("candle" + i3);
                candlesElement[i3].appendChild(this.saveDocument[this.playerSlot].createTextNode(Boolean.toString(candlelit[i3])));
                rootElement.appendChild(candlesElement[i3]);
                ++i3;
            }
            Element lanternElement = this.saveDocument[this.playerSlot].createElement("lantern");
            lanternElement.appendChild(this.saveDocument[this.playerSlot].createTextNode(Boolean.toString(lanternon)));
            rootElement.appendChild(lanternElement);
            Element[] checkpointElement = new Element[20];
            int i4 = 0;
            while (i4 < 11) {
                checkpointElement[i4] = this.saveDocument[this.playerSlot].createElement("checkpoint-" + i4);
                checkpointElement[i4].appendChild(this.saveDocument[this.playerSlot].createTextNode(Boolean.toString(checkpoint[i4])));
                rootElement.appendChild(checkpointElement[i4]);
                ++i4;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.saveDocument[this.playerSlot]);
            StreamResult file = new StreamResult(this.saveFile[this.playerSlot]);
            transformer.transform(source, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadGame() {
        if (this.saveFile[this.playerSlot].exists()) {
            try {
                this.saveDocument[this.playerSlot] = this.docBuilder.parse(this.saveFile[this.playerSlot]);
                this.saveDocument[this.playerSlot].getDocumentElement().normalize();
                NodeList nodes = this.saveDocument[this.playerSlot].getElementsByTagName("Data");
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        this.playerSlot = Integer.parseInt(Settings.getValue("saveslot", element));
                        this.hoursPlayedT = Integer.parseInt(Settings.getValue("hoursplayed", element));
                        this.minPlayedT = Integer.parseInt(Settings.getValue("minplayed", element));
                        this.secPlayedT = Integer.parseInt(Settings.getValue("secplayed", element));
                        this.xT = Float.parseFloat(Settings.getValue("positionx", element));
                        this.yT = Float.parseFloat(Settings.getValue("positiony", element));
                        this.notesTotalPagesT = Integer.parseInt(Settings.getValue("totalnotepages", element));
                        int j = 0;
                        while (j < this.notesTotalPagesT) {
                            if (element.getElementsByTagName("page-" + j).item(0).hasChildNodes()) {
                                this.notePagesT[j] = Settings.getValue("page-" + j, element);
                            }
                            ++j;
                        }
                        this.notesCurrentPageT = Integer.parseInt(Settings.getValue("currentnotepage", element));
                        this.bookSlotT[1] = Integer.parseInt(Settings.getValue("bookslot1", element));
                        this.bookSlotT[2] = Integer.parseInt(Settings.getValue("bookslot2", element));
                        j = 1;
                        while (j <= 15) {
                            int k = 0;
                            while (k < 4) {
                                this.shelfContentsT[j][k] = Integer.parseInt(Settings.getValue("book-" + j + "-" + k, element));
                                ++k;
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < 7) {
                            this.candlelitT[j] = Boolean.parseBoolean(Settings.getValue("candle" + j, element));
                            ++j;
                        }
                        this.lanternonT = Boolean.parseBoolean(Settings.getValue("lantern", element));
                        j = 0;
                        while (j < 11) {
                            this.checkpointT[j] = Boolean.parseBoolean(Settings.getValue("checkpoint-" + j, element));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void saveState(int hoursPlayed, int minPlayed, int secPlayed, float x, float y, int notesTotalPages, int notesCurrentPage, String[] notePages, int[] bookSlot, int[][] shelfContents, boolean[] candlelit, boolean lanternon, boolean[] checkpoint) {
        this.hoursPlayedT = hoursPlayed;
        this.minPlayedT = minPlayed;
        this.secPlayedT = secPlayed;
        this.xT = x;
        this.yT = y;
        this.notesTotalPagesT = notesTotalPages;
        this.notesCurrentPageT = notesCurrentPage;
        this.notePagesT = notePages;
        this.bookSlotT = bookSlot;
        this.shelfContentsT = shelfContents;
        this.candlelitT = candlelit;
        this.lanternonT = lanternon;
        this.savedState = true;
    }

    public void resetState() {
        this.hoursPlayedT = 0;
        this.minPlayedT = 0;
        this.secPlayedT = 0;
        this.xT = 368.0f;
        this.yT = 668.0f;
        this.notesTotalPagesT = 1;
        this.notesCurrentPageT = 1;
        this.notePagesT = new String[20];
        this.notePagesT[0] = "";
        this.bookSlotT = new int[3];
        int i = 0;
        while (i < 3) {
            this.bookSlotT[i] = 0;
            ++i;
        }
        this.shelfContentsT = new int[16][4];
        int startofshelfbooks = 1;
        int i2 = 1;
        while (i2 <= 15) {
            int j = 0;
            while (j < 4) {
                this.shelfContentsT[i2][j] = startofshelfbooks++;
                ++j;
            }
            ++i2;
        }
        this.candlelitT = new boolean[7];
        i2 = 0;
        while (i2 <= 6) {
            this.candlelitT[i2] = false;
            ++i2;
        }
        this.lanternonT = false;
        this.checkpointT = new boolean[11];
        i2 = 0;
        while (i2 < 11) {
            this.checkpointT[i2] = false;
            ++i2;
        }
    }
}

